/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.support;

import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.config.ReflectionRegistryAdapter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.ReflectionRegistry;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;
import org.graalvm.util.GuardedAnnotationAccess;
import org.springframework.graalvm.domain.reflect.ClassDescriptor;
import org.springframework.graalvm.domain.reflect.FieldDescriptor;
import org.springframework.graalvm.domain.reflect.Flag;
import org.springframework.graalvm.domain.reflect.JsonMarshaller;
import org.springframework.graalvm.domain.reflect.MethodDescriptor;
import org.springframework.graalvm.domain.reflect.ReflectionDescriptor;
import org.springframework.graalvm.support.ConfigOptions;
import org.springframework.graalvm.support.SpringFeature;

public class ReflectionHandler {
    private static final String RESOURCE_FILE = "/reflect.json";
    private ReflectionRegistryAdapter rra;
    private ReflectionDescriptor constantReflectionDescriptor;
    private ImageClassLoader cl;
    private int typesRegisteredForReflectiveAccessCount = 0;
    private List<ClassDescriptor> activeClassDescriptors = new ArrayList<ClassDescriptor>();
    private String[] logBackPatterns = new String[]{"DateConverter", "LevelConverter", "ThreadConverter", "LoggerConverter", "MessageConverter", "LineSeparatorConverter", "org.springframework.boot.logging.logback.ColorConverter", "org.springframework.boot.logging.logback.ExtendedWhitespaceThrowableProxyConverter"};

    public ReflectionDescriptor getConstantData() {
        if (this.constantReflectionDescriptor == null) {
            try {
                InputStream s = this.getClass().getResourceAsStream(RESOURCE_FILE);
                this.constantReflectionDescriptor = JsonMarshaller.read(s);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unexpectedly can't load /reflect.json", e);
            }
        }
        return this.constantReflectionDescriptor;
    }

    public void includeInDump(String typename, String[][] methodsAndConstructors, Flag[] flags) {
        if (!ConfigOptions.shouldDumpConfig()) {
            return;
        }
        ClassDescriptor currentCD = null;
        for (ClassDescriptor cd : this.activeClassDescriptors) {
            if (!cd.getName().equals(typename)) continue;
            currentCD = cd;
            break;
        }
        if (currentCD == null) {
            currentCD = ClassDescriptor.of(typename);
            this.activeClassDescriptors.add(currentCD);
        }
        for (Flag flag : flags) {
            currentCD.setFlag(flag);
        }
        if (methodsAndConstructors != null) {
            for (Flag flag : methodsAndConstructors) {
                MethodDescriptor md = MethodDescriptor.of((String)((Object)flag[0]), ReflectionHandler.subarray((String[])flag));
                if (currentCD.contains(md)) continue;
                currentCD.addMethodDescriptor(md);
            }
        }
    }

    public static String[] subarray(String[] array) {
        if (array.length == 1) {
            return null;
        }
        return Arrays.copyOfRange(array, 1, array.length);
    }

    public void dump() {
        if (!ConfigOptions.shouldDumpConfig()) {
            return;
        }
        this.activeClassDescriptors.sort((c1, c2) -> c1.getName().compareTo(c2.getName()));
        ReflectionDescriptor rd = new ReflectionDescriptor();
        for (ClassDescriptor cd : this.activeClassDescriptors) {
            rd.add(cd);
        }
        try (FileOutputStream fos = new FileOutputStream(new File(ConfigOptions.getDumpConfigLocation()));){
            JsonMarshaller.write(rd, fos);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void registerFunctional(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        RuntimeReflectionSupport rrs = (RuntimeReflectionSupport)ImageSingletons.lookup(RuntimeReflectionSupport.class);
        this.cl = access.getImageClassLoader();
        this.rra = new ReflectionRegistryAdapter((ReflectionRegistry)rrs, this.cl);
        this.getConstantData();
        if (this.rra.resolveType("org.springframework.web.servlet.DispatcherServlet") != null) {
            this.addAccess("org.springframework.boot.web.embedded.tomcat.TomcatEmbeddedWebappClassLoader", Flag.allDeclaredConstructors, Flag.allDeclaredMethods);
        }
    }

    public void register(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        RuntimeReflectionSupport rrs = (RuntimeReflectionSupport)ImageSingletons.lookup(RuntimeReflectionSupport.class);
        this.cl = access.getImageClassLoader();
        this.rra = new ReflectionRegistryAdapter((ReflectionRegistry)rrs, this.cl);
        ReflectionDescriptor reflectionDescriptor = this.getConstantData();
        System.out.println("Found #" + reflectionDescriptor.getClassDescriptors().size() + " types in static reflection list to register");
        int missingFromClasspathCount = 0;
        int flagHandlingCount = 0;
        for (ClassDescriptor classDescriptor : reflectionDescriptor.getClassDescriptors()) {
            List<FieldDescriptor> fields;
            List<MethodDescriptor> methods;
            Class type = null;
            String n2 = classDescriptor.getName();
            if (n2.endsWith("[]")) {
                type = this.rra.resolveType(n2.substring(0, n2.length() - 2));
                if (type != null) {
                    Object o = Array.newInstance(type, 1);
                    type = o.getClass();
                }
            } else {
                type = this.rra.resolveType(classDescriptor.getName());
            }
            if (type == null) {
                ++missingFromClasspathCount;
                SpringFeature.log("/reflect.json included " + classDescriptor.getName() + " but it doesn't exist on the classpath, skipping...");
                continue;
            }
            if (this.checkType(type)) {
                this.activeClassDescriptors.add(classDescriptor);
                this.rra.registerType(type);
                Set<Flag> flags = classDescriptor.getFlags();
                if (flags != null) {
                    for (Flag flag : flags) {
                        try {
                            switch (flag) {
                                case allDeclaredClasses: {
                                    this.rra.registerDeclaredClasses(type);
                                    break;
                                }
                                case allDeclaredFields: {
                                    this.rra.registerDeclaredFields(type);
                                    break;
                                }
                                case allPublicFields: {
                                    this.rra.registerPublicFields(type);
                                    break;
                                }
                                case allDeclaredConstructors: {
                                    this.rra.registerDeclaredConstructors(type);
                                    break;
                                }
                                case allPublicConstructors: {
                                    this.rra.registerPublicConstructors(type);
                                    break;
                                }
                                case allDeclaredMethods: {
                                    this.rra.registerDeclaredMethods(type);
                                    break;
                                }
                                case allPublicMethods: {
                                    this.rra.registerPublicMethods(type);
                                    break;
                                }
                                case allPublicClasses: {
                                    this.rra.registerPublicClasses(type);
                                }
                            }
                        }
                        catch (NoClassDefFoundError ncdfe) {
                            ++flagHandlingCount;
                            SpringFeature.log("/reflect.json problem handling flag: " + (Object)((Object)flag) + " for " + type.getName() + " because of missing " + ncdfe.getMessage());
                        }
                    }
                }
                ++this.typesRegisteredForReflectiveAccessCount;
            }
            if ((methods = classDescriptor.getMethods()) != null) {
                for (MethodDescriptor methodDescriptor : methods) {
                    String n = methodDescriptor.getName();
                    List<String> parameterTypes = methodDescriptor.getParameterTypes();
                    if (parameterTypes == null) {
                        if (n.equals("<init>")) {
                            this.rra.registerAllConstructors(type);
                            continue;
                        }
                        this.rra.registerAllMethodsWithName(type, n);
                        continue;
                    }
                    List collect = parameterTypes.stream().map(pname -> this.rra.resolveType(pname)).collect(Collectors.toList());
                    try {
                        if (n.equals("<init>")) {
                            this.rra.registerConstructor(type, collect);
                            continue;
                        }
                        this.rra.registerMethod(type, n, collect);
                    }
                    catch (NoSuchMethodException nsme) {
                        throw new IllegalStateException("Couldn't find: " + methodDescriptor.toString(), nsme);
                    }
                }
            }
            if ((fields = classDescriptor.getFields()) == null) continue;
            for (FieldDescriptor fieldDescriptor : fields) {
                try {
                    this.rra.registerField(type, fieldDescriptor.getName(), fieldDescriptor.isAllowWrite(), fieldDescriptor.isAllowUnsafeAccess());
                }
                catch (NoSuchFieldException nsfe) {
                    throw new IllegalStateException("Couldn't find field: " + type.getName() + "." + fieldDescriptor.getName(), nsfe);
                }
            }
        }
        if (missingFromClasspathCount != 0) {
            System.out.println("Skipping #" + missingFromClasspathCount + " types not on the classpath");
        }
        if (flagHandlingCount != 0) {
            System.out.println("Number of problems processing field/method/constructor access requests: #" + flagHandlingCount);
        }
        this.registerLogAdapterClassesIfNeeded();
        this.registerLogbackIfNeeded();
        if (!ConfigOptions.shouldRemoveYamlSupport()) {
            this.addAccess("org.yaml.snakeyaml.Yaml", Flag.allDeclaredConstructors, Flag.allDeclaredMethods);
        }
    }

    private boolean checkType(Class clazz) {
        try {
            clazz.getDeclaredFields();
            clazz.getFields();
            clazz.getDeclaredMethods();
            clazz.getMethods();
            clazz.getDeclaredConstructors();
            clazz.getConstructors();
            clazz.getDeclaredClasses();
            clazz.getClasses();
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
        return true;
    }

    public Class<?> addAccess(String typename, Flag ... flags) {
        return this.addAccess(typename, null, false, flags);
    }

    public Class<?> addAccess(String typename, String[][] methodsAndConstructors, boolean silent, Flag ... flags) {
        if (!silent) {
            SpringFeature.log("Registering reflective access to " + typename + ": " + (flags == null ? "" : Arrays.asList(flags)));
        }
        this.includeInDump(typename, methodsAndConstructors, flags);
        Class type = this.rra.resolveType(typename);
        if (type == null) {
            SpringFeature.log("WARNING: Possible problem, cannot resolve " + typename);
            return null;
        }
        if (this.constantReflectionDescriptor.hasClassDescriptor(typename)) {
            SpringFeature.log("WARNING: type " + typename + " being added dynamically whilst " + RESOURCE_FILE + " already contains it - does it need to be in the file? ");
        }
        ClassForNameSupport.registerClass((Class)type);
        if (methodsAndConstructors != null) {
            for (String[] stringArray : methodsAndConstructors) {
                String name = stringArray[0];
                ArrayList<Class> params = new ArrayList<Class>();
                for (int p = 1; p < stringArray.length; ++p) {
                    params.add(this.rra.resolveType(stringArray[p]));
                }
                try {
                    if (name.equals("<init>")) {
                        this.rra.registerConstructor(type, params);
                        continue;
                    }
                    this.rra.registerMethod(type, name, params);
                }
                catch (NoSuchMethodException nsme) {
                    throw new IllegalStateException("Problem registering member " + name + " for reflective access on type " + type, nsme);
                }
            }
        }
        if (this.checkType(type)) {
            this.rra.registerType(type);
            for (String[] stringArray : flags) {
                try {
                    switch (1.$SwitchMap$org$springframework$graalvm$domain$reflect$Flag[stringArray.ordinal()]) {
                        case 1: {
                            if (!this.verify(type.getDeclaredClasses())) break;
                            this.rra.registerDeclaredClasses(type);
                            break;
                        }
                        case 2: {
                            if (!this.verify(type.getDeclaredFields())) break;
                            this.rra.registerDeclaredFields(type);
                            break;
                        }
                        case 3: {
                            if (!this.verify(type.getFields())) break;
                            this.rra.registerPublicFields(type);
                            break;
                        }
                        case 4: {
                            if (!this.verify(type.getDeclaredConstructors())) break;
                            this.rra.registerDeclaredConstructors(type);
                            break;
                        }
                        case 5: {
                            if (!this.verify(type.getConstructors())) break;
                            this.rra.registerPublicConstructors(type);
                            break;
                        }
                        case 6: {
                            if (!this.verify(type.getDeclaredMethods())) break;
                            this.rra.registerDeclaredMethods(type);
                            break;
                        }
                        case 7: {
                            if (!this.verify(type.getMethods())) break;
                            this.rra.registerPublicMethods(type);
                            break;
                        }
                        case 8: {
                            if (!this.verify(type.getClasses())) break;
                            this.rra.registerPublicClasses(type);
                        }
                    }
                }
                catch (NoClassDefFoundError ncdfe) {
                    SpringFeature.log("WARNING: problem handling flag: " + stringArray + " for " + type.getName() + " because of missing " + ncdfe.getMessage());
                }
            }
        }
        ++this.typesRegisteredForReflectiveAccessCount;
        return type;
    }

    public int getTypesRegisteredForReflectiveAccessCount() {
        return this.typesRegisteredForReflectiveAccessCount;
    }

    private boolean verify(Object[] things) {
        for (Object o : things) {
            try {
                if (o instanceof Method) {
                    ((Method)o).getGenericReturnType();
                }
                if (o instanceof Field) {
                    ((Field)o).getGenericType();
                }
                if (o instanceof AccessibleObject) {
                    AccessibleObject accessibleObject = (AccessibleObject)o;
                    GuardedAnnotationAccess.getDeclaredAnnotations((AnnotatedElement)accessibleObject);
                }
                if (o instanceof Parameter) {
                    Parameter parameter = (Parameter)o;
                    parameter.getType();
                }
                if (!(o instanceof Executable)) continue;
                Executable e = (Executable)o;
                e.getGenericParameterTypes();
                e.getGenericExceptionTypes();
                e.getParameters();
            }
            catch (Exception e) {
                SpringFeature.log("WARNING: Possible reflection problem later due to (generics related) reference from " + o + " to " + e.getMessage());
                return false;
            }
        }
        return true;
    }

    private void registerLogAdapterClassesIfNeeded() {
        String LOG4J_SPI = "org.apache.logging.log4j.spi.ExtendedLogger";
        String LOG4J_SLF4J_PROVIDER = "org.apache.logging.slf4j.SLF4JProvider";
        String SLF4J_SPI = "org.slf4j.spi.LocationAwareLogger";
        String SLF4J_API = "org.slf4j.Logger";
        String JUL_API = "java.util.logging.Logger";
        if (ReflectionHandler.isPresent("org.apache.logging.log4j.spi.ExtendedLogger")) {
            this.addAccess("org.apache.logging.log4j.spi.ExtendedLogger", Flag.allDeclaredConstructors, Flag.allDeclaredMethods);
            if (ReflectionHandler.isPresent("org.apache.logging.slf4j.SLF4JProvider") && ReflectionHandler.isPresent("org.slf4j.spi.LocationAwareLogger")) {
                this.addAccess("org.apache.logging.slf4j.SLF4JProvider", Flag.allDeclaredConstructors, Flag.allDeclaredMethods);
                this.addAccess("org.slf4j.spi.LocationAwareLogger", Flag.allDeclaredConstructors, Flag.allDeclaredMethods);
            }
        } else if (ReflectionHandler.isPresent("org.slf4j.spi.LocationAwareLogger")) {
            this.addAccess("org.slf4j.spi.LocationAwareLogger", Flag.allDeclaredConstructors, Flag.allDeclaredMethods);
        } else if (ReflectionHandler.isPresent("org.slf4j.Logger")) {
            this.addAccess("org.slf4j.Logger", Flag.allDeclaredConstructors, Flag.allDeclaredMethods);
        } else {
            this.addAccess("java.util.logging.Logger", Flag.allDeclaredConstructors, Flag.allDeclaredMethods);
        }
    }

    private static boolean isPresent(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private void registerLogbackIfNeeded() {
        if (!ReflectionHandler.isPresent("ch.qos.logback.core.Appender")) {
            return;
        }
        try {
            this.addAccess("ch.qos.logback.core.Appender", Flag.allDeclaredConstructors, Flag.allDeclaredMethods);
        }
        catch (NoClassDefFoundError e) {
            System.out.println("Logback not found, skipping registration logback types");
            return;
        }
        this.addAccess("org.springframework.boot.logging.logback.LogbackLoggingSystem", Flag.allDeclaredConstructors, Flag.allDeclaredMethods);
        for (String p : this.logBackPatterns) {
            if (p.startsWith("org")) {
                this.addAccess(p, new String[][]{{"<init>"}}, false, new Flag[0]);
                continue;
            }
            if (p.startsWith("ch.")) {
                this.addAccess(p, new String[][]{{"<init>"}}, false, new Flag[0]);
                continue;
            }
            if (p.startsWith("color.")) {
                this.addAccess("ch.qos.logback.core.pattern." + p, new String[][]{{"<init>"}}, false, new Flag[0]);
                continue;
            }
            this.addAccess("ch.qos.logback.classic.pattern." + p, new String[][]{{"<init>"}}, false, new Flag[0]);
        }
    }
}

