/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.support;

public abstract class ConfigOptions {
    private static final boolean REMOVE_UNUSED_AUTOCONFIG;
    private static final boolean REMOVE_YAML_SUPPORT;
    private static final boolean REMOVE_XML_SUPPORT;
    private static final boolean REMOVE_SPEL_SUPPORT;
    private static final boolean REMOVE_JMX_SUPPORT;
    private static final String DUMP_CONFIG;
    private static final boolean VERBOSE;
    private static final String MISSING_SELECTOR_HINTS;
    private static final boolean VERIFIER_ON;
    private static final Mode MODE;

    public static boolean shouldRemoveUnusedAutoconfig() {
        return REMOVE_UNUSED_AUTOCONFIG;
    }

    public static boolean areMissingSelectorHintsAnError() {
        return MISSING_SELECTOR_HINTS.equals("error");
    }

    public static boolean isVerbose() {
        return VERBOSE;
    }

    public static boolean isVerifierOn() {
        return VERIFIER_ON;
    }

    public static boolean shouldDumpConfig() {
        return DUMP_CONFIG != null;
    }

    public static boolean shouldRemoveYamlSupport() {
        return REMOVE_YAML_SUPPORT;
    }

    public static boolean shouldRemoveXmlSupport() {
        return REMOVE_XML_SUPPORT;
    }

    public static boolean shouldRemoveSpelSupport() {
        return REMOVE_SPEL_SUPPORT;
    }

    public static boolean shouldRemoveJmxSupport() {
        return REMOVE_JMX_SUPPORT;
    }

    public static boolean isAgentMode() {
        return MODE == Mode.AGENT;
    }

    public static boolean isHybridMode() {
        return MODE == Mode.HYBRID;
    }

    public static boolean isFeatureMode() {
        return MODE == Mode.FEATURE;
    }

    public static boolean isFunctionalMode() {
        return MODE == Mode.FUNCTIONAL;
    }

    public static String getDumpConfigLocation() {
        return DUMP_CONFIG;
    }

    static {
        String modeValue = System.getProperty("spring.native.mode", "FEATURE");
        Mode inferredMode = Mode.valueOf(modeValue.toUpperCase());
        MODE = inferredMode == null ? Mode.FEATURE : inferredMode;
        System.out.println("Feature operating in " + (Object)((Object)MODE) + " mode");
        REMOVE_UNUSED_AUTOCONFIG = Boolean.valueOf(System.getProperty("spring.native.remove-unused-autoconfig", "true"));
        if (REMOVE_UNUSED_AUTOCONFIG) {
            System.out.println("Removing unused configurations");
        }
        if (VERIFIER_ON = Boolean.valueOf(System.getProperty("spring.native.verify", "false")).booleanValue()) {
            System.out.println("Verification turned on");
        }
        if (VERBOSE = Boolean.valueOf(System.getProperty("spring.native.verbose", "false")).booleanValue()) {
            System.out.println("Turning on verbose mode for the feature");
        }
        if ((MISSING_SELECTOR_HINTS = System.getProperty("spring.native.missing-selector-hints", "error")).equals("warning")) {
            System.out.println("Selectors missing hints will be reported as a warning, not an error");
        } else if (!MISSING_SELECTOR_HINTS.equals("error")) {
            throw new IllegalStateException("Supported values for 'spring.native.missing-selector-hints' are 'error' (default) or 'warning'");
        }
        REMOVE_YAML_SUPPORT = Boolean.valueOf(System.getProperty("spring.native.remove-yaml-support", "false"));
        if (REMOVE_YAML_SUPPORT) {
            System.out.println("Removing Yaml support");
        }
        if (REMOVE_XML_SUPPORT = Boolean.valueOf(System.getProperty("spring.native.remove-xml-support", "false")).booleanValue()) {
            System.out.println("Removing XML support");
        }
        if (REMOVE_SPEL_SUPPORT = Boolean.valueOf(System.getProperty("spring.native.remove-spel-support", "false")).booleanValue()) {
            System.out.println("Removing SpEL support");
        }
        if (REMOVE_JMX_SUPPORT = Boolean.valueOf(System.getProperty("spring.native.remove-jmx-support", "false")).booleanValue()) {
            System.out.println("Removing JMX support");
        }
        if ((DUMP_CONFIG = System.getProperty("spring.native.dump-config")) != null) {
            System.out.println("Dumping computed config to " + DUMP_CONFIG);
        }
    }

    static enum Mode {
        AGENT,
        HYBRID,
        FEATURE,
        FUNCTIONAL;

    }
}

