/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.domain.reflect;

import java.util.List;
import java.util.Set;
import org.springframework.graalvm.domain.reflect.ClassDescriptor;
import org.springframework.graalvm.domain.reflect.FieldDescriptor;
import org.springframework.graalvm.domain.reflect.Flag;
import org.springframework.graalvm.domain.reflect.MethodDescriptor;
import org.springframework.graalvm.domain.reflect.ReflectionDescriptor;
import org.springframework.graalvm.json.JSONArray;
import org.springframework.graalvm.json.JSONObject;

public class JsonConverter {
    public JSONArray toJsonArray(ReflectionDescriptor metadata) throws Exception {
        JSONArray jsonArray = new JSONArray();
        for (ClassDescriptor cd : metadata.getClassDescriptors()) {
            jsonArray.put(this.toJsonObject(cd));
        }
        return jsonArray;
    }

    public JSONObject toJsonObject(ClassDescriptor cd) throws Exception {
        List<MethodDescriptor> mds;
        List<FieldDescriptor> fds;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", cd.getName());
        Set<Flag> flags = cd.getFlags();
        if (flags != null) {
            for (Flag flag : Flag.values()) {
                if (!flags.contains((Object)flag)) continue;
                this.putTrueFlag(jsonObject, flag.name());
            }
        }
        if ((fds = cd.getFields()) != null) {
            JSONArray fieldJsonArray = new JSONArray();
            for (FieldDescriptor fd : fds) {
                JSONObject fieldjo = new JSONObject();
                fieldjo.put("name", fd.getName());
                if (fd.isAllowWrite()) {
                    fieldjo.put("allowWrite", "true");
                }
                fieldJsonArray.put(fieldjo);
            }
            jsonObject.put("fields", fieldJsonArray);
        }
        if ((mds = cd.getMethods()) != null) {
            JSONArray methodsJsonArray = new JSONArray();
            for (MethodDescriptor md : mds) {
                JSONObject methodJsonObject = new JSONObject();
                methodJsonObject.put("name", md.getName());
                List<String> parameterTypes = md.getParameterTypes();
                JSONArray parameterArray = new JSONArray();
                if (parameterTypes != null) {
                    for (String pt : parameterTypes) {
                        parameterArray.put(pt);
                    }
                }
                methodJsonObject.put("parameterTypes", parameterArray);
                methodsJsonArray.put(methodJsonObject);
            }
            jsonObject.put("methods", methodsJsonArray);
        }
        return jsonObject;
    }

    private void putTrueFlag(JSONObject jsonObject, String name) throws Exception {
        jsonObject.put(name, true);
    }
}

