/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.graalvm.substitutions.OnlyPresent;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@TargetClass(className="org.springframework.core.io.support.SpringFactoriesLoader", onlyWith={OnlyPresent.class})
final class Target_SpringFactoriesLoader {
    @Alias
    private static Log logger;

    Target_SpringFactoriesLoader() {
    }

    @Substitute
    public static <T> List<T> loadFactories(Class<T> factoryType, @Nullable ClassLoader classLoader) {
        Assert.notNull(factoryType, (String)"'factoryType' must not be null");
        ClassLoader classLoaderToUse = classLoader;
        if (classLoaderToUse == null) {
            classLoaderToUse = SpringFactoriesLoader.class.getClassLoader();
        }
        List<String> factoryImplementationNames = Target_SpringFactoriesLoader.loadFactoryNames(factoryType, classLoaderToUse);
        if (logger.isTraceEnabled()) {
            logger.trace("Loaded [" + factoryType.getName() + "] names: " + factoryImplementationNames);
        }
        ArrayList<T> result = new ArrayList<T>(factoryImplementationNames.size());
        for (String factoryImplementationName : factoryImplementationNames) {
            if (factoryImplementationName.startsWith("org.springframework.boot.test") || factoryImplementationName.startsWith("org.springframework.test")) continue;
            result.add(Target_SpringFactoriesLoader.instantiateFactory(factoryImplementationName, factoryType, classLoaderToUse));
        }
        AnnotationAwareOrderComparator.sort(result);
        return result;
    }

    @Alias
    public static List<String> loadFactoryNames(Class<?> factoryType, @Nullable ClassLoader classLoader) {
        return null;
    }

    @Alias
    private static <T> T instantiateFactory(String factoryImplementationName, Class<T> factoryType, ClassLoader classLoader) {
        return null;
    }
}

