/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.event;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.EventExpressionEvaluator;
import org.springframework.context.event.EventListener;
import org.springframework.context.event.EventListenerFactory;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.graalvm.substitutions.OnlyPresent;
import org.springframework.graalvm.substitutions.RemoveSpelSupport;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@TargetClass(className="org.springframework.context.event.EventListenerMethodProcessor", onlyWith={OnlyPresent.class, RemoveSpelSupport.class})
final class Target_EventListenerMethodProcessor {
    @Alias
    protected Log logger = LogFactory.getLog(this.getClass());
    @Alias
    private Set<Class<?>> nonAnnotatedClasses = this.nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));
    @Alias
    private ConfigurableApplicationContext applicationContext;
    @Alias
    private List<EventListenerFactory> eventListenerFactories;
    @Delete
    private EventExpressionEvaluator evaluator;

    @Substitute
    public Target_EventListenerMethodProcessor() {
    }

    @Substitute
    private void processBean(String beanName, Class<?> targetType) {
        if (!this.nonAnnotatedClasses.contains(targetType) && AnnotationUtils.isCandidateClass(targetType, EventListener.class) && !Target_EventListenerMethodProcessor.isSpringContainerClass(targetType)) {
            Map annotatedMethods;
            block9: {
                annotatedMethods = null;
                try {
                    annotatedMethods = MethodIntrospector.selectMethods(targetType, (MethodIntrospector.MetadataLookup)new MethodIntrospector.MetadataLookup<EventListener>(){

                        public EventListener inspect(Method method) {
                            return (EventListener)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, EventListener.class);
                        }
                    });
                }
                catch (Throwable ex) {
                    if (!this.logger.isDebugEnabled()) break block9;
                    this.logger.debug("Could not resolve methods for bean with name '" + beanName + "'", ex);
                }
            }
            if (CollectionUtils.isEmpty((Map)annotatedMethods)) {
                this.nonAnnotatedClasses.add(targetType);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("No @EventListener annotations found on bean class: " + targetType.getName());
                }
            } else {
                ConfigurableApplicationContext context = this.applicationContext;
                Assert.state((context != null ? 1 : 0) != 0, (String)"No ApplicationContext set");
                List<EventListenerFactory> factories = this.eventListenerFactories;
                Assert.state((factories != null ? 1 : 0) != 0, (String)"EventListenerFactory List not initialized");
                block2: for (Method method : annotatedMethods.keySet()) {
                    for (EventListenerFactory factory : factories) {
                        if (!factory.supportsMethod(method)) continue;
                        Method methodToUse = AopUtils.selectInvocableMethod((Method)method, (Class)context.getType(beanName));
                        ApplicationListener applicationListener = factory.createApplicationListener(beanName, targetType, methodToUse);
                        context.addApplicationListener(applicationListener);
                        continue block2;
                    }
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(annotatedMethods.size() + " @EventListener methods processed on bean '" + beanName + "': " + annotatedMethods);
                }
            }
        }
    }

    @Alias
    private static boolean isSpringContainerClass(Class<?> clazz) {
        return false;
    }
}

