/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.http;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.graalvm.substitutions.MappingJackson2XmlHttpMessageConverterIsAround;
import org.springframework.graalvm.substitutions.OnlyPresent;
import org.springframework.graalvm.substitutions.RemoveXmlSupport;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;

@TargetClass(className="org.springframework.boot.autoconfigure.http.HttpMessageConverters", onlyWith={OnlyPresent.class, MappingJackson2XmlHttpMessageConverterIsAround.class, RemoveXmlSupport.class})
final class Target_HttpMessageConverters {
    Target_HttpMessageConverters() {
    }

    @Substitute
    private void reorderXmlConvertersToEnd(List<HttpMessageConverter<?>> converters) {
        ArrayList xml = new ArrayList();
        Iterator<HttpMessageConverter<?>> iterator = converters.iterator();
        while (iterator.hasNext()) {
            HttpMessageConverter<?> converter = iterator.next();
            if (!(converter instanceof MappingJackson2XmlHttpMessageConverter)) continue;
            xml.add(converter);
            iterator.remove();
        }
        converters.addAll(xml);
    }
}

