/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.EnvironmentCapable;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AbstractTypeHierarchyTraversingFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.graalvm.substitutions.OnlyPresent;
import org.springframework.graalvm.substitutions.RemoveXmlSupport;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

@TargetClass(className="org.springframework.boot.BeanDefinitionLoader", onlyWith={OnlyPresent.class, RemoveXmlSupport.class})
final class Target_BeanDefinitionLoader {
    @Delete
    private XmlBeanDefinitionReader xmlReader;
    @Alias
    private Object[] sources;
    @Alias
    private AnnotatedBeanDefinitionReader annotatedReader;
    @Alias
    private ClassPathBeanDefinitionScanner scanner;
    @Alias
    private ResourceLoader resourceLoader;
    @Inject
    private BeanDefinitionRegistry registry;

    @Substitute
    Target_BeanDefinitionLoader(BeanDefinitionRegistry registry, Object ... sources) {
        Assert.notNull((Object)registry, (String)"Registry must not be null");
        Assert.notEmpty((Object[])sources, (String)"Sources must not be empty");
        this.sources = sources;
        this.annotatedReader = new AnnotatedBeanDefinitionReader(registry);
        this.scanner = new ClassPathBeanDefinitionScanner(registry);
        this.scanner.addExcludeFilter((TypeFilter)new ClassExcludeFilter(sources));
        this.registry = registry;
    }

    @Substitute
    void setBeanNameGenerator(BeanNameGenerator beanNameGenerator) {
        this.annotatedReader.setBeanNameGenerator(beanNameGenerator);
        this.scanner.setBeanNameGenerator(beanNameGenerator);
    }

    @Substitute
    void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        this.scanner.setResourceLoader(resourceLoader);
    }

    @Substitute
    void setEnvironment(ConfigurableEnvironment environment) {
        this.annotatedReader.setEnvironment((Environment)environment);
        this.scanner.setEnvironment((Environment)environment);
    }

    @Substitute
    int load() {
        int count = 0;
        for (Object source : this.sources) {
            count += this.load(source);
        }
        return count;
    }

    @Substitute
    private int load(Object source) {
        Assert.notNull((Object)source, (String)"Source must not be null");
        if (source instanceof Class) {
            return this.load((Class)source);
        }
        if (source instanceof Resource) {
            return this.load((Resource)source);
        }
        if (source instanceof Package) {
            return this.load((Package)source);
        }
        if (source instanceof CharSequence) {
            return this.load((CharSequence)source);
        }
        throw new IllegalArgumentException("Invalid source type " + source.getClass());
    }

    @Substitute
    private int load(Class<?> source) {
        if (this.isEligible(source)) {
            this.annotatedReader.register(new Class[]{source});
            return 1;
        }
        return 0;
    }

    @Alias
    private boolean isEligible(Class<?> type) {
        return false;
    }

    @Substitute
    private int load(Package source) {
        return this.scanner.scan(new String[]{source.getName()});
    }

    @Substitute
    private int load(CharSequence source) {
        StandardEnvironment env = this.registry instanceof EnvironmentCapable ? ((EnvironmentCapable)this.registry).getEnvironment() : new StandardEnvironment();
        String resolvedSource = env.resolvePlaceholders(source.toString());
        try {
            return this.load(ClassUtils.forName((String)resolvedSource, null));
        }
        catch (ClassNotFoundException | IllegalArgumentException exception) {
            Resource[] resources = this.findResources(resolvedSource);
            int loadCount = 0;
            boolean atLeastOneResourceExists = false;
            for (Resource resource : resources) {
                if (!this.isLoadCandidate(resource)) continue;
                atLeastOneResourceExists = true;
                loadCount += this.load(resource);
            }
            if (atLeastOneResourceExists) {
                return loadCount;
            }
            Package packageResource = this.findPackage(resolvedSource);
            if (packageResource != null) {
                return this.load(packageResource);
            }
            throw new IllegalArgumentException("Invalid source '" + resolvedSource + "'");
        }
    }

    @Alias
    private boolean isLoadCandidate(Resource resource) {
        return false;
    }

    @Alias
    private Resource[] findResources(String source) {
        return null;
    }

    @Alias
    private Package findPackage(CharSequence source) {
        return null;
    }

    private static class ClassExcludeFilter
    extends AbstractTypeHierarchyTraversingFilter {
        private final Set<String> classNames = new HashSet<String>();

        ClassExcludeFilter(Object ... sources) {
            super(false, false);
            for (Object source : sources) {
                if (!(source instanceof Class)) continue;
                this.classNames.add(((Class)source).getName());
            }
        }

        protected boolean matchClassName(String className) {
            return this.classNames.contains(className);
        }
    }
}

