/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graal.type;

import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.graal.extension.NativeImageHint;
import org.springframework.graal.extension.NativeImageHints;
import org.springframework.graal.support.ConfigOptions;
import org.springframework.graal.support.SpringFeature;
import org.springframework.graal.type.CompilationHint;
import org.springframework.graal.type.Hint;
import org.springframework.graal.type.Method;
import org.springframework.graal.type.MissingTypeException;
import org.springframework.graal.type.SpringConfiguration;
import org.springframework.graal.type.TypeSystem;
import sbg.asm.signature.SignatureReader;
import sbg.asm.signature.SignatureVisitor;
import sbg.asm.tree.AnnotationNode;
import sbg.asm.tree.ClassNode;
import sbg.asm.tree.InnerClassNode;
import sbg.asm.tree.MethodNode;

public class Type {
    public static final String AtResponseBody = "Lorg/springframework/web/bind/annotation/ResponseBody;";
    public static final String AtMapping = "Lorg/springframework/web/bind/annotation/Mapping;";
    public static final String AtTransactional = "Lorg/springframework/transaction/annotation/Transactional;";
    public static final String AtJavaxTransactional = "Ljavax/transaction/Transactional;";
    public static final String AtBean = "Lorg/springframework/context/annotation/Bean;";
    public static final String AtConditionalOnClass = "Lorg/springframework/boot/autoconfigure/condition/ConditionalOnClass;";
    public static final String AtConditionalOnMissingBean = "Lorg/springframework/boot/autoconfigure/condition/ConditionalOnMissingBean;";
    public static final String AtConfiguration = "Lorg/springframework/context/annotation/Configuration;";
    public static final String AtRepository = "Lorg/springframework/stereotype/Repository;";
    public static final String AtEnableConfigurationProperties = "Lorg/springframework/boot/context/properties/EnableConfigurationProperties;";
    public static final String AtImports = "Lorg/springframework/context/annotation/Import;";
    public static final String ImportBeanDefinitionRegistrar = "Lorg/springframework/context/annotation/ImportBeanDefinitionRegistrar;";
    public static final String ImportSelector = "Lorg/springframework/context/annotation/ImportSelector;";
    public static final String Condition = "Lorg/springframework/context/annotation/Condition;";
    public static final Type MISSING = new Type(null, null, 0);
    public static final Type[] NO_INTERFACES = new Type[0];
    protected static Set<String> validBoxing = new HashSet<String>();
    private TypeSystem typeSystem;
    private ClassNode node;
    private Type[] interfaces;
    private String name;
    private int dimensions = 0;
    List<Type> annotations = null;
    public static final List<Type> NO_ANNOTATIONS;

    private Type(TypeSystem typeSystem, ClassNode node, int dimensions) {
        this.typeSystem = typeSystem;
        this.node = node;
        this.dimensions = dimensions;
        if (node != null) {
            this.name = node.name;
            for (int i = 0; i < dimensions; ++i) {
                this.name = this.name + "[]";
            }
        }
    }

    public static Type forClassNode(TypeSystem typeSystem, ClassNode node, int dimensions) {
        return new Type(typeSystem, node, dimensions);
    }

    public String getName() {
        return this.name;
    }

    public String getDottedName() {
        return this.name.replace("/", ".");
    }

    public Type getSuperclass() {
        if (this.dimensions > 0) {
            return this.typeSystem.resolveSlashed("java/lang/Object");
        }
        if (this.node.superName == null) {
            return null;
        }
        return this.typeSystem.resolveSlashed(this.node.superName);
    }

    public String toString() {
        return "Type:" + this.getName();
    }

    public Type[] getInterfaces() {
        if (this.interfaces == null) {
            if (this.dimensions != 0) {
                this.interfaces = new Type[]{this.typeSystem.resolveSlashed("java/lang/Cloneable"), this.typeSystem.resolveSlashed("java/io/Serializable")};
            } else {
                List<String> itfs = this.node.interfaces;
                if (itfs.size() == 0) {
                    this.interfaces = NO_INTERFACES;
                } else {
                    this.interfaces = new Type[itfs.size()];
                    for (int i = 0; i < itfs.size(); ++i) {
                        this.interfaces[i] = this.typeSystem.resolveSlashed(itfs.get(i));
                    }
                }
            }
        }
        return this.interfaces;
    }

    public List<String> getInterfacesStrings() {
        if (this.dimensions != 0) {
            ArrayList<String> itfs = new ArrayList<String>();
            itfs.add("java/lang/Cloneable");
            itfs.add("java/io/Serializable");
            return itfs;
        }
        return this.node.interfaces;
    }

    public String getSuperclassString() {
        return this.dimensions > 0 ? "java/lang/Object" : this.node.superName;
    }

    public List<String> getTypesInSignature() {
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        if (this.node.signature == null) {
            ArrayList<String> ls = new ArrayList<String>();
            if (this.node.superName != null) {
                ls.add(this.node.superName);
            }
            if (this.node.interfaces != null) {
                ls.addAll(this.node.interfaces);
            }
            return ls;
        }
        SignatureReader reader = new SignatureReader(this.node.signature);
        TypeCollector tc = new TypeCollector();
        reader.accept(tc);
        return tc.getTypes();
    }

    public boolean extendsClass(String clazzname) {
        for (Type superclass = this.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            if (!superclass.getDescriptor().equals(clazzname)) continue;
            return true;
        }
        return false;
    }

    public boolean implementsInterface(String interfaceName) {
        Type[] interfacesToCheck;
        for (Type interfaceToCheck : interfacesToCheck = this.getInterfaces()) {
            if (interfaceToCheck == null) continue;
            if (interfaceToCheck.getName().equals(interfaceName)) {
                return true;
            }
            if (!interfaceToCheck.implementsInterface(interfaceName)) continue;
            return true;
        }
        for (Type superclass = this.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            if (!superclass.implementsInterface(interfaceName)) continue;
            return true;
        }
        return false;
    }

    public List<Method> getMethodsWithAnnotation(String string) {
        return this.dimensions > 0 ? Collections.emptyList() : this.node.methods.stream().filter(m -> this.hasAnnotation((MethodNode)m, string)).map(m -> this.wrap((MethodNode)m)).collect(Collectors.toList());
    }

    public List<Method> getMethodsWithAnnotation(String string, boolean checkMetaUsage) {
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> results = new ArrayList();
        if (this.node.methods != null) {
            for (MethodNode mn : this.node.methods) {
                if (!this.hasAnnotation(mn, string, checkMetaUsage)) continue;
                if (results == null) {
                    results = new ArrayList();
                }
                results.add(this.wrap(mn));
            }
        }
        return results == null ? Collections.emptyList() : results;
    }

    public List<Method> getMethodsWithAtBean() {
        return this.getMethodsWithAnnotation(AtBean);
    }

    private Method wrap(MethodNode mn) {
        return new Method(mn, this.typeSystem);
    }

    private boolean hasAnnotation(MethodNode m, String string) {
        List<AnnotationNode> visibleAnnotations = m.visibleAnnotations;
        Optional findAny = visibleAnnotations == null ? Optional.empty() : visibleAnnotations.stream().filter(a -> a.desc.equals(string)).findFirst();
        return findAny.isPresent();
    }

    public boolean hasAnnotation(String lAnnotationDescriptor, boolean checkMetaUsage) {
        HashSet<String> seen = new HashSet<String>();
        return this.hasAnnotationHelper(lAnnotationDescriptor, checkMetaUsage, seen);
    }

    private boolean hasAnnotationHelper(String lAnnotationDescriptor, boolean checkMetaUsage, Set<String> seen) {
        if (this.node.visibleAnnotations != null) {
            for (AnnotationNode an : this.node.visibleAnnotations) {
                boolean b;
                Type t;
                if (an.desc.equals(lAnnotationDescriptor)) {
                    return true;
                }
                if (!checkMetaUsage || !seen.add(lAnnotationDescriptor) || (t = this.typeSystem.Lresolve(an.desc)) == null || !(b = t.hasAnnotationHelper(lAnnotationDescriptor, checkMetaUsage, seen))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasAnnotation(MethodNode mn, String lAnnotationDescriptor, boolean checkMetaUsage) {
        if (checkMetaUsage) {
            return this.findMetaAnnotationUsage(this.toAnnotations(mn.visibleAnnotations), lAnnotationDescriptor);
        }
        List<AnnotationNode> vAnnotations = mn.visibleAnnotations;
        if (vAnnotations != null) {
            for (AnnotationNode an : vAnnotations) {
                if (!an.desc.equals(lAnnotationDescriptor)) continue;
                return true;
            }
        }
        return false;
    }

    private List<Type> toAnnotations(List<AnnotationNode> visibleAnnotations) {
        if (visibleAnnotations == null) {
            return Collections.emptyList();
        }
        ArrayList<Type> result = new ArrayList<Type>();
        for (AnnotationNode an : visibleAnnotations) {
            result.add(this.typeSystem.Lresolve(an.desc));
        }
        return result;
    }

    private boolean findMetaAnnotationUsage(List<Type> toSearch, String lAnnotationDescriptor) {
        return this.findMetaAnnotationUsageHelper(toSearch, lAnnotationDescriptor, new HashSet<String>());
    }

    private boolean findMetaAnnotationUsageHelper(List<Type> toSearch, String lAnnotationDescriptor, Set<String> seen) {
        if (toSearch == null) {
            return false;
        }
        for (Type an : toSearch) {
            boolean isMetaAnnotated;
            if (an.getDescriptor().equals(lAnnotationDescriptor)) {
                return true;
            }
            if (!seen.add(an.getName()) || !(isMetaAnnotated = this.findMetaAnnotationUsageHelper(an.getAnnotations(), lAnnotationDescriptor, seen))) continue;
            return true;
        }
        return false;
    }

    public boolean isAssignableFrom(Type other) {
        boolean b;
        Type[] interfaces;
        if (other.isPrimitiveType() && validBoxing.contains(this.getName() + other.getName())) {
            return true;
        }
        if (this == other) {
            return true;
        }
        if (this.getName().equals("Ljava/lang/Object;")) {
            return true;
        }
        for (Type intface : interfaces = other.getInterfaces()) {
            boolean b2 = this.isAssignableFrom(intface);
            if (!b2) continue;
            return true;
        }
        Type superclass = other.getSuperclass();
        return superclass != null && (b = this.isAssignableFrom(superclass));
    }

    private boolean isPrimitiveType() {
        return false;
    }

    public boolean isInterface() {
        return this.dimensions > 0 ? false : Modifier.isInterface(this.node.access);
    }

    public Map<String, String> getAnnotationValuesInHierarchy(String LdescriptorLookingFor) {
        if (this.dimensions > 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> collector = new HashMap<String, String>();
        this.getAnnotationValuesInHierarchy(LdescriptorLookingFor, new ArrayList<String>(), collector);
        return collector;
    }

    public void getAnnotationValuesInHierarchy(String lookingFor, List<String> seen, Map<String, String> collector) {
        if (this.dimensions > 0) {
            return;
        }
        if (this.node.visibleAnnotations != null) {
            for (AnnotationNode anno : this.node.visibleAnnotations) {
                if (seen.contains(anno.desc)) continue;
                seen.add(anno.desc);
                if (anno.desc.equals(lookingFor)) {
                    List<Object> os = anno.values;
                    for (int i = 0; i < os.size(); i += 2) {
                        collector.put(os.get(i).toString(), os.get(i + 1).toString());
                    }
                }
                try {
                    Type resolve = this.typeSystem.Lresolve(anno.desc);
                    resolve.getAnnotationValuesInHierarchy(lookingFor, seen, collector);
                }
                catch (MissingTypeException missingTypeException) {}
            }
        }
    }

    public boolean hasAnnotationInHierarchy(String lookingFor) {
        if (this.dimensions > 0) {
            return false;
        }
        return this.hasAnnotationInHierarchy(lookingFor, new ArrayList<String>());
    }

    public boolean hasAnnotationInHierarchy(String lookingFor, List<String> seen) {
        if (this.dimensions > 0) {
            return false;
        }
        if (this.node.visibleAnnotations != null) {
            for (AnnotationNode anno : this.node.visibleAnnotations) {
                if (seen.contains(anno.desc)) continue;
                seen.add(anno.desc);
                if (anno.desc.equals(lookingFor)) {
                    return true;
                }
                try {
                    Type resolve = this.typeSystem.Lresolve(anno.desc);
                    if (!resolve.hasAnnotationInHierarchy(lookingFor, seen)) continue;
                    return true;
                }
                catch (MissingTypeException missingTypeException) {
                }
            }
        }
        return false;
    }

    public boolean isCondition() {
        if (this.dimensions > 0) {
            return false;
        }
        try {
            return this.implementsInterface(Type.fromLdescriptorToSlashed(Condition));
        }
        catch (MissingTypeException mte) {
            return false;
        }
    }

    private boolean isEventListener() {
        try {
            return this.implementsInterface("org/springframework/context/event/EventListenerFactory");
        }
        catch (MissingTypeException mte) {
            return false;
        }
    }

    public boolean isAtConfiguration() {
        if (this.dimensions > 0) {
            return false;
        }
        return this.isMetaAnnotated(Type.fromLdescriptorToSlashed(AtConfiguration), new HashSet<String>());
    }

    public boolean isAbstractNestedCondition() {
        if (this.dimensions > 0) {
            return false;
        }
        return this.extendsClass("Lorg/springframework/boot/autoconfigure/condition/AbstractNestedCondition;");
    }

    public boolean isMetaAnnotated(String slashedTypeDescriptor) {
        if (this.dimensions > 0) {
            return false;
        }
        return this.isMetaAnnotated(slashedTypeDescriptor, new HashSet<String>());
    }

    private boolean isMetaAnnotated(String slashedTypeDescriptor, Set<String> seen) {
        if (this.dimensions > 0) {
            return false;
        }
        for (Type t : this.getAnnotations()) {
            String tname = t.getName();
            if (tname.equals(slashedTypeDescriptor)) {
                return true;
            }
            if (seen.contains(tname)) continue;
            seen.add(tname);
            if (!t.isMetaAnnotated(slashedTypeDescriptor, seen)) continue;
            return true;
        }
        return false;
    }

    public List<String> findConditionalOnMissingBeanValue() {
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        List<String> findAnnotationValue = this.findAnnotationValue(AtConditionalOnMissingBean, false);
        if (findAnnotationValue == null && this.node.visibleAnnotations != null) {
            for (AnnotationNode an : this.node.visibleAnnotations) {
                if (!an.desc.equals(AtConditionalOnMissingBean)) continue;
                System.out.println("??? found nothing on this @COC annotated thing " + this.getName());
            }
        }
        return findAnnotationValue;
    }

    public List<String> findConditionalOnClassValue() {
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        List<String> findAnnotationValue = this.findAnnotationValue(AtConditionalOnClass, false);
        if (findAnnotationValue == null && this.node.visibleAnnotations != null) {
            for (AnnotationNode an : this.node.visibleAnnotations) {
                if (!an.desc.equals(AtConditionalOnClass)) continue;
                System.out.println("??? found nothing on this @COC annotated thing " + this.getName());
            }
        }
        return findAnnotationValue;
    }

    public List<String> findEnableConfigurationPropertiesValue() {
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        List<String> values = this.findAnnotationValue(AtEnableConfigurationProperties, false);
        return values;
    }

    public Map<String, List<String>> findImports() {
        if (this.dimensions > 0) {
            return Collections.emptyMap();
        }
        return this.findAnnotationValueWithHostAnnotation(AtImports, true, new HashSet<String>());
    }

    public List<String> findAnnotationValue(String annotationType, boolean searchMeta) {
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        return this.findAnnotationValue(annotationType, searchMeta, new HashSet<String>());
    }

    public Map<String, List<String>> findAnnotationValueWithHostAnnotation(String annotationType, boolean searchMeta, Set<String> visited) {
        if (this.dimensions > 0) {
            return Collections.emptyMap();
        }
        if (!visited.add(this.getName())) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, List<String>> collectedResults = new LinkedHashMap<String, List<String>>();
        if (this.node.visibleAnnotations != null) {
            for (AnnotationNode an : this.node.visibleAnnotations) {
                List<Object> values;
                if (!an.desc.equals(annotationType) || (values = an.values) == null) continue;
                for (int i = 0; i < values.size(); i += 2) {
                    if (!values.get(i).equals("value")) continue;
                    List importedReferences = ((List)values.get(i + 1)).stream().map(t -> t.getDescriptor()).collect(Collectors.toList());
                    collectedResults.put(this.getName().replace("/", "."), importedReferences);
                }
            }
            if (searchMeta) {
                for (AnnotationNode an : this.node.visibleAnnotations) {
                    Type annoType = null;
                    try {
                        annoType = this.typeSystem.Lresolve(an.desc);
                    }
                    catch (MissingTypeException mte) {
                        System.out.println("SBG: WARNING: Unable to find " + an.desc + " skipping...");
                        continue;
                    }
                    collectedResults.putAll(annoType.findAnnotationValueWithHostAnnotation(annotationType, searchMeta, visited));
                }
            }
        }
        return collectedResults;
    }

    public List<String> findAnnotationValue(String annotationType, boolean searchMeta, Set<String> visited) {
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        if (!visited.add(this.getName())) {
            return Collections.emptyList();
        }
        ArrayList<String> collectedResults = new ArrayList<String>();
        if (this.node.visibleAnnotations != null) {
            for (AnnotationNode an : this.node.visibleAnnotations) {
                List<Object> values;
                if (!an.desc.equals(annotationType) || (values = an.values) == null) continue;
                for (int i = 0; i < values.size(); i += 2) {
                    if (!values.get(i).equals("value")) continue;
                    return ((List)values.get(i + 1)).stream().map(t -> t.getDescriptor()).collect(Collectors.toCollection(() -> collectedResults));
                }
            }
            if (searchMeta) {
                for (AnnotationNode an : this.node.visibleAnnotations) {
                    Type annoType = this.typeSystem.Lresolve(an.desc);
                    collectedResults.addAll(annoType.findAnnotationValue(annotationType, searchMeta, visited));
                }
            }
        }
        return collectedResults;
    }

    private List<Type> getAnnotations() {
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        if (this.annotations == null) {
            this.annotations = new ArrayList<Type>();
            if (this.node.visibleAnnotations != null) {
                for (AnnotationNode an : this.node.visibleAnnotations) {
                    try {
                        this.annotations.add(this.typeSystem.Lresolve(an.desc));
                    }
                    catch (MissingTypeException missingTypeException) {}
                }
            }
            if (this.annotations.size() == 0) {
                this.annotations = NO_ANNOTATIONS;
            }
        }
        return this.annotations;
    }

    public Type findAnnotation(Type searchType) {
        if (this.dimensions > 0) {
            return null;
        }
        List<Type> annos = this.getAnnotations();
        for (Type anno : annos) {
            if (!anno.equals(searchType)) continue;
            return anno;
        }
        return null;
    }

    public Map.Entry<Type, List<Type>> getRelevantStereotypes() {
        if (this.dimensions > 0) {
            return null;
        }
        ArrayList<Type> relevantAnnotations = new ArrayList<Type>();
        List<Type> indexedTypesInHierachy = this.getAnnotatedElementsInHierarchy(a -> a.desc.equals("Lorg/springframework/stereotype/Indexed;"));
        relevantAnnotations.addAll(indexedTypesInHierachy);
        List<Type> types = this.getJavaxAnnotationsInHierarchy();
        relevantAnnotations.addAll(types);
        if (!relevantAnnotations.isEmpty()) {
            return new AbstractMap.SimpleImmutableEntry<Type, List<Type>>(this, relevantAnnotations);
        }
        return null;
    }

    List<Type> getJavaxAnnotationsInHierarchy() {
        return this.getJavaxAnnotationsInHierarchy(new HashSet<String>());
    }

    private boolean isAnnotated(String Ldescriptor) {
        if (this.dimensions > 0) {
            return false;
        }
        if (this.node.visibleAnnotations != null) {
            for (AnnotationNode an : this.node.visibleAnnotations) {
                if (!an.desc.equals(Ldescriptor)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAnnotated(String Ldescriptor, boolean checkMetaUsage) {
        if (this.dimensions > 0) {
            return false;
        }
        if (checkMetaUsage) {
            return this.isMetaAnnotated(Ldescriptor);
        }
        if (this.node.visibleAnnotations != null) {
            for (AnnotationNode an : this.node.visibleAnnotations) {
                if (!an.desc.equals(Ldescriptor)) continue;
                return true;
            }
        }
        return false;
    }

    private List<Type> getAnnotatedElementsInHierarchy(Predicate<AnnotationNode> p) {
        return this.getAnnotatedElementsInHierarchy(p, new HashSet<String>());
    }

    private List<Type> getAnnotatedElementsInHierarchy(Predicate<AnnotationNode> p, Set<String> seen) {
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        ArrayList<Type> results = new ArrayList<Type>();
        if (this.node.visibleAnnotations != null) {
            for (AnnotationNode an : this.node.visibleAnnotations) {
                if (!seen.add(an.desc)) continue;
                if (p.test(an)) {
                    results.add(this);
                    continue;
                }
                Type annoType = this.typeSystem.Lresolve(an.desc, true);
                if (annoType == null) continue;
                List<Type> ts = annoType.getAnnotatedElementsInHierarchy(p, seen);
                results.addAll(ts);
            }
        }
        return results.size() > 0 ? results : Collections.emptyList();
    }

    private List<Type> getJavaxAnnotationsInHierarchy(Set<String> seen) {
        Type[] intfaces;
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        ArrayList<Type> result = new ArrayList<Type>();
        if (this.node.visibleAnnotations != null) {
            for (AnnotationNode an : this.node.visibleAnnotations) {
                Type annoType;
                if (!seen.add(an.desc) || (annoType = this.typeSystem.Lresolve(an.desc, true)) == null) continue;
                if (annoType.getDottedName().startsWith("javax.")) {
                    result.add(annoType);
                    continue;
                }
                List<Type> ts = annoType.getJavaxAnnotationsInHierarchy(seen);
                result.addAll(ts);
            }
        }
        for (Type intface : intfaces = this.getInterfaces()) {
            if (!seen.add(intface.getDottedName())) continue;
            result.addAll(intface.getJavaxAnnotationsInHierarchy(seen));
        }
        return result;
    }

    public List<Type> getNestedTypes() {
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        ArrayList<Type> result = null;
        List<InnerClassNode> innerClasses = this.node.innerClasses;
        for (InnerClassNode inner : innerClasses) {
            if (inner.outerName == null || !inner.outerName.equals(this.getName()) || inner.name.equals(this.getName())) continue;
            Type t = this.typeSystem.resolve(inner.name);
            if (result == null) {
                result = new ArrayList<Type>();
            }
            result.add(t);
        }
        return result == null ? Collections.emptyList() : result;
    }

    public String getDescriptor() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.dimensions; ++i) {
            s.append("[");
        }
        s.append("L").append(this.node.name.replace(".", "/")).append(";");
        return s.toString();
    }

    public List<Hint> getHints() {
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        ArrayList<Hint> hints = new ArrayList<Hint>();
        List<CompilationHint> hintx = this.typeSystem.findHints(this.getName());
        if (hintx.size() != 0) {
            ArrayList<Type> s = new ArrayList<Type>();
            s.add(this);
            for (CompilationHint hintxx : hintx) {
                hints.add(new Hint(s, hintxx.skipIfTypesMissing, hintxx.follow, hintxx.getDependantTypes(), Collections.emptyMap()));
            }
        }
        if (this.node.visibleAnnotations != null) {
            for (AnnotationNode an : this.node.visibleAnnotations) {
                Type annotationType = this.typeSystem.Lresolve(an.desc, true);
                if (annotationType == null) {
                    SpringFeature.log("Couldn't resolve " + an.desc + " annotation type whilst searching for hints on " + this.getName());
                    continue;
                }
                Stack<Type> s = new Stack<Type>();
                s.push(this);
                annotationType.collectHints(an, hints, new HashSet<AnnotationNode>(), s);
            }
        }
        if (this.isImportSelector() && hints.size() == 0) {
            if (ConfigOptions.areMissingSelectorHintsAnError()) {
                throw new IllegalStateException("No access hint found for import selector: " + this.getDottedName());
            }
            System.out.println("WARNING: No access hint found for import selector: " + this.getDottedName());
        }
        return hints.size() == 0 ? Collections.emptyList() : hints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void collectHints(AnnotationNode an, List<Hint> hints, Set<AnnotationNode> visited, Stack<Type> annotationChain) {
        if (!visited.add(an)) {
            return;
        }
        try {
            annotationChain.push(this);
            List<CompilationHint> hints2 = this.typeSystem.findHints(an.desc);
            if (hints2.size() != 0) {
                List<String> typesCollectedFromAnnotation = this.collectTypes(an);
                if (an.desc.equals(AtEnableConfigurationProperties)) {
                    this.addInners(typesCollectedFromAnnotation);
                }
                for (CompilationHint hints2a : hints2) {
                    hints.add(new Hint(new ArrayList<Type>(annotationChain), hints2a.skipIfTypesMissing, hints2a.follow, hints2a.getDependantTypes(), this.asMap(typesCollectedFromAnnotation, hints2a.skipIfTypesMissing)));
                }
            }
            if (this.node.visibleAnnotations != null) {
                for (AnnotationNode an2 : this.node.visibleAnnotations) {
                    Type annotationType = this.typeSystem.Lresolve(an2.desc, true);
                    if (annotationType == null) {
                        SpringFeature.log("Couldn't resolve " + an2.desc + " annotation type whilst searching for hints on " + this.getName());
                        continue;
                    }
                    annotationType.collectHints(an2, hints, visited, annotationChain);
                }
            }
        }
        finally {
            annotationChain.pop();
        }
    }

    private void addInners(List<String> propertiesTypes) {
        ArrayList<String> extras = new ArrayList<String>();
        for (String propertiesType : propertiesTypes) {
            Type type = this.typeSystem.Lresolve(propertiesType, true);
            if (type == null) continue;
            List<Type> nestedTypes = type.getNestedTypes();
            for (Type nestedType : nestedTypes) {
                extras.add(nestedType.getDescriptor());
            }
        }
        propertiesTypes.addAll(extras);
    }

    private Map<String, Integer> asMap(List<String> typesCollectedFromAnnotation, boolean usingForVisibilityCheck) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String t : typesCollectedFromAnnotation) {
            Type type = this.typeSystem.Lresolve(t, true);
            int ar = -1;
            if (usingForVisibilityCheck) {
                ar = 2;
            } else if (type != null && (type.isCondition() || type.isEventListener())) {
                ar = 7;
                if (type.isAbstractNestedCondition()) {
                    // empty if block
                }
            } else {
                ar = 31;
            }
            map.put(Type.fromLdescriptorToDotted(t), ar);
        }
        return map;
    }

    private Type[] getMemberTypes() {
        if (this.dimensions > 0) {
            return new Type[0];
        }
        ArrayList<Type> result = new ArrayList<Type>();
        List<InnerClassNode> nestMembers = this.node.innerClasses;
        if (nestMembers != null) {
            for (InnerClassNode icn : nestMembers) {
                if (!icn.name.startsWith(this.getName() + "$")) continue;
                result.add(this.typeSystem.resolveSlashed(icn.name));
            }
            System.out.println(this.getName() + " has inners " + nestMembers.stream().map(f -> "oo=" + this.getDescriptor() + "::o=" + f.outerName + "::n=" + f.name + "::in=" + f.innerName).collect(Collectors.joining(",")) + "  >> " + result);
        }
        return result.toArray(new Type[0]);
    }

    private List<CompilationHint> findCompilationHintHelper(HashSet<Type> visited) {
        if (!visited.add(this)) {
            return null;
        }
        if (this.node.visibleAnnotations != null) {
            for (AnnotationNode an : this.node.visibleAnnotations) {
                List<CompilationHint> compilationHints = this.typeSystem.findHints(an.desc);
                if (compilationHints.size() != 0) {
                    return compilationHints;
                }
                Type resolvedAnnotation = this.typeSystem.Lresolve(an.desc);
                compilationHints = resolvedAnnotation.findCompilationHintHelper(visited);
                if (compilationHints.size() == 0) continue;
                return compilationHints;
            }
        }
        return null;
    }

    private List<String> collectTypes(AnnotationNode an) {
        List<Object> values = an.values;
        if (values != null) {
            for (int i = 0; i < values.size(); i += 2) {
                if (!values.get(i).equals("value")) continue;
                Object object = values.get(i + 1);
                ArrayList<String> importedReferences = null;
                if (object instanceof List) {
                    importedReferences = ((List)object).stream().map(t -> t.getDescriptor()).collect(Collectors.toList());
                } else {
                    importedReferences = new ArrayList<String>();
                    importedReferences.add(((sbg.asm.Type)object).getDescriptor());
                }
                return importedReferences;
            }
        }
        return Collections.emptyList();
    }

    public boolean isImportSelector() {
        return this.implementsInterface(Type.fromLdescriptorToSlashed(ImportSelector));
    }

    public boolean isImportRegistrar() {
        return this.implementsInterface(Type.fromLdescriptorToSlashed(ImportBeanDefinitionRegistrar));
    }

    public static String fromLdescriptorToSlashed(String Ldescriptor) {
        int dims = 0;
        int p = 0;
        if (Ldescriptor.startsWith("[")) {
            while (Ldescriptor.charAt(p) == '[') {
                ++p;
                ++dims;
            }
        }
        StringBuilder r = new StringBuilder();
        r.append(Ldescriptor.substring(p + 1, Ldescriptor.length() - 1));
        for (int i = 0; i < dims; ++i) {
            r.append("[]");
        }
        return r.toString();
    }

    public static String fromLdescriptorToDotted(String Ldescriptor) {
        return Type.fromLdescriptorToSlashed(Ldescriptor).replace("/", ".");
    }

    private List<CompilationHint> findCompilationHint(Type annotationType) {
        String descriptor = "L" + annotationType.getName().replace(".", "/") + ";";
        List<CompilationHint> hints = this.typeSystem.findHints(descriptor);
        if (hints.size() != 0) {
            return hints;
        }
        return annotationType.findCompilationHintHelper(new HashSet<Type>());
    }

    public void collectMissingAnnotationTypesHelper(Set<String> missingAnnotationTypes, HashSet<Type> visited) {
        if (this.dimensions > 0) {
            return;
        }
        if (!visited.add(this)) {
            return;
        }
        if (this.node.visibleAnnotations != null) {
            for (AnnotationNode an : this.node.visibleAnnotations) {
                Type annotationType = this.typeSystem.Lresolve(an.desc, true);
                if (annotationType == null) {
                    missingAnnotationTypes.add(an.desc.substring(0, an.desc.length() - 1).replace("/", "."));
                    continue;
                }
                annotationType.collectMissingAnnotationTypesHelper(missingAnnotationTypes, visited);
            }
        }
    }

    public int getMethodCount() {
        return this.node.methods.size();
    }

    public boolean isAnnotation() {
        if (this.dimensions > 0) {
            return false;
        }
        return (this.node.access & 0x2000) != 0;
    }

    public List<Type> getAutoConfigureBeforeOrAfter() {
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        ArrayList<Type> result = new ArrayList<Type>();
        for (AnnotationNode an : this.node.visibleAnnotations) {
            List<Object> values;
            if (!an.desc.equals("Lorg/springframework/boot/autoconfigure/AutoConfigureAfter;") || (values = an.values) == null) continue;
            for (int i = 0; i < values.size(); i += 2) {
                if (!values.get(i).equals("value")) continue;
                List types = (List)values.get(i + 1);
                for (sbg.asm.Type type : types) {
                    Type t = this.typeSystem.Lresolve(type.getDescriptor());
                    if (t == null) continue;
                    result.add(t);
                }
            }
        }
        return result;
    }

    public boolean hasOnlySimpleConstructor() {
        if (this.dimensions > 0) {
            return false;
        }
        boolean hasCtor = false;
        List<MethodNode> methods = this.node.methods;
        for (MethodNode mn : methods) {
            if (!mn.name.equals("<init>")) continue;
            if (mn.desc.equals("()V")) {
                hasCtor = true;
                continue;
            }
            return false;
        }
        return hasCtor;
    }

    public static boolean shouldBeProcessed(String key, TypeSystem ts) {
        String[] guardTypes = SpringConfiguration.findProposedFactoryGuards(key);
        if (guardTypes == null) {
            return true;
        }
        for (String guardType : guardTypes) {
            Type resolvedType = ts.resolveDotted(guardType, true);
            if (resolvedType == null) continue;
            return true;
        }
        return false;
    }

    public List<CompilationHint> unpackConfigurationHints() {
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        ArrayList<CompilationHint> hints = null;
        if (this.node.visibleAnnotations != null) {
            for (AnnotationNode an : this.node.visibleAnnotations) {
                if (Type.fromLdescriptorToDotted(an.desc).equals(NativeImageHint.class.getName())) {
                    CompilationHint hint = this.fromConfigurationHintToCompilationHint(an);
                    if (hints == null) {
                        hints = new ArrayList<CompilationHint>();
                    }
                    hints.add(hint);
                    continue;
                }
                if (!Type.fromLdescriptorToDotted(an.desc).equals(NativeImageHints.class.getName())) continue;
                List<CompilationHint> chints = this.fromConfigurationHintsToCompilationHints(an);
                if (hints == null) {
                    hints = new ArrayList();
                }
                hints.addAll(chints);
            }
        }
        return hints == null ? Collections.emptyList() : hints;
    }

    private CompilationHint fromConfigurationHintToCompilationHint(AnnotationNode an) {
        CompilationHint ch = new CompilationHint();
        List<Object> values = an.values;
        if (values != null) {
            for (int i = 0; i < values.size(); i += 2) {
                Boolean b;
                String key = (String)values.get(i);
                Object value = values.get(i + 1);
                if (key.equals("trigger")) {
                    ch.setTargetType(((sbg.asm.Type)value).getClassName());
                    continue;
                }
                if (key.equals("typeInfos")) {
                    List typeInfos = (List)value;
                    for (AnnotationNode typeInfo : typeInfos) {
                        this.unpackTypeInfo(typeInfo, ch);
                    }
                    continue;
                }
                if (key.equals("abortIfTypesMissing")) {
                    b = (Boolean)value;
                    ch.setAbortIfTypesMissing(b);
                    continue;
                }
                if (key.equals("follow")) {
                    b = (Boolean)value;
                    ch.setFollow(b);
                    continue;
                }
                System.out.println("annotation " + key + "=" + value + "(" + value.getClass() + ")");
            }
        }
        if (ch.getTargetType() == null) {
            ch.setTargetType("java.lang.Object");
        }
        return ch;
    }

    private void unpackTypeInfo(AnnotationNode typeInfo, CompilationHint ch) {
        List<Object> values = typeInfo.values;
        ArrayList types = new ArrayList();
        ArrayList typeNames = new ArrayList();
        int accessRequired = -1;
        for (int i = 0; i < values.size(); i += 2) {
            String key = (String)values.get(i);
            Object value = values.get(i + 1);
            if (key.equals("types")) {
                types = (ArrayList)value;
                continue;
            }
            if (key.equals("access")) {
                accessRequired = (Integer)value;
                continue;
            }
            if (!key.equals("typeNames")) continue;
            typeNames = (ArrayList)value;
        }
        for (sbg.asm.Type type : types) {
            ch.addDependantType(type.getClassName(), accessRequired == -1 ? this.inferTypeKind(type) : accessRequired);
        }
        for (String typeName : typeNames) {
            Type resolvedType = this.typeSystem.resolveName(typeName, true);
            if (resolvedType == null) continue;
            ch.addDependantType(typeName, accessRequired == -1 ? this.inferTypeKind(resolvedType) : accessRequired);
        }
    }

    private int inferTypeKind(Type t) {
        if (t == null) {
            return 31;
        }
        if (t.isAtConfiguration()) {
            return 31;
        }
        return 31;
    }

    private List<CompilationHint> fromConfigurationHintsToCompilationHints(AnnotationNode an) {
        ArrayList<CompilationHint> chs = new ArrayList<CompilationHint>();
        List<Object> values = an.values;
        for (int i = 0; i < values.size(); i += 2) {
            String key = (String)values.get(i);
            Object value = values.get(i + 1);
            if (!key.equals("value")) continue;
            List annotationNodes = (List)value;
            for (int j = 0; j < annotationNodes.size(); ++j) {
                chs.add(this.fromConfigurationHintToCompilationHint((AnnotationNode)annotationNodes.get(j)));
            }
        }
        return chs;
    }

    private int inferTypeKind(sbg.asm.Type type) {
        Type t = this.typeSystem.resolve(type, true);
        if (t == null) {
            return 31;
        }
        if (t.isAtConfiguration()) {
            return 31;
        }
        return 31;
    }

    public List<CompilationHint> getCompilationHints() {
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        return this.unpackConfigurationHints();
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public boolean isArray() {
        return this.dimensions > 0;
    }

    public boolean isTransactional() {
        return this.isAnnotated(AtTransactional) || this.isAnnotated(AtJavaxTransactional);
    }

    public boolean hasTransactionalMethods() {
        List<Method> methodsWithAtTransactional = this.getMethodsWithAnnotation(AtTransactional);
        if (methodsWithAtTransactional.size() > 0) {
            return true;
        }
        List<Method> methodsWithAtJavaxTransactional = this.getMethodsWithAnnotation(AtJavaxTransactional);
        return methodsWithAtJavaxTransactional.size() > 0;
    }

    public boolean isAnnotatedInHierarchy(String anno) {
        if (this.isAnnotated(AtTransactional)) {
            return true;
        }
        List<Method> methodsWithAnnotation = this.getMethodsWithAnnotation(anno);
        if (methodsWithAnnotation.size() != 0) {
            return true;
        }
        Type superclass = this.getSuperclass();
        if (superclass != null && superclass.isAnnotatedInHierarchy(anno)) {
            return true;
        }
        Type[] intfaces = this.getInterfaces();
        if (intfaces != null) {
            for (Type intface : intfaces) {
                if (!intface.isAnnotatedInHierarchy(anno)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> collectTypeParameterNames() {
        return null;
    }

    public boolean isAtRepository() {
        return this.isAnnotated(AtRepository);
    }

    public boolean isAtResponseBody() {
        boolean b = this.hasAnnotation(AtResponseBody, true);
        return b;
    }

    public Collection<Type> collectAtMappingMarkedReturnTypes() {
        LinkedHashSet<Type> returnTypes = new LinkedHashSet<Type>();
        List<Method> methodsWithAnnotation = this.getMethodsWithAnnotation(AtMapping, true);
        for (Method m : methodsWithAnnotation) {
            returnTypes.add(m.getReturnType());
        }
        return returnTypes;
    }

    static {
        validBoxing.add("Ljava/lang/Byte;B");
        validBoxing.add("Ljava/lang/Character;C");
        validBoxing.add("Ljava/lang/Double;D");
        validBoxing.add("Ljava/lang/Float;F");
        validBoxing.add("Ljava/lang/Integer;I");
        validBoxing.add("Ljava/lang/Long;J");
        validBoxing.add("Ljava/lang/Short;S");
        validBoxing.add("Ljava/lang/Boolean;Z");
        validBoxing.add("BLjava/lang/Byte;");
        validBoxing.add("CLjava/lang/Character;");
        validBoxing.add("DLjava/lang/Double;");
        validBoxing.add("FLjava/lang/Float;");
        validBoxing.add("ILjava/lang/Integer;");
        validBoxing.add("JLjava/lang/Long;");
        validBoxing.add("SLjava/lang/Short;");
        validBoxing.add("ZLjava/lang/Boolean;");
        NO_ANNOTATIONS = Collections.emptyList();
    }

    static class TypeCollector
    extends SignatureVisitor {
        List<String> types = null;

        public TypeCollector() {
            super(458752);
        }

        @Override
        public void visitClassType(String name) {
            if (this.types == null) {
                this.types = new ArrayList<String>();
            }
            this.types.add(name);
        }

        public List<String> getTypes() {
            if (this.types == null) {
                return Collections.emptyList();
            }
            return this.types;
        }
    }
}

