/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graal.support;

import com.oracle.svm.core.configure.ResourcesRegistry;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.springframework.graal.domain.reflect.Flag;
import org.springframework.graal.domain.resources.ResourcesDescriptor;
import org.springframework.graal.domain.resources.ResourcesJsonMarshaller;
import org.springframework.graal.support.ConfigOptions;
import org.springframework.graal.support.DynamicProxiesHandler;
import org.springframework.graal.support.ReflectionHandler;
import org.springframework.graal.support.SpringFeature;
import org.springframework.graal.support.TypeAccessRequestor;
import org.springframework.graal.support.Utils;
import org.springframework.graal.type.AccessBits;
import org.springframework.graal.type.CompilationHint;
import org.springframework.graal.type.Hint;
import org.springframework.graal.type.Method;
import org.springframework.graal.type.MissingTypeException;
import org.springframework.graal.type.Type;
import org.springframework.graal.type.TypeSystem;

public class ResourcesHandler {
    private static final String EnableAutoconfigurationKey = "org.springframework.boot.autoconfigure.EnableAutoConfiguration";
    private static final String PropertySourceLoaderKey = "org.springframework.boot.env.PropertySourceLoader";
    private TypeSystem ts;
    private ImageClassLoader cl;
    private ReflectionHandler reflectionHandler;
    private ResourcesRegistry resourcesRegistry;
    private DynamicProxiesHandler dynamicProxiesHandler;

    public ResourcesHandler(ReflectionHandler reflectionHandler, DynamicProxiesHandler dynamicProxiesHandler) {
        this.reflectionHandler = reflectionHandler;
        this.dynamicProxiesHandler = dynamicProxiesHandler;
    }

    public ResourcesDescriptor readStaticResourcesConfiguration() {
        try {
            InputStream s = this.getClass().getResourceAsStream("/resources.json");
            ResourcesDescriptor resourcesDescriptor = ResourcesJsonMarshaller.read(s);
            return resourcesDescriptor;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void register(Feature.BeforeAnalysisAccess access) {
        this.cl = ((FeatureImpl.BeforeAnalysisAccessImpl)access).getImageClassLoader();
        this.ts = TypeSystem.get(this.cl.getClasspath());
        ResourcesDescriptor rd = this.readStaticResourcesConfiguration();
        this.resourcesRegistry = (ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class);
        System.out.println("Registering resources - #" + rd.getPatterns().size() + " patterns");
        for (String pattern : rd.getPatterns()) {
            if (pattern.equals("META-INF/spring.factories")) continue;
            this.resourcesRegistry.addResources(pattern);
        }
        this.registerResourceBundles(rd);
        this.processSpringFactories();
        this.processExistingOrSynthesizedSpringComponentsFiles();
        this.handleSpringConstantHints();
    }

    private void handleSpringConstantHints() {
        List<CompilationHint> constantHints = this.ts.findHints("java.lang.Object");
        SpringFeature.log("Registering fixed entries: " + constantHints);
        for (CompilationHint ch : constantHints) {
            Map<String, Integer> dependantTypes = ch.getDependantTypes();
            for (Map.Entry<String, Integer> dependantType : dependantTypes.entrySet()) {
                this.reflectionHandler.addAccess(dependantType.getKey(), null, true, AccessBits.getFlags(dependantType.getValue()));
            }
        }
    }

    private void registerResourceBundles(ResourcesDescriptor rd) {
        System.out.println("Registering resources - #" + rd.getBundles().size() + " bundles");
        for (String bundle : rd.getBundles()) {
            try {
                ResourceBundle.getBundle(bundle);
                this.resourcesRegistry.addResourceBundles(bundle);
            }
            catch (MissingResourceException missingResourceException) {}
        }
    }

    public void processExistingOrSynthesizedSpringComponentsFiles() {
        Enumeration<URL> springComponents = this.fetchResources("META-INF/spring.components");
        if (springComponents.hasMoreElements()) {
            this.log("Processing META-INF/spring.components files...");
            while (springComponents.hasMoreElements()) {
                URL springFactory = springComponents.nextElement();
                Properties p = new Properties();
                this.loadSpringFactoryFile(springFactory, p);
                this.processSpringComponents(p);
            }
        } else {
            System.out.println("Found no META-INF/spring.components -> synthesizing one...");
            List<Map.Entry<Type, List<Type>>> components = this.scanForSpringComponents();
            List<Map.Entry<Type, List<Type>>> filteredComponents = this.filterOutNestedTypes(components);
            Properties p = new Properties();
            for (Map.Entry<Type, List<Type>> filteredComponent : filteredComponents) {
                String k = filteredComponent.getKey().getDottedName();
                p.put(k, filteredComponent.getValue().stream().map(t -> t.getDottedName()).collect(Collectors.joining(",")));
            }
            System.out.println("Computed spring.components is ");
            System.out.println("vvv");
            for (Object k : p.keySet()) {
                System.out.println(k + "=" + p.getProperty((String)k));
            }
            System.out.println("^^^");
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                p.store(baos, "");
                baos.close();
                byte[] bs = baos.toByteArray();
                ByteArrayInputStream bais = new ByteArrayInputStream(bs);
                Resources.registerResource((String)"META-INF/spring.components", (InputStream)bais);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            this.processSpringComponents(p);
        }
    }

    private void processSpringComponents(Properties p) {
        Enumeration<Object> keys = p.keys();
        int registeredComponents = 0;
        ResourcesRegistry resourcesRegistry = (ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class);
        while (keys.hasMoreElements()) {
            boolean isRepository = false;
            String k = (String)keys.nextElement();
            SpringFeature.log("Registering Spring Component: " + k);
            ++registeredComponents;
            String vs = (String)p.get(k);
            try {
                boolean includeFields = true;
                if (includeFields) {
                    this.reflectionHandler.addAccess(k, Flag.allDeclaredConstructors, Flag.allDeclaredMethods, Flag.allDeclaredClasses, Flag.allDeclaredFields);
                } else {
                    this.reflectionHandler.addAccess(k, Flag.allDeclaredConstructors, Flag.allDeclaredMethods, Flag.allDeclaredClasses);
                }
                resourcesRegistry.addResources(k.replace(".", "/") + ".class");
                Type baseType = this.ts.resolveDotted(k);
                if (baseType != null && (baseType.isTransactional() || baseType.hasTransactionalMethods())) {
                    this.processTransactionalTarget(baseType);
                }
                for (Type t : baseType.getNestedTypes()) {
                    String n = t.getName().replace("/", ".");
                    this.reflectionHandler.addAccess(n, Flag.allDeclaredConstructors, Flag.allDeclaredMethods, Flag.allDeclaredClasses);
                    resourcesRegistry.addResources(t.getName() + ".class");
                }
                this.registerHierarchy(baseType, new HashSet<Type>(), null);
            }
            catch (Throwable t) {
                SpringFeature.log("WHAT?" + t.toString());
                t.printStackTrace();
            }
            Type kType = this.ts.resolveDotted(k);
            if (kType != null && kType.isAtRepository()) {
                this.processRepository2(kType);
            }
            if (kType != null && kType.isAtResponseBody()) {
                this.processResponseBodyComponent(kType);
            }
            StringTokenizer st = new StringTokenizer(vs, ",");
            while (st.hasMoreElements()) {
                String tt = st.nextToken();
                if (tt.equals("org.springframework.data.repository.Repository")) {
                    isRepository = true;
                }
                try {
                    Type baseType = this.ts.resolveDotted(tt);
                    this.reflectionHandler.addAccess(tt, Flag.allDeclaredMethods);
                    resourcesRegistry.addResources(tt.replace(".", "/") + ".class");
                    for (Type t : baseType.getNestedTypes()) {
                        String n = t.getName().replace("/", ".");
                        this.reflectionHandler.addAccess(n, Flag.allDeclaredMethods);
                        resourcesRegistry.addResources(t.getName() + ".class");
                    }
                    this.registerHierarchy(baseType, new HashSet<Type>(), null);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    System.out.println("Problems with value " + tt);
                }
                if (!isRepository) continue;
                this.processRepository(k);
            }
        }
        System.out.println("Registered " + registeredComponents + " entries");
    }

    private void processResponseBodyComponent(Type t) {
        Collection<Type> returnTypes = t.collectAtMappingMarkedReturnTypes();
        SpringFeature.log("Found these return types from Mapped methods in " + t.getName() + " > " + returnTypes);
        for (Type returnType : returnTypes) {
            this.reflectionHandler.addAccess(returnType.getDottedName(), Flag.allDeclaredMethods, Flag.allDeclaredConstructors, Flag.allDeclaredFields);
        }
    }

    private void processRepository2(Type r) {
        SpringFeature.log("Processing @oss.Repository annotated " + r.getDottedName());
        ArrayList<String> repositoryInterfaces = new ArrayList<String>();
        for (String s : r.getInterfacesStrings()) {
            repositoryInterfaces.add(s.replace("/", "."));
        }
        repositoryInterfaces.add("org.springframework.aop.SpringProxy");
        repositoryInterfaces.add("org.springframework.aop.framework.Advised");
        repositoryInterfaces.add("org.springframework.core.DecoratingProxy");
        this.dynamicProxiesHandler.addProxy(repositoryInterfaces);
    }

    private void processRepository(String repositoryName) {
        SpringFeature.log("Processing repository: " + repositoryName + " - adding proxy implementing Repository, TransactionalProxy, Advised, DecoratingProxy");
        Type type = this.ts.resolveDotted(repositoryName);
        ArrayList<String> repositoryInterfaces = new ArrayList<String>();
        repositoryInterfaces.add(type.getDottedName());
        repositoryInterfaces.add("org.springframework.data.repository.Repository");
        repositoryInterfaces.add("org.springframework.transaction.interceptor.TransactionalProxy");
        repositoryInterfaces.add("org.springframework.aop.framework.Advised");
        repositoryInterfaces.add("org.springframework.core.DecoratingProxy");
        this.dynamicProxiesHandler.addProxy(repositoryInterfaces);
        repositoryInterfaces.clear();
        repositoryInterfaces.add(type.getDottedName());
        repositoryInterfaces.add("org.springframework.aop.SpringProxy");
        repositoryInterfaces.add("org.springframework.aop.framework.Advised");
        repositoryInterfaces.add("org.springframework.core.DecoratingProxy");
        this.dynamicProxiesHandler.addProxy(repositoryInterfaces);
    }

    private void processTransactionalTarget(Type type) {
        ArrayList<String> transactionalInterfaces = new ArrayList<String>();
        for (Type intface : type.getInterfaces()) {
            transactionalInterfaces.add(intface.getDottedName());
        }
        transactionalInterfaces.add("org.springframework.aop.SpringProxy");
        transactionalInterfaces.add("org.springframework.aop.framework.Advised");
        transactionalInterfaces.add("org.springframework.core.DecoratingProxy");
        this.dynamicProxiesHandler.addProxy(transactionalInterfaces);
        SpringFeature.log("Created transaction related proxy for interfaces: " + transactionalInterfaces);
    }

    public void registerHierarchy(Type type, Set<Type> visited, TypeAccessRequestor typesToMakeAccessible) {
        if (type == null || !visited.add(type)) {
            return;
        }
        String desc = type.getName();
        if (type.isCondition()) {
            if (type.hasOnlySimpleConstructor()) {
                if (typesToMakeAccessible != null) {
                    typesToMakeAccessible.request(type.getDottedName(), 5);
                } else {
                    this.reflectionHandler.addAccess(desc.replace("/", "."), Flag.allDeclaredConstructors, Flag.allDeclaredMethods, Flag.allDeclaredClasses);
                    this.resourcesRegistry.addResources(desc.replace("$", ".") + ".class");
                }
            } else if (typesToMakeAccessible != null) {
                typesToMakeAccessible.request(type.getDottedName(), 5);
            } else {
                this.reflectionHandler.addAccess(desc.replace("/", "."), Flag.allDeclaredConstructors);
                this.resourcesRegistry.addResources(desc.replace("$", ".") + ".class");
            }
        } else if (typesToMakeAccessible != null) {
            typesToMakeAccessible.request(type.getDottedName(), 13);
        } else {
            this.reflectionHandler.addAccess(desc.replace("/", "."), Flag.allDeclaredConstructors, Flag.allDeclaredMethods);
            this.resourcesRegistry.addResources(desc.replace("$", ".") + ".class");
        }
        List<String> relatedTypes = type.getTypesInSignature();
        for (String relatedType : relatedTypes) {
            this.registerHierarchy(this.ts.resolveSlashed(relatedType), visited, typesToMakeAccessible);
        }
    }

    public void processSpringFactories() {
        this.log("Processing META-INF/spring.factories files...");
        Enumeration<URL> springFactories = this.fetchResources("META-INF/spring.factories");
        while (springFactories.hasMoreElements()) {
            URL springFactory = springFactories.nextElement();
            this.processSpringFactory(this.ts, springFactory);
        }
    }

    private List<Map.Entry<Type, List<Type>>> filterOutNestedTypes(List<Map.Entry<Type, List<Type>>> springComponents) {
        ArrayList<Map.Entry<Type, List<Type>>> filtered = new ArrayList<Map.Entry<Type, List<Type>>>();
        ArrayList subtypesToRemove = new ArrayList();
        for (Map.Entry<Type, List<Type>> a : springComponents) {
            String type = a.getKey().getDottedName();
            subtypesToRemove.addAll(springComponents.stream().filter(e -> ((Type)e.getKey()).getDottedName().startsWith(type + "$")).collect(Collectors.toList()));
        }
        filtered.addAll(springComponents);
        filtered.removeAll(subtypesToRemove);
        return filtered;
    }

    private List<Map.Entry<Type, List<Type>>> scanForSpringComponents() {
        return this.findDirectories(this.ts.getClasspath()).flatMap(this::findClasses).map(this::typenameOfClass).map(this::getStereoTypesOnType).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Map.Entry<Type, List<Type>> getStereoTypesOnType(String slashedClassname) {
        return this.ts.resolveSlashed(slashedClassname).getRelevantStereotypes();
    }

    private String typenameOfClass(File f) {
        return Utils.scanClass(f).getClassname();
    }

    private Stream<File> findClasses(File dir) {
        ArrayList<File> classfiles = new ArrayList<File>();
        this.walk(dir, classfiles);
        return classfiles.stream();
    }

    private void walk(File dir, ArrayList<File> classfiles) {
        File[] fs;
        for (File f : fs = dir.listFiles()) {
            if (f.isDirectory()) {
                this.walk(f, classfiles);
                continue;
            }
            if (!f.getName().endsWith(".class")) continue;
            classfiles.add(f);
        }
    }

    private Stream<File> findDirectories(List<String> classpath) {
        ArrayList<File> directories = new ArrayList<File>();
        for (String classpathEntry : classpath) {
            File f = new File(classpathEntry);
            if (!f.isDirectory()) continue;
            directories.add(f);
        }
        return directories.stream();
    }

    private void registerTypeReferencedBySpringFactoriesKey(String s) {
        try {
            Type t = this.ts.resolveDotted(s, true);
            if (t != null) {
                if (t.hasOnlySimpleConstructor()) {
                    this.reflectionHandler.addAccess(s, new String[][]{{"<init>"}}, false, new Flag[0]);
                } else {
                    this.reflectionHandler.addAccess(s, Flag.allDeclaredConstructors);
                }
            }
        }
        catch (NoClassDefFoundError ncdfe) {
            System.out.println("spring.factories processing, problem adding access for key " + s + ": " + ncdfe.getMessage());
        }
    }

    private void processSpringFactory(TypeSystem ts, URL springFactory) {
        String enableAutoConfigurationValues;
        ArrayList<String> forRemoval = new ArrayList<String>();
        Properties p = new Properties();
        this.loadSpringFactoryFile(springFactory, p);
        int excludedAutoConfigCount = 0;
        Enumeration<Object> factoryKeys = p.keys();
        while (factoryKeys.hasMoreElements()) {
            String k = (String)factoryKeys.nextElement();
            SpringFeature.log("Adding all the classes for this key: " + k);
            if (k.equals(EnableAutoconfigurationKey) || k.equals(PropertySourceLoaderKey)) continue;
            if (Type.shouldBeProcessed(k, ts)) {
                for (String v : p.getProperty(k).split(",")) {
                    this.registerTypeReferencedBySpringFactoriesKey(v);
                }
                continue;
            }
            SpringFeature.log("Skipping processing spring.factories key " + k + " due to missing types");
        }
        String propertySourceLoaderValues = (String)p.get(PropertySourceLoaderKey);
        if (propertySourceLoaderValues != null) {
            ArrayList<String> propertySourceLoaders = new ArrayList<String>();
            for (String s : propertySourceLoaderValues.split(",")) {
                if (!s.equals("org.springframework.boot.env.YamlPropertySourceLoader") || !ConfigOptions.shouldRemoveYamlSupport()) {
                    this.registerTypeReferencedBySpringFactoriesKey(s);
                    propertySourceLoaders.add(s);
                    continue;
                }
                forRemoval.add(s);
            }
            System.out.println("Processing spring.factories - PropertySourceLoader lists #" + propertySourceLoaders.size() + " property source loaders");
            SpringFeature.log("These property source loaders are remaining in the PropertySourceLoader key value:");
            for (int c = 0; c < propertySourceLoaders.size(); ++c) {
                SpringFeature.log(c + 1 + ") " + (String)propertySourceLoaders.get(c));
            }
            p.put(PropertySourceLoaderKey, String.join((CharSequence)",", propertySourceLoaders));
        }
        if ((enableAutoConfigurationValues = (String)p.get(EnableAutoconfigurationKey)) != null) {
            ArrayList<String> configurations = new ArrayList<String>();
            for (String s : enableAutoConfigurationValues.split(",")) {
                configurations.add(s);
            }
            System.out.println("Processing spring.factories - EnableAutoConfiguration lists #" + configurations.size() + " configurations");
            for (String config : configurations) {
                if (this.checkAndRegisterConfigurationType(config) || !ConfigOptions.shouldRemoveUnusedAutoconfig()) continue;
                ++excludedAutoConfigCount;
                SpringFeature.log("Excluding auto-configuration " + config);
                forRemoval.add(config);
            }
            if (ConfigOptions.shouldRemoveUnusedAutoconfig()) {
                System.out.println("Excluding " + excludedAutoConfigCount + " auto-configurations from spring.factories file");
                configurations.removeAll(forRemoval);
                p.put(EnableAutoconfigurationKey, String.join((CharSequence)",", configurations));
                SpringFeature.log("These configurations are remaining in the EnableAutoConfiguration key value:");
                for (int c = 0; c < configurations.size(); ++c) {
                    SpringFeature.log(c + 1 + ") " + (String)configurations.get(c));
                }
            }
        }
        try {
            if (forRemoval.size() == 0) {
                Resources.registerResource((String)"META-INF/spring.factories", (InputStream)springFactory.openStream());
            } else {
                SpringFeature.log("  removed " + forRemoval.size() + " classes");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                p.store(baos, "");
                baos.close();
                byte[] bs = baos.toByteArray();
                SpringFeature.log("The new spring.factories is: vvvvvvvvv");
                SpringFeature.log(new String(bs));
                SpringFeature.log("^^^^^^^^");
                ByteArrayInputStream bais = new ByteArrayInputStream(bs);
                Resources.registerResource((String)"META-INF/spring.factories", (InputStream)bais);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void loadSpringFactoryFile(URL springFactory, Properties p) {
        try (InputStream is = springFactory.openStream();){
            p.load(is);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to load spring.factories", e);
        }
    }

    private boolean checkAndRegisterConfigurationType(String name) {
        return this.processType(name, new HashSet<String>());
    }

    private boolean processType(String config, Set<String> visited) {
        SpringFeature.log("\n\nProcessing configuration type " + config);
        boolean b = this.processType(this.ts.resolveDotted(config), visited, 0);
        SpringFeature.log("Configuration type " + config + " has " + (b ? "passed" : "failed") + " validation");
        return b;
    }

    private boolean registerSpecific(String typename, Integer typeKind, TypeAccessRequestor tar) {
        Type t = this.ts.resolveDotted(typename, true);
        if (t == null) {
            SpringFeature.log("WARNING: Unable to resolve specific type: " + typename);
            return false;
        }
        boolean importRegistrarOrSelector = false;
        try {
            importRegistrarOrSelector = t.isImportRegistrar() || t.isImportSelector();
        }
        catch (MissingTypeException mte) {
            return false;
        }
        if (importRegistrarOrSelector) {
            tar.request(typename, 6);
        } else {
            if (AccessBits.isResourceAccessRequired(typeKind)) {
                tar.request(typename, 1);
                tar.request(typename, typeKind);
            } else {
                tar.request(typename, typeKind);
            }
            if (t.isAtConfiguration()) {
                this.registerHierarchy(t, new HashSet<Type>(), tar);
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean processType(Type type, Set<String> visited, int depth) {
        List<Object> hints;
        SpringFeature.log(this.spaces(depth) + "Analyzing " + type.getDottedName());
        Set<String> missingTypes = this.ts.findMissingTypesInHierarchyOfThisType(type);
        if (!missingTypes.isEmpty()) {
            SpringFeature.log(this.spaces(depth) + "for " + type.getName() + " missing types are " + missingTypes);
            return false;
        }
        Set<String> missingAnnotationTypes = this.ts.resolveCompleteFindMissingAnnotationTypes(type);
        if (!missingAnnotationTypes.isEmpty()) {
            SpringFeature.log(this.spaces(depth) + "for " + type.getName() + " missing annotation types are " + missingAnnotationTypes);
        }
        boolean passesTests = true;
        Map<String, String> conditionalOnPropertyValues = type.getAnnotationValuesInHierarchy("Lorg/springframework/boot/autoconfigure/condition/ConditionalOnProperty;");
        if (depth == 0 && ConfigOptions.shouldRemoveUnusedAutoconfig() && conditionalOnPropertyValues.size() != 0 && (conditionalOnPropertyValues.get("matchIfMissing") == null || conditionalOnPropertyValues.get("matchIfMissing").equals("false"))) {
            SpringFeature.log(this.spaces(depth) + "skipping " + type.getName() + " due to ConditionalOnPropertyCheck");
            passesTests = false;
        }
        TypeAccessRequestor tar = new TypeAccessRequestor();
        List<Object> list = hints = passesTests ? type.getHints() : Collections.emptyList();
        if (hints.size() != 0) {
            SpringFeature.log(this.spaces(depth) + hints.size() + " hints on " + type.getDottedName() + " are: ");
            for (int h = 0; h < hints.size(); ++h) {
                SpringFeature.log(this.spaces(depth) + (h + 1) + ") " + hints.get(h));
            }
        } else {
            SpringFeature.log(this.spaces(depth) + "no hints on " + type.getName());
        }
        ArrayList<Type> toFollow = new ArrayList<Type>();
        if (!hints.isEmpty()) {
            block1: for (Hint hint : hints) {
                Map<String, Integer> inferredTypes;
                SpringFeature.log(this.spaces(depth) + "processing hint " + hint);
                Map<String, Integer> map = hint.getSpecificTypes();
                if (map.size() > 0) {
                    SpringFeature.log(this.spaces(depth) + "attempting registration of " + map.size() + " specific types");
                    for (Map.Entry<String, Integer> specificNameEntry : map.entrySet()) {
                        String specificTypeName = (String)specificNameEntry.getKey();
                        if (!this.registerSpecific(specificTypeName, (Integer)specificNameEntry.getValue(), tar)) {
                            if (!hint.isSkipIfTypesMissing()) continue;
                            passesTests = false;
                            break;
                        }
                        if (!hint.isFollow()) continue;
                        SpringFeature.log(this.spaces(depth) + "will follow specific type reference " + specificTypeName);
                        toFollow.add(this.ts.resolveDotted(specificTypeName));
                    }
                }
                if ((inferredTypes = hint.getInferredTypes()).size() > 0) {
                    Map.Entry<String, Integer> specificNameEntry;
                    SpringFeature.log(this.spaces(depth) + "attempting registration of " + inferredTypes.size() + " inferred types");
                    specificNameEntry = inferredTypes.entrySet().iterator();
                    while (specificNameEntry.hasNext()) {
                        boolean exists;
                        Map.Entry inferredType = (Map.Entry)specificNameEntry.next();
                        String s = (String)inferredType.getKey();
                        Type t = this.ts.resolveDotted(s, true);
                        boolean bl = exists = t != null;
                        if (!exists) {
                            SpringFeature.log(this.spaces(depth) + "inferred type " + s + " not found");
                        }
                        if (exists) {
                            tar.request(s, (Integer)inferredType.getValue());
                            if (!hint.isFollow()) continue;
                            SpringFeature.log(this.spaces(depth) + "will follow " + t);
                            toFollow.add(t);
                            continue;
                        }
                        if (!hint.isSkipIfTypesMissing() || depth != 0) continue;
                        passesTests = false;
                        break block1;
                    }
                }
                List<Type> annotationChain = hint.getAnnotationChain();
                this.registerAnnotationChain(depth, tar, annotationChain);
            }
        }
        String configNameDotted = type.getDottedName();
        visited.add(type.getName());
        if (passesTests || !ConfigOptions.shouldRemoveUnusedAutoconfig()) {
            void var12_15;
            if (type.isCondition()) {
                if (type.hasOnlySimpleConstructor()) {
                    this.reflectionHandler.addAccess(configNameDotted, new String[][]{{"<init>"}}, true, new Flag[0]);
                } else {
                    this.reflectionHandler.addAccess(configNameDotted, null, true, Flag.allDeclaredConstructors);
                }
            } else {
                this.reflectionHandler.addAccess(configNameDotted, Flag.allDeclaredConstructors, Flag.allDeclaredMethods);
            }
            this.resourcesRegistry.addResources(type.getName().replace("$", ".") + ".class");
            this.registerHierarchy(type, new HashSet<Type>(), tar);
            Type type2 = type.getSuperclass();
            while (var12_15 != null && !var12_15.getName().equals("java/lang/Object") && visited.add(var12_15.getName())) {
                boolean bl = this.processType((Type)var12_15, visited, depth + 1);
                if (!bl) {
                    SpringFeature.log(this.spaces(depth) + "WARNING: whilst processing type " + type.getName() + " superclass " + var12_15.getName() + " verification failed");
                }
                Type type3 = var12_15.getSuperclass();
            }
        }
        if (passesTests || !ConfigOptions.shouldRemoveUnusedAutoconfig()) {
            if (type.isAtConfiguration()) {
                List<Method> atBeanMethods;
                List<Method> methodsWithAtBean;
                List<Type> list2 = type.getAutoConfigureBeforeOrAfter();
                if (list2.size() != 0) {
                    SpringFeature.log(this.spaces(depth) + "registering " + list2.size() + " @AutoConfigureBefore/After references");
                }
                for (Type t : list2) {
                    tar.request(t.getDottedName(), 2);
                }
                int n = type.getMethodCount();
                int rogue = n - (methodsWithAtBean = type.getMethodsWithAtBean()).size();
                if (rogue != 0) {
                    SpringFeature.log(this.spaces(depth) + "WARNING: Methods unnecessarily being exposed by reflection on this config type " + type.getName() + " = " + rogue + " (total methods including @Bean ones:" + n + ")");
                }
                if ((atBeanMethods = type.getMethodsWithAtBean()).size() != 0) {
                    SpringFeature.log(this.spaces(depth) + "processing " + atBeanMethods.size() + " @Bean methods");
                }
                for (Method atBeanMethod : atBeanMethods) {
                    Type returnType = atBeanMethod.getReturnType();
                    if (returnType == null) continue;
                    Set<Type> ts = atBeanMethod.getSignatureTypes();
                    for (Type t : ts) {
                        SpringFeature.log("Processing @Bean method " + atBeanMethod.getName() + "(): adding " + t.getDottedName());
                        tar.request(t.getDottedName(), 14);
                    }
                    List<Hint> methodHints = atBeanMethod.getHints();
                    SpringFeature.log(this.spaces(depth) + "hints on method " + atBeanMethod + ":\n" + methodHints);
                    for (Hint hint : methodHints) {
                        SpringFeature.log(this.spaces(depth) + "processing hint " + hint);
                        Map<String, Integer> specificNames = hint.getSpecificTypes();
                        SpringFeature.log(this.spaces(depth) + "attempting registration of " + specificNames.size() + " specific types");
                        for (Map.Entry<String, Integer> entry : specificNames.entrySet()) {
                            this.registerSpecific(entry.getKey(), entry.getValue(), tar);
                        }
                        Map<String, Integer> inferredTypes = hint.getInferredTypes();
                        SpringFeature.log(this.spaces(depth) + "attempting registration of " + inferredTypes.size() + " inferred types");
                        for (Map.Entry<String, Integer> inferredType : inferredTypes.entrySet()) {
                            boolean exists;
                            String s = inferredType.getKey();
                            Type t = this.ts.resolveDotted(s, true);
                            boolean bl = exists = t != null;
                            if (!exists) {
                                SpringFeature.log(this.spaces(depth) + "inferred type " + s + " not found (whilst processing @Bean method " + atBeanMethod + ")");
                            } else {
                                SpringFeature.log(this.spaces(depth) + "inferred type " + s + " found, will get accessibility " + inferredType.getValue() + " (whilst processing @Bean method " + atBeanMethod + ")");
                            }
                            if (exists) {
                                tar.request(s, inferredType.getValue());
                                if (!hint.isFollow()) continue;
                                toFollow.add(t);
                                continue;
                            }
                            if (!hint.isSkipIfTypesMissing()) continue;
                            passesTests = false;
                        }
                        List<Type> list3 = hint.getAnnotationChain();
                        this.registerAnnotationChain(depth, tar, list3);
                    }
                    List<Type> annotationsOnMethod = atBeanMethod.getAnnotationTypes();
                    for (Type annotationOnMethod : annotationsOnMethod) {
                        tar.request(annotationOnMethod.getDottedName(), 11);
                    }
                }
            }
            for (Type type4 : toFollow) {
                boolean b = this.processType(type4, visited, depth + 1);
                if (b) continue;
                SpringFeature.log(this.spaces(depth) + "followed " + type4.getName() + " and it failed validation");
            }
            for (Map.Entry<String, Integer> entry : tar.entrySet()) {
                String dname = entry.getKey();
                if (this.reflectionHandler.getConstantData().hasClassDescriptor(dname)) {
                    System.out.println("This is in the constant data, does it need to stay in there? " + dname + "  (dynamically requested access is " + entry.getValue() + ")");
                }
                SpringFeature.log(this.spaces(depth) + "making this accessible: " + dname + "   " + AccessBits.toString(entry.getValue()));
                Flag[] flags = AccessBits.getFlags(entry.getValue());
                if (flags != null && flags.length == 1 && flags[0] == Flag.allDeclaredConstructors) {
                    Type resolvedType = this.ts.resolveDotted(dname, true);
                    if (resolvedType != null && resolvedType.hasOnlySimpleConstructor()) {
                        this.reflectionHandler.addAccess(dname, new String[][]{{"<init>"}}, true, new Flag[0]);
                    } else {
                        this.reflectionHandler.addAccess(dname, null, true, flags);
                    }
                } else {
                    this.reflectionHandler.addAccess(dname, null, true, flags);
                }
                if (!AccessBits.isResourceAccessRequired(entry.getValue())) continue;
                this.resourcesRegistry.addResources(dname.replace(".", "/").replace("$", ".").replace("[", "\\[").replace("]", "\\]") + ".class");
            }
        }
        if (passesTests || !ConfigOptions.shouldRemoveUnusedAutoconfig()) {
            List<Type> list4 = type.getNestedTypes();
            for (Type t : list4) {
                boolean b;
                if (!visited.add(t.getName()) || (b = this.processType(t, visited, depth + 1))) continue;
                SpringFeature.log(this.spaces(depth) + "verification of nested type " + t.getName() + " failed");
            }
        }
        return passesTests;
    }

    private void registerAnnotationChain(int depth, TypeAccessRequestor tar, List<Type> annotationChain) {
        SpringFeature.log(this.spaces(depth) + "attempting registration of " + annotationChain.size() + " elements of annotation chain");
        for (int i = 0; i < annotationChain.size(); ++i) {
            Type t = annotationChain.get(i);
            tar.request(t.getDottedName(), t.isAnnotation() ? 11 : 31);
        }
    }

    private Enumeration<URL> fetchResources(String resource) {
        try {
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(resource);
            return resources;
        }
        catch (IOException e1) {
            return Collections.enumeration(Collections.emptyList());
        }
    }

    private void log(String msg) {
        System.out.println(msg);
    }

    private String spaces(int depth) {
        return "                                                  ".substring(0, depth * 2);
    }
}

