/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graal.domain.proxies;

import java.util.ArrayList;
import java.util.List;

public final class ProxyDescriptor
implements Comparable<ProxyDescriptor> {
    private List<String> interfaces;

    ProxyDescriptor() {
    }

    ProxyDescriptor(List<String> interfaces) {
        this.interfaces = interfaces;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxyDescriptor other = (ProxyDescriptor)o;
        boolean result = true;
        result = result && this.nullSafeEquals(this.interfaces, other.interfaces);
        return result;
    }

    public int hashCode() {
        int result = this.nullSafeHashCode(this.interfaces);
        return result;
    }

    private boolean nullSafeEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    private int nullSafeHashCode(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        this.buildToStringProperty(string, "interfaces", this.interfaces);
        return string.toString();
    }

    protected void buildToStringProperty(StringBuilder string, String property, Object value) {
        if (value != null) {
            string.append(" ").append(property).append(":").append(value);
        }
    }

    @Override
    public int compareTo(ProxyDescriptor o) {
        List<String> l = this.interfaces;
        List<String> r = o.interfaces;
        if (l.size() != r.size()) {
            return l.size() - r.size();
        }
        for (int i = 0; i < l.size(); ++i) {
            int cmpTo = l.get(i).compareTo(r.get(i));
            if (cmpTo == 0) continue;
            return cmpTo;
        }
        return 0;
    }

    public static ProxyDescriptor of(List<String> interfaces) {
        ProxyDescriptor pd = new ProxyDescriptor();
        pd.setInterfaces(interfaces);
        return pd;
    }

    public List<String> getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(List<String> interfaces) {
        this.interfaces = new ArrayList<String>();
        this.interfaces.addAll(interfaces);
    }

    public boolean containsInterface(String intface) {
        return this.interfaces.contains(intface);
    }
}

