/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graal.domain.proxies;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.springframework.graal.domain.proxies.ProxiesDescriptor;
import org.springframework.graal.domain.proxies.ProxiesDescriptorJsonConverter;
import org.springframework.graal.domain.proxies.ProxyDescriptor;
import org.springframework.graal.json.JSONArray;

public class ProxiesDescriptorJsonMarshaller {
    private static final int BUFFER_SIZE = 4098;

    public void write(ProxiesDescriptor metadata, OutputStream outputStream) throws IOException {
        try {
            ProxiesDescriptorJsonConverter converter = new ProxiesDescriptorJsonConverter();
            JSONArray jsonArray = converter.toJsonArray(metadata);
            outputStream.write(jsonArray.toString(2).getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new IllegalStateException(ex);
        }
    }

    public static ProxiesDescriptor read(String input) throws Exception {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));){
            ProxiesDescriptor proxiesDescriptor = ProxiesDescriptorJsonMarshaller.read(bais);
            return proxiesDescriptor;
        }
    }

    public static ProxiesDescriptor read(byte[] input) throws Exception {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(input);){
            ProxiesDescriptor proxiesDescriptor = ProxiesDescriptorJsonMarshaller.read(bais);
            return proxiesDescriptor;
        }
    }

    public static ProxiesDescriptor read(InputStream inputStream) throws Exception {
        ProxiesDescriptor metadata = ProxiesDescriptorJsonMarshaller.toProxiesDescriptor(new JSONArray(ProxiesDescriptorJsonMarshaller.toString(inputStream)));
        return metadata;
    }

    private static ProxiesDescriptor toProxiesDescriptor(JSONArray array) throws Exception {
        ProxiesDescriptor pds = new ProxiesDescriptor();
        for (int i = 0; i < array.length(); ++i) {
            pds.add(ProxiesDescriptorJsonMarshaller.toProxyDescriptor((JSONArray)array.get(i)));
        }
        return pds;
    }

    private static ProxyDescriptor toProxyDescriptor(JSONArray array) throws Exception {
        ProxyDescriptor pd = new ProxyDescriptor();
        ArrayList<String> interfaces = new ArrayList<String>();
        for (int i = 0; i < array.length(); ++i) {
            interfaces.add(array.getString(i));
        }
        pd.setInterfaces(interfaces);
        return pd;
    }

    private static String toString(InputStream inputStream) throws IOException {
        int bytesRead;
        StringBuilder out = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        char[] buffer = new char[4098];
        while ((bytesRead = reader.read(buffer)) != -1) {
            out.append(buffer, 0, bytesRead);
        }
        return out.toString();
    }
}

