/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.test.context.bootstrap.generator;

import java.util.ArrayList;
import java.util.List;
import org.springframework.aot.test.context.bootstrap.generator.AotTestContextProcessor;
import org.springframework.aot.test.context.bootstrap.generator.TestContextConfigurationDescriptor;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.test.context.BootstrapContext;
import org.springframework.test.context.BootstrapWith;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContextBootstrapper;
import org.springframework.test.context.cache.DefaultCacheAwareContextLoaderDelegate;
import org.springframework.test.context.support.DefaultBootstrapContext;
import org.springframework.test.context.support.DefaultTestContextBootstrapper;

class TestContextConfigurationDescriptorFactory {
    private final List<AotTestContextProcessor> aotTestContextProcessors;
    private final CacheAwareContextLoaderDelegate contextLoaderDelegate;

    TestContextConfigurationDescriptorFactory(List<AotTestContextProcessor> aotTestContextProcessors) {
        this.aotTestContextProcessors = aotTestContextProcessors;
        this.contextLoaderDelegate = new DefaultCacheAwareContextLoaderDelegate();
    }

    TestContextConfigurationDescriptorFactory(ClassLoader classLoader) {
        this(SpringFactoriesLoader.loadFactories(AotTestContextProcessor.class, (ClassLoader)classLoader));
    }

    List<TestContextConfigurationDescriptor> buildConfigurationDescriptors(Iterable<Class<?>> testClasses) {
        ArrayList<TestContextConfigurationDescriptor> descriptors = new ArrayList<TestContextConfigurationDescriptor>();
        for (Class<?> testClass : testClasses) {
            TestContextBootstrapper testContextBootstrapper = this.createTestContextBootstrapper(testClass);
            MergedContextConfiguration contextConfiguration = testContextBootstrapper.buildMergedContextConfiguration();
            AotTestContextProcessor testContextProcessor = this.findAotTestContextProcessor(testContextBootstrapper);
            TestContextConfigurationDescriptor existingDescriptor = descriptors.stream().filter(descriptor -> descriptor.isSameContext(contextConfiguration)).findFirst().orElse(null);
            if (existingDescriptor != null) {
                existingDescriptor.registerTestClass(testClass);
                continue;
            }
            descriptors.add(new TestContextConfigurationDescriptor(testContextBootstrapper.getClass(), contextConfiguration, testContextProcessor));
        }
        return descriptors;
    }

    private AotTestContextProcessor findAotTestContextProcessor(TestContextBootstrapper bootstrapper) {
        for (AotTestContextProcessor processor : this.aotTestContextProcessors) {
            if (!processor.supports(bootstrapper)) continue;
            return processor;
        }
        throw new IllegalStateException("No processor found for " + bootstrapper);
    }

    TestContextBootstrapper createTestContextBootstrapper(Class<?> testClass) {
        DefaultBootstrapContext bootstrapContext = new DefaultBootstrapContext(testClass, this.contextLoaderDelegate);
        TestContextBootstrapper bootstrapper = (TestContextBootstrapper)BeanUtils.instantiateClass(this.getTestContextBootstrapperType(testClass));
        bootstrapper.setBootstrapContext((BootstrapContext)bootstrapContext);
        return bootstrapper;
    }

    private Class<? extends TestContextBootstrapper> getTestContextBootstrapperType(Class<?> testClass) {
        MergedAnnotations annotations = MergedAnnotations.from(testClass, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS);
        MergedAnnotation annotation = annotations.get(BootstrapWith.class);
        return annotation.isPresent() ? annotation.getClass("value") : DefaultTestContextBootstrapper.class;
    }
}

