/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.test.build;

import com.squareup.javapoet.JavaFile;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aot.build.AotPhase;
import org.springframework.aot.build.BootstrapContributor;
import org.springframework.aot.build.context.BuildContext;
import org.springframework.aot.build.context.SourceFile;
import org.springframework.aot.build.context.SourceFiles;
import org.springframework.aot.context.bootstrap.generator.infrastructure.BootstrapWriterContext;
import org.springframework.aot.context.bootstrap.generator.infrastructure.DefaultBootstrapWriterContext;
import org.springframework.aot.context.bootstrap.generator.infrastructure.nativex.NativeConfigurationRegistry;
import org.springframework.aot.test.context.bootstrap.generator.TestContextAotProcessor;
import org.springframework.nativex.AotOptions;
import org.springframework.nativex.domain.reflect.ReflectionDescriptor;
import org.springframework.util.ClassUtils;

public class TestContextBootstrapContributor
implements BootstrapContributor {
    private static final Log logger = LogFactory.getLog(TestContextBootstrapContributor.class);

    public void contribute(BuildContext context, AotOptions aotOptions) {
        ClassLoader classLoader = context.getClassLoader();
        if (!ClassUtils.isPresent((String)"org.springframework.test.context.CacheAwareContextLoaderDelegate", (ClassLoader)classLoader)) {
            logger.info((Object)"Skip TestContextAotProcessor because spring-test dependency is not present in the classpath");
            return;
        }
        ArrayList testClasses = new ArrayList(context.getTestClasses().size());
        for (String testClassName : context.getTestClasses()) {
            try {
                testClasses.add(ClassUtils.forName((String)testClassName, (ClassLoader)classLoader));
            }
            catch (ClassNotFoundException e) {
                logger.info((Object)("Could not load test class: " + testClassName));
            }
        }
        DefaultBootstrapWriterContext writerContext = new DefaultBootstrapWriterContext("org.springframework.aot", "Test");
        new TestContextAotProcessor(classLoader).generateTestContexts(testClasses, (BootstrapWriterContext)writerContext);
        writerContext.toJavaFiles().forEach(javaFile -> context.addSourceFiles(new SourceFile[]{SourceFiles.fromJavaFile((JavaFile)javaFile)}));
        NativeConfigurationRegistry nativeConfigurationRegistry = writerContext.getNativeConfigurationRegistry();
        context.getOptions().addAll(nativeConfigurationRegistry.options());
        context.describeReflection(reflectionDescriptor -> nativeConfigurationRegistry.reflection().toClassDescriptors().forEach(arg_0 -> ((ReflectionDescriptor)reflectionDescriptor).merge(arg_0)));
        context.describeResources(resourcesDescriptor -> resourcesDescriptor.merge(nativeConfigurationRegistry.resources().toResourcesDescriptor()));
        context.describeProxies(proxiesDescriptor -> proxiesDescriptor.merge(nativeConfigurationRegistry.proxy().toProxiesDescriptor()));
        context.describeInitialization(initializationDescriptor -> initializationDescriptor.merge(nativeConfigurationRegistry.initialization().toInitializationDescriptor()));
        context.describeSerialization(serializationDescriptor -> serializationDescriptor.merge(nativeConfigurationRegistry.serialization().toSerializationDescriptor()));
        context.describeJNIReflection(reflectionDescriptor -> nativeConfigurationRegistry.jni().toClassDescriptors().forEach(arg_0 -> ((ReflectionDescriptor)reflectionDescriptor).merge(arg_0)));
    }

    public boolean supportsAotPhase(AotPhase aotPhase) {
        return AotPhase.TEST.equals((Object)aotPhase);
    }
}

