/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.test.boot;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import org.springframework.aot.context.bootstrap.generator.bean.support.MultiCodeBlock;
import org.springframework.aot.test.boot.AotSpringBootConfigContextLoader;
import org.springframework.aot.test.boot.SpringBootBuildTimeConfigContextLoader;
import org.springframework.aot.test.context.bootstrap.generator.AotTestContextProcessor;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.test.context.ReactiveWebMergedContextConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.SpringBootTestArgsAccessor;
import org.springframework.boot.test.context.SpringBootTestContextBootstrapper;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.Order;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContextBootstrapper;
import org.springframework.test.context.web.WebMergedContextConfiguration;

@Order(value=0)
class SpringBootAotTestContextProcessor
implements AotTestContextProcessor {
    private final SpringBootBuildTimeConfigContextLoader contextLoader = new SpringBootBuildTimeConfigContextLoader();

    SpringBootAotTestContextProcessor() {
    }

    @Override
    public boolean supports(TestContextBootstrapper bootstrapper) {
        return bootstrapper instanceof SpringBootTestContextBootstrapper;
    }

    @Override
    public GenericApplicationContext prepareTestContext(MergedContextConfiguration config) {
        try {
            return this.contextLoader.loadContext(config);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to prepare test context using " + config, ex);
        }
    }

    @Override
    public CodeBlock writeInstanceSupplier(MergedContextConfiguration config, ClassName applicationContextInitializer) {
        String[] args = SpringBootTestArgsAccessor.get(config.getContextCustomizers());
        CodeBlock.Builder code = CodeBlock.builder();
        code.add("() -> new $T($T.class", new Object[]{AotSpringBootConfigContextLoader.class, applicationContextInitializer});
        WebApplicationType webApplicationType = this.detectWebApplicationType(config);
        if (!webApplicationType.equals((Object)WebApplicationType.NONE)) {
            code.add(", $T.$L, $T.$L", new Object[]{WebApplicationType.class, webApplicationType, SpringBootTest.WebEnvironment.class, this.detectWebEnvironment(config)});
        }
        if (args.length > 0) {
            MultiCodeBlock multi = new MultiCodeBlock();
            Arrays.stream(args).forEach(arg -> multi.add("$S", new Object[]{arg}));
            code.add(", $L", new Object[]{multi.join(", ")});
        }
        code.add(")", new Object[0]);
        return code.build();
    }

    private WebApplicationType detectWebApplicationType(MergedContextConfiguration config) {
        if (config instanceof WebMergedContextConfiguration) {
            return WebApplicationType.SERVLET;
        }
        if (config instanceof ReactiveWebMergedContextConfiguration) {
            return WebApplicationType.REACTIVE;
        }
        return WebApplicationType.NONE;
    }

    private SpringBootTest.WebEnvironment detectWebEnvironment(MergedContextConfiguration config) {
        return MergedAnnotations.from((AnnotatedElement)config.getTestClass(), (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(SpringBootTest.class).getValue("webEnvironment", SpringBootTest.WebEnvironment.class).orElse(SpringBootTest.WebEnvironment.NONE);
    }
}

