/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.maven;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.springframework.aot.BootstrapCodeGenerator;
import org.springframework.aot.maven.AbstractBootstrapMojo;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class GenerateMojo
extends AbstractBootstrapMojo {
    @Parameter(defaultValue="${project.build.directory}/generated-sources/spring-aot/")
    private File generatedSourcesDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        HashSet<Path> resourceFolders = new HashSet<Path>();
        for (Resource r : this.project.getResources()) {
            resourceFolders.add(new File(r.getDirectory()).toPath());
        }
        this.recreateGeneratedSourcesFolder(this.generatedSourcesDirectory);
        Path sourcesPath = this.generatedSourcesDirectory.toPath().resolve(Paths.get("src", "main", "java"));
        Path resourcesPath = this.generatedSourcesDirectory.toPath().resolve(Paths.get("src", "main", "resources"));
        try {
            List runtimeClasspathElements = this.project.getRuntimeClasspathElements();
            BootstrapCodeGenerator generator = new BootstrapCodeGenerator(this.getAotOptions());
            generator.generate(sourcesPath, resourcesPath, runtimeClasspathElements, this.mainClass, resourceFolders);
            this.compileGeneratedSources(sourcesPath, runtimeClasspathElements);
            this.processGeneratedResources(resourcesPath, Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]));
            this.buildContext.refresh(this.buildDir);
        }
        catch (Throwable exc) {
            logger.error((Object)exc);
            logger.error((Object)Arrays.toString(exc.getStackTrace()));
            throw new MojoFailureException("Build failed during Spring AOT code generation", exc);
        }
    }
}

