/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot;

import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.yarn.boot.SpringApplicationCallback;
import org.springframework.yarn.boot.SpringApplicationException;

public class SpringApplicationTemplate {
    private final SpringApplicationBuilder builder;

    public SpringApplicationTemplate(SpringApplicationBuilder builder) {
        this.builder = builder;
    }

    public <T> T execute(SpringApplicationCallback<T> action, String ... args) throws SpringApplicationException {
        ConfigurableApplicationContext context = null;
        try {
            context = this.builder.run(args);
            T t = action.runWithSpringApplication((ApplicationContext)context);
            return t;
        }
        catch (Exception e) {
            throw new SpringApplicationException("Error executing a spring application", e);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (Exception exception) {}
                context = null;
            }
        }
    }
}

