/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.support;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationListener;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.yarn.boot.properties.SpringYarnProperties;
import org.springframework.yarn.boot.support.YarnBootClientApplicationListener;

public final class SpringYarnBootUtils {
    private SpringYarnBootUtils() {
    }

    public static void mergeBootArgumentsIntoMap(String[] args, Map map) {
        if (map == null) {
            throw new IllegalArgumentException("Map must not be null");
        }
        for (String arg : args) {
            String[] split;
            if (!arg.startsWith("--") || arg.length() <= 4 || (split = arg.substring(2).split("=")).length != 2) continue;
            map.put(split[0], split[1]);
        }
    }

    public static void mergeHadoopPropertyIntoMap(Configuration configuration, String configurationKey, String propertyKey, Map map) {
        if (configuration == null) {
            return;
        }
        Assert.state((boolean)StringUtils.hasText((String)configurationKey), (String)"configurationKey must be set");
        Assert.state((boolean)StringUtils.hasText((String)propertyKey), (String)"propertyKey must be set");
        Assert.notNull((Object)map, (String)"map can't be null");
        String value = configuration.get(configurationKey);
        if (value != null) {
            map.put(propertyKey, value);
        }
    }

    public static String[] propertiesToBootArguments(Properties properties) {
        ArrayList<String> args = new ArrayList<String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            args.add("--" + entry.getKey() + "=" + entry.getValue());
        }
        return args.toArray(new String[0]);
    }

    public static void appendAsCommaDelimitedIntoProperties(String key, String[] values, Properties properties) {
        if (!ObjectUtils.isEmpty((Object[])values)) {
            String property = properties.getProperty(key);
            property = property == null ? StringUtils.arrayToCommaDelimitedString((Object[])values) : property + "," + StringUtils.arrayToCommaDelimitedString((Object[])values);
            properties.setProperty(key, property);
        }
    }

    public static void addApplicationListener(SpringApplicationBuilder builder, Properties properties) {
        if (properties != null && !properties.isEmpty()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String key : properties.stringPropertyNames()) {
                map.put(key, properties.getProperty(key));
            }
            builder.listeners(new ApplicationListener[]{new YarnBootClientApplicationListener(map)});
        }
    }

    public static void addProfiles(SpringApplicationBuilder builder, String[] additionalProfiles) {
        if (!ObjectUtils.isEmpty((Object[])additionalProfiles)) {
            builder.profiles(additionalProfiles);
        }
    }

    public static void addSources(SpringApplicationBuilder builder, Object[] sources) {
        if (!ObjectUtils.isEmpty((Object[])sources)) {
            builder.sources(sources);
        }
    }

    public static void addConfigFilesContents(SpringApplicationBuilder builder, Map<String, Properties> configFilesContents) {
        if (configFilesContents == null) {
            return;
        }
        HashMap<String, byte[]> defaultProperties = new HashMap<String, byte[]>();
        for (Map.Entry<String, Properties> entry : configFilesContents.entrySet()) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                entry.getValue().store(out, null);
                defaultProperties.put("spring.yarn.client.localizer.rawFileContents." + SpringYarnBootUtils.escapeConfigKey(entry.getKey()), out.toByteArray());
            }
            catch (IOException e) {}
        }
        builder.properties(defaultProperties);
    }

    public static String escapeConfigKey(String key) {
        return StringUtils.replace((String)key, (String)".", (String)"%2E");
    }

    public static String unescapeConfigKey(String key) {
        return StringUtils.replace((String)key, (String)"%2E", (String)".");
    }

    public static String resolveApplicationdir(SpringYarnProperties syp) {
        if (StringUtils.hasText((String)syp.getApplicationBaseDir()) && StringUtils.hasText((String)syp.getApplicationVersion())) {
            return (syp.getApplicationBaseDir().endsWith("/") ? syp.getApplicationBaseDir() : syp.getApplicationBaseDir() + "/") + syp.getApplicationVersion() + "/";
        }
        return syp.getApplicationDir();
    }
}

