/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.properties;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.data.hadoop.security.SecurityAuthMethod;
import org.springframework.util.StringUtils;
import org.springframework.yarn.boot.properties.SpringYarnEnvProperties;

@ConfigurationProperties(value="spring.hadoop")
public class SpringHadoopProperties {
    private static final Log log = LogFactory.getLog(SpringHadoopProperties.class);
    private String fsUri;
    private String resourceManagerHost;
    private String resourceManagerSchedulerHost;
    private Integer resourceManagerPort = 8032;
    private Integer resourceManagerSchedulerPort = 8030;
    private List<String> resources;
    private SpringHadoopSecurityProperties security;
    private Map<String, String> config;
    @Autowired
    private SpringYarnEnvProperties syep;

    public String getFsUri() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("syp fsUri=[" + this.fsUri + "]"));
            log.debug((Object)("syep fsUri=[" + this.syep.getFs() + "]"));
        }
        return this.syep.getFs() != null ? this.syep.getFs() : this.fsUri;
    }

    public void setFsUri(String fsUri) {
        this.fsUri = fsUri;
    }

    public String getResourceManagerAddress() {
        return this.syep.getRm() != null ? this.syep.getRm() : this.resourceManagerHost + ":" + this.getResourceManagerPort();
    }

    public void setResourceManagerAddress(String resourceManagerAddress) {
        String[] split = StringUtils.split((String)resourceManagerAddress, (String)":");
        if (split != null && split.length == 2) {
            try {
                this.resourceManagerPort = Integer.parseInt(split[1]);
                this.resourceManagerHost = split[0];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getResourceManagerSchedulerAddress() {
        return this.syep.getScheduler() != null ? this.syep.getScheduler() : this.resourceManagerSchedulerHost + ":" + this.getResourceManagerSchedulerPort();
    }

    public void setResourceManagerSchedulerAddress(String resourceManagerSchedulerAddress) {
        String[] split = StringUtils.split((String)resourceManagerSchedulerAddress, (String)":");
        if (split != null && split.length == 2) {
            try {
                this.resourceManagerSchedulerPort = Integer.parseInt(split[1]);
                this.resourceManagerSchedulerHost = split[0];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getResourceManagerHost() {
        return this.resourceManagerHost;
    }

    public void setResourceManagerHost(String resourceManagerHost) {
        this.resourceManagerHost = resourceManagerHost;
        this.resourceManagerSchedulerHost = resourceManagerHost;
    }

    public Integer getResourceManagerPort() {
        return this.resourceManagerPort;
    }

    public void setResourceManagerPort(Integer resourceManagerPort) {
        this.resourceManagerPort = resourceManagerPort;
    }

    public Integer getResourceManagerSchedulerPort() {
        return this.resourceManagerSchedulerPort;
    }

    public void setResourceManagerSchedulerPort(Integer resourceManagerSchedulerPort) {
        this.resourceManagerSchedulerPort = resourceManagerSchedulerPort;
    }

    public List<String> getResources() {
        return this.resources;
    }

    public void setResources(List<String> resources) {
        this.resources = resources;
    }

    public SpringHadoopSecurityProperties getSecurity() {
        return this.security;
    }

    public void setSecurity(SpringHadoopSecurityProperties security) {
        this.security = security;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    public static class SpringHadoopSecurityProperties {
        private SecurityAuthMethod authMethod;
        private String userPrincipal;
        private String userKeytab;
        private String namenodePrincipal;
        private String rmManagerPrincipal;

        public SecurityAuthMethod getAuthMethod() {
            return this.authMethod;
        }

        public void setAuthMethod(String authMethod) {
            if (StringUtils.hasText((String)authMethod)) {
                this.authMethod = SecurityAuthMethod.valueOf((String)authMethod.toUpperCase());
            }
        }

        public String getUserPrincipal() {
            return this.userPrincipal;
        }

        public void setUserPrincipal(String userPrincipal) {
            this.userPrincipal = userPrincipal;
        }

        public String getUserKeytab() {
            return this.userKeytab;
        }

        public void setUserKeytab(String userKeytab) {
            this.userKeytab = userKeytab;
        }

        public String getNamenodePrincipal() {
            return this.namenodePrincipal;
        }

        public void setNamenodePrincipal(String namenodePrincipal) {
            this.namenodePrincipal = namenodePrincipal;
        }

        public String getRmManagerPrincipal() {
            return this.rmManagerPrincipal;
        }

        public void setRmManagerPrincipal(String rmManagerPrincipal) {
            this.rmManagerPrincipal = rmManagerPrincipal;
        }
    }
}

