/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.app;

import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.springframework.boot.actuate.autoconfigure.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.EndpointMBeanExportAutoConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.batch.BatchAutoConfiguration;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.autoconfigure.web.EmbeddedServletContainerAutoConfiguration;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;
import org.springframework.yarn.boot.SpringApplicationCallback;
import org.springframework.yarn.boot.SpringApplicationTemplate;
import org.springframework.yarn.boot.actuate.endpoint.mvc.AbstractContainerClusterRequest;
import org.springframework.yarn.boot.actuate.endpoint.mvc.ContainerClusterCreateRequest;
import org.springframework.yarn.boot.actuate.endpoint.mvc.ContainerClusterModifyRequest;
import org.springframework.yarn.boot.actuate.endpoint.mvc.domain.ContainerClusterResource;
import org.springframework.yarn.boot.actuate.endpoint.mvc.domain.YarnContainerClusterEndpointResource;
import org.springframework.yarn.boot.app.AbstractClientApplication;
import org.springframework.yarn.boot.app.YarnContainerClusterOperations;
import org.springframework.yarn.boot.app.YarnContainerClusterTemplate;
import org.springframework.yarn.boot.support.SpringYarnBootUtils;
import org.springframework.yarn.client.YarnClient;
import org.springframework.yarn.support.console.ContainerClusterReport;

@Configuration
@EnableAutoConfiguration(exclude={EmbeddedServletContainerAutoConfiguration.class, WebMvcAutoConfiguration.class, JmxAutoConfiguration.class, BatchAutoConfiguration.class, JmxAutoConfiguration.class, EndpointMBeanExportAutoConfiguration.class, EndpointAutoConfiguration.class})
public class YarnContainerClusterApplication
extends AbstractClientApplication<String, YarnContainerClusterApplication> {
    @Override
    protected YarnContainerClusterApplication getThis() {
        return this;
    }

    @Override
    public String run() {
        return this.run(new String[0]);
    }

    @Override
    public String run(String ... args) {
        SpringApplicationBuilder builder = new SpringApplicationBuilder(new Object[0]);
        builder.web(false);
        builder.sources(new Class[]{YarnContainerClusterApplication.class, OperationProperties.class});
        SpringYarnBootUtils.addSources(builder, this.sources.toArray(new Object[0]));
        SpringYarnBootUtils.addProfiles(builder, this.profiles.toArray(new String[0]));
        SpringYarnBootUtils.addApplicationListener(builder, this.appProperties);
        SpringApplicationTemplate template = new SpringApplicationTemplate(builder);
        return template.execute(new SpringApplicationCallback<String>(){

            @Override
            public String runWithSpringApplication(ApplicationContext context) throws Exception {
                OperationProperties operationProperties = (OperationProperties)context.getBean(OperationProperties.class);
                YarnClient client = (YarnClient)context.getBean(YarnClient.class);
                RestTemplate restTemplate = (RestTemplate)context.getBean("yarnRestTemplate", RestTemplate.class);
                ApplicationId applicationId = ConverterUtils.toApplicationId((String)operationProperties.getApplicationId());
                String clusterId = operationProperties.getClusterId();
                String clusterDef = operationProperties.getClusterDef();
                String projectionType = operationProperties.getProjectionType();
                ProjectionDataProperties projectionData = operationProperties.getProjectionData();
                Integer projectionDataAny = projectionData != null ? projectionData.getAny() : null;
                Map<String, Integer> projectionDataHosts = projectionData != null ? projectionData.getHosts() : null;
                Map<String, Integer> projectionDataRacks = projectionData != null ? projectionData.getRacks() : null;
                Map<String, Object> projectionDataProperties = projectionData != null ? projectionData.getProperties() : null;
                Map<String, Object> extraProperties = operationProperties.getExtraProperties();
                Operation operation = operationProperties.getOperation();
                boolean verbose = operationProperties.isVerbose();
                if (Operation.CLUSTERSINFO == operation) {
                    return YarnContainerClusterApplication.this.doClustersInfo(restTemplate, client, applicationId);
                }
                if (Operation.CLUSTERINFO == operation) {
                    return YarnContainerClusterApplication.this.doClusterInfo(restTemplate, client, applicationId, clusterId, verbose);
                }
                if (Operation.CLUSTERCREATE == operation) {
                    return YarnContainerClusterApplication.this.doClusterCreate(restTemplate, client, applicationId, clusterId, clusterDef, projectionType, projectionDataAny, projectionDataHosts, projectionDataRacks, projectionDataProperties, extraProperties);
                }
                if (Operation.CLUSTERDESTROY == operation) {
                    return YarnContainerClusterApplication.this.doClusterDestroy(restTemplate, client, applicationId, clusterId);
                }
                if (Operation.CLUSTERMODIFY == operation) {
                    return YarnContainerClusterApplication.this.doClusterModify(restTemplate, client, applicationId, clusterId, projectionDataAny, projectionDataHosts, projectionDataRacks, projectionDataProperties);
                }
                if (Operation.CLUSTERSTART == operation) {
                    return YarnContainerClusterApplication.this.doClusterStart(restTemplate, client, applicationId, clusterId);
                }
                if (Operation.CLUSTERSTOP == operation) {
                    return YarnContainerClusterApplication.this.doClusterStop(restTemplate, client, applicationId, clusterId);
                }
                return null;
            }
        }, args);
    }

    private String doClustersInfo(RestTemplate restTemplate, YarnClient client, ApplicationId applicationId) {
        YarnContainerClusterOperations operations = this.buildClusterOperations(restTemplate, client, applicationId);
        YarnContainerClusterEndpointResource response = operations.getClusters();
        return ContainerClusterReport.clustersInfoReportBuilder().add(ContainerClusterReport.ClustersInfoField.ID).from(new ArrayList<String>(response.getClusters())).build().toString();
    }

    private String doClusterInfo(RestTemplate restTemplate, YarnClient client, ApplicationId applicationId, String clusterId, boolean verbose) {
        YarnContainerClusterOperations operations = this.buildClusterOperations(restTemplate, client, applicationId);
        ContainerClusterResource response = operations.clusterInfo(clusterId);
        ArrayList<ContainerClusterReport.ClustersInfoReportData> data = new ArrayList<ContainerClusterReport.ClustersInfoReportData>();
        Integer pany = response.getGridProjection().getProjectionData().getAny();
        Map phosts = response.getGridProjection().getProjectionData().getHosts();
        Map pracks = response.getGridProjection().getProjectionData().getRacks();
        Integer sany = response.getGridProjection().getSatisfyState().getAllocateData().getAny();
        Map<String, Integer> shosts = response.getGridProjection().getSatisfyState().getAllocateData().getHosts();
        Map<String, Integer> sracks = response.getGridProjection().getSatisfyState().getAllocateData().getRacks();
        data.add(new ContainerClusterReport.ClustersInfoReportData(response.getContainerClusterState().getClusterState().toString(), Integer.valueOf(response.getGridProjection().getMembers().size()), pany, phosts, pracks, sany, shosts, sracks));
        if (verbose) {
            return ContainerClusterReport.clusterInfoReportBuilder().add(ContainerClusterReport.ClusterInfoField.STATE).add(ContainerClusterReport.ClusterInfoField.MEMBERS).add(ContainerClusterReport.ClusterInfoField.PROJECTIONANY).add(ContainerClusterReport.ClusterInfoField.PROJECTIONHOSTS).add(ContainerClusterReport.ClusterInfoField.PROJECTIONRACKS).add(ContainerClusterReport.ClusterInfoField.SATISFYANY).add(ContainerClusterReport.ClusterInfoField.SATISFYHOSTS).add(ContainerClusterReport.ClusterInfoField.SATISFYRACKS).from(data).build().toString();
        }
        return ContainerClusterReport.clusterInfoReportBuilder().add(ContainerClusterReport.ClusterInfoField.STATE).add(ContainerClusterReport.ClusterInfoField.MEMBERS).from(data).build().toString();
    }

    private String doClusterCreate(RestTemplate restTemplate, YarnClient client, ApplicationId applicationId, String clusterId, String clusterDef, String projectionType, Integer projectionDataAny, Map<String, Integer> hosts, Map<String, Integer> racks, Map<String, Object> projectionDataProperties, Map<String, Object> extraProperties) {
        YarnContainerClusterOperations operations = this.buildClusterOperations(restTemplate, client, applicationId);
        ContainerClusterCreateRequest request = new ContainerClusterCreateRequest();
        request.setClusterId(clusterId);
        request.setClusterDef(clusterDef);
        request.setProjection(projectionType);
        request.setExtraProperties(extraProperties);
        AbstractContainerClusterRequest.ProjectionDataType projectionData = new AbstractContainerClusterRequest.ProjectionDataType();
        projectionData.setAny(projectionDataAny);
        projectionData.setHosts(hosts);
        projectionData.setRacks(racks);
        projectionData.setProperties(projectionDataProperties);
        request.setProjectionData(projectionData);
        operations.clusterCreate(request);
        return "Cluster " + clusterId + " created.";
    }

    private String doClusterDestroy(RestTemplate restTemplate, YarnClient client, ApplicationId applicationId, String clusterId) {
        YarnContainerClusterOperations operations = this.buildClusterOperations(restTemplate, client, applicationId);
        operations.clusterDestroy(clusterId);
        return "Cluster " + clusterId + " destroyed.";
    }

    private String doClusterStart(RestTemplate restTemplate, YarnClient client, ApplicationId applicationId, String clusterId) {
        YarnContainerClusterOperations operations = this.buildClusterOperations(restTemplate, client, applicationId);
        ContainerClusterModifyRequest request = new ContainerClusterModifyRequest();
        request.setAction("start");
        operations.clusterStart(clusterId, request);
        return "Cluster " + clusterId + " started.";
    }

    private String doClusterStop(RestTemplate restTemplate, YarnClient client, ApplicationId applicationId, String clusterId) {
        YarnContainerClusterOperations operations = this.buildClusterOperations(restTemplate, client, applicationId);
        ContainerClusterModifyRequest request = new ContainerClusterModifyRequest();
        request.setAction("stop");
        operations.clusterStop(clusterId, request);
        return "Cluster " + clusterId + " stopped.";
    }

    private String doClusterModify(RestTemplate restTemplate, YarnClient client, ApplicationId applicationId, String clusterId, Integer projectionDataAny, Map<String, Integer> hosts, Map<String, Integer> racks, Map<String, Object> properties) {
        YarnContainerClusterOperations operations = this.buildClusterOperations(restTemplate, client, applicationId);
        ContainerClusterCreateRequest request = new ContainerClusterCreateRequest();
        request.setClusterId(clusterId);
        AbstractContainerClusterRequest.ProjectionDataType projectionData = new AbstractContainerClusterRequest.ProjectionDataType();
        projectionData.setAny(projectionDataAny);
        projectionData.setHosts(hosts);
        projectionData.setRacks(racks);
        projectionData.setProperties(properties);
        request.setProjectionData(projectionData);
        operations.clusterModify(clusterId, request);
        return "Cluster " + clusterId + " modified.";
    }

    private YarnContainerClusterOperations buildClusterOperations(RestTemplate restTemplate, YarnClient client, ApplicationId applicationId) {
        ApplicationReport report = client.getApplicationReport(applicationId);
        String trackingUrl = report.getOriginalTrackingUrl();
        return new YarnContainerClusterTemplate(trackingUrl + "/" + "yarn_containercluster", restTemplate);
    }

    private static enum Operation {
        CLUSTERSINFO,
        CLUSTERINFO,
        CLUSTERCREATE,
        CLUSTERDESTROY,
        CLUSTERMODIFY,
        CLUSTERSTART,
        CLUSTERSTOP;

    }

    public static class ProjectionDataProperties {
        private Integer any;
        private Map<String, Integer> hosts;
        private Map<String, Integer> racks;
        private Map<String, Object> properties;

        public Integer getAny() {
            return this.any;
        }

        public void setAny(Integer any) {
            this.any = any;
        }

        public Map<String, Integer> getHosts() {
            return this.hosts;
        }

        public void setHosts(Map<String, Integer> hosts) {
            this.hosts = hosts;
        }

        public Map<String, Integer> getRacks() {
            return this.racks;
        }

        public void setRacks(Map<String, Integer> racks) {
            this.racks = racks;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, Object> properties) {
            this.properties = properties;
        }
    }

    @ConfigurationProperties(value="spring.yarn.internal.ContainerClusterApplication")
    public static class OperationProperties {
        private Operation operation;
        private String applicationId;
        private String clusterId;
        private String clusterDef;
        private String projectionType;
        private ProjectionDataProperties projectionData;
        private Map<String, Object> extraProperties;
        private boolean verbose;

        public void setOperation(Operation operation) {
            this.operation = operation;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public String getApplicationId() {
            return this.applicationId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterDef(String clusterDef) {
            this.clusterDef = clusterDef;
        }

        public String getClusterDef() {
            return this.clusterDef;
        }

        public void setProjectionType(String projectionType) {
            this.projectionType = projectionType;
        }

        public String getProjectionType() {
            return this.projectionType;
        }

        public ProjectionDataProperties getProjectionData() {
            return this.projectionData;
        }

        public void setProjectionData(ProjectionDataProperties projectionData) {
            this.projectionData = projectionData;
        }

        public void setExtraProperties(Map<String, Object> extraProperties) {
            this.extraProperties = extraProperties;
        }

        public Map<String, Object> getExtraProperties() {
            return this.extraProperties;
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        public boolean isVerbose() {
            return this.verbose;
        }
    }
}

