/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.actuate.endpoint.mvc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.mvc.EndpointMvcAdapter;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;
import org.springframework.web.util.UriComponents;
import org.springframework.yarn.am.cluster.ContainerCluster;
import org.springframework.yarn.am.grid.support.ProjectionData;
import org.springframework.yarn.boot.actuate.endpoint.YarnContainerClusterEndpoint;
import org.springframework.yarn.boot.actuate.endpoint.mvc.ContainerClusterCreateRequest;
import org.springframework.yarn.boot.actuate.endpoint.mvc.ContainerClusterModifyRequest;
import org.springframework.yarn.boot.actuate.endpoint.mvc.domain.ContainerClusterResource;
import org.springframework.yarn.boot.actuate.endpoint.mvc.domain.YarnContainerClusterEndpointResource;

public class YarnContainerClusterMvcEndpoint
extends EndpointMvcAdapter {
    private final YarnContainerClusterEndpoint delegate;

    public YarnContainerClusterMvcEndpoint(YarnContainerClusterEndpoint delegate) {
        super((Endpoint)delegate);
        this.delegate = delegate;
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public Object invoke() {
        Collection<ContainerCluster> clusters = this.delegate.getClusters().values();
        YarnContainerClusterEndpointResource response = new YarnContainerClusterEndpointResource();
        ArrayList<String> clusterIds = new ArrayList<String>();
        for (ContainerCluster cluster : clusters) {
            clusterIds.add(cluster.getId());
        }
        response.setClusters(clusterIds);
        return response;
    }

    @RequestMapping(method={RequestMethod.POST})
    public HttpEntity<Void> createCluster(@RequestBody ContainerClusterCreateRequest request) {
        ProjectionData projectionData = new ProjectionData();
        if (request.getProjectionData().getAny() != null) {
            projectionData.setAny(request.getProjectionData().getAny().intValue());
        }
        if (request.getProjectionData().getHosts() != null) {
            projectionData.setHosts(request.getProjectionData().getHosts());
        }
        if (request.getProjectionData().getRacks() != null) {
            projectionData.setRacks(request.getProjectionData().getRacks());
        }
        if (request.getProjectionData().getProperties() != null) {
            projectionData.setProperties(request.getProjectionData().getProperties());
        }
        if (request.getProjection() == null) {
            throw new InvalidInputException("Projection not defined");
        }
        projectionData.setType(request.getProjection().toString().toLowerCase());
        Map<String, Object> extraProperties = request.getExtraProperties();
        this.delegate.createCluster(request.getClusterId(), request.getClusterDef(), projectionData, extraProperties);
        HttpHeaders responseHeaders = new HttpHeaders();
        UriComponents uriComponents = MvcUriComponentsBuilder.fromMethodCall(((YarnContainerClusterMvcEndpoint)((Object)MvcUriComponentsBuilder.on(YarnContainerClusterMvcEndpoint.class))).clusterInfo(request.getClusterId())).build();
        responseHeaders.setLocation(uriComponents.toUri());
        return new ResponseEntity((MultiValueMap)responseHeaders, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/{clusterId}"}, method={RequestMethod.GET})
    public HttpEntity<ContainerClusterResource> clusterInfo(@PathVariable(value="clusterId") String clusterId) {
        ContainerCluster cluster = this.delegate.getClusters().get(clusterId);
        if (cluster == null) {
            throw new NoSuchClusterException("No such cluster: " + clusterId);
        }
        ContainerClusterResource response = new ContainerClusterResource(cluster);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @RequestMapping(value={"/{clusterId}"}, method={RequestMethod.PUT})
    public HttpEntity<Void> modifyCluster(@PathVariable(value="clusterId") String clusterId, @RequestBody ContainerClusterModifyRequest request) {
        ContainerClusterModifyRequest.ModifyAction action = ContainerClusterModifyRequest.getModifyAction(request.getAction());
        if (action == null) {
            throw new NoSuchActionException("Action " + request.getAction() + " not supported");
        }
        this.getClusterMayThrow(clusterId);
        if (ContainerClusterModifyRequest.ModifyAction.START.equals((Object)action)) {
            this.delegate.startCluster(clusterId);
        } else if (ContainerClusterModifyRequest.ModifyAction.STOP.equals((Object)action)) {
            this.delegate.stopCluster(clusterId);
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @RequestMapping(value={"/{clusterId}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> destroyCluster(@PathVariable(value="clusterId") String clusterId) {
        ContainerCluster cluster = this.getClusterMayThrow(clusterId);
        this.delegate.destroyCluster(cluster.getId());
        return new ResponseEntity(HttpStatus.OK);
    }

    @RequestMapping(value={"/{clusterId}"}, method={RequestMethod.PATCH})
    public HttpEntity<Void> updateCluster(@PathVariable(value="clusterId") String clusterId, @RequestBody ContainerClusterCreateRequest request) {
        ContainerCluster cluster = this.delegate.getClusters().get(clusterId);
        if (cluster == null) {
            throw new NoSuchClusterException("No such cluster: " + clusterId);
        }
        ProjectionData data = new ProjectionData();
        if (request.getProjectionData().getAny() != null) {
            data.setAny(request.getProjectionData().getAny().intValue());
        }
        if (request.getProjectionData().getHosts() != null) {
            data.setHosts(request.getProjectionData().getHosts());
        }
        if (request.getProjectionData().getRacks() != null) {
            data.setRacks(request.getProjectionData().getRacks());
        }
        this.delegate.modifyCluster(clusterId, data);
        return new ResponseEntity(HttpStatus.OK);
    }

    private ContainerCluster getClusterMayThrow(String clusterId) {
        ContainerCluster cluster = this.delegate.getClusters().get(clusterId);
        if (cluster == null) {
            throw new NoSuchClusterException("No such cluster: " + clusterId);
        }
        return cluster;
    }

    @ResponseStatus(value=HttpStatus.METHOD_NOT_ALLOWED, reason="Invalid input")
    private static class InvalidInputException
    extends RuntimeException {
        public InvalidInputException(String string) {
            super(string);
        }
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND, reason="No such action")
    private static class NoSuchActionException
    extends RuntimeException {
        public NoSuchActionException(String string) {
            super(string);
        }
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND, reason="No such cluster")
    private static class NoSuchClusterException
    extends RuntimeException {
        public NoSuchClusterException(String string) {
            super(string);
        }
    }
}

