/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.actuate.endpoint;

import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.yarn.am.YarnAppmaster;
import org.springframework.yarn.am.cluster.ContainerCluster;
import org.springframework.yarn.am.cluster.ContainerClusterAppmaster;
import org.springframework.yarn.am.grid.support.ProjectionData;

public class YarnContainerClusterEndpoint
extends AbstractEndpoint<Map<String, ContainerCluster>>
implements ApplicationContextAware {
    public static final String ENDPOINT_ID = "yarn_containercluster";
    private ApplicationContext applicationContext;

    public YarnContainerClusterEndpoint() {
        super(ENDPOINT_ID);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Map<String, ContainerCluster> invoke() {
        return this.getClusters();
    }

    public Map<String, ContainerCluster> getClusters() {
        return this.getAppmaster().getContainerClusters();
    }

    public ContainerCluster createCluster(String clusterId, String clusterDef, ProjectionData projectionData, Map<String, Object> extraProperties) {
        return this.getAppmaster().createContainerCluster(clusterId, clusterDef, projectionData, extraProperties);
    }

    public void startCluster(String clusterId) {
        this.getAppmaster().startContainerCluster(clusterId);
    }

    public void stopCluster(String clusterId) {
        this.getAppmaster().stopContainerCluster(clusterId);
    }

    public void destroyCluster(String clusterId) {
        this.getAppmaster().destroyContainerCluster(clusterId);
    }

    public void modifyCluster(String id, ProjectionData projectionData) {
        this.getAppmaster().modifyContainerCluster(id, projectionData);
    }

    private ContainerClusterAppmaster getAppmaster() {
        YarnAppmaster yarnAppmaster = (YarnAppmaster)this.applicationContext.getBean(YarnAppmaster.class, new Object[]{"yarnAppmaster"});
        if (yarnAppmaster instanceof ContainerClusterAppmaster) {
            return (ContainerClusterAppmaster)yarnAppmaster;
        }
        throw new InvalidAppmasterException("Appmaster of type ContainerClusterAppmaster not found");
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND, reason="Appmaster not found")
    private static class InvalidAppmasterException
    extends RuntimeException {
        public InvalidAppmasterException(String string) {
            super(string);
        }
    }
}

