/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot;

import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.StringUtils;
import org.springframework.yarn.am.AppmasterTrackService;
import org.springframework.yarn.am.YarnAppmaster;
import org.springframework.yarn.am.container.ContainerShutdown;
import org.springframework.yarn.am.grid.GridProjectionFactory;
import org.springframework.yarn.am.grid.GridProjectionFactoryLocator;
import org.springframework.yarn.am.grid.support.DefaultGridProjectionFactory;
import org.springframework.yarn.am.grid.support.GridProjectionFactoryRegistry;
import org.springframework.yarn.am.grid.support.ProjectionData;
import org.springframework.yarn.am.grid.support.ProjectionDataRegistry;
import org.springframework.yarn.batch.support.YarnJobLauncher;
import org.springframework.yarn.boot.actuate.endpoint.YarnContainerRegisterEndpoint;
import org.springframework.yarn.boot.actuate.endpoint.mvc.YarnContainerRegisterMvcEndpoint;
import org.springframework.yarn.boot.condition.ConditionalOnYarnAppmaster;
import org.springframework.yarn.boot.properties.SpringHadoopProperties;
import org.springframework.yarn.boot.properties.SpringYarnAppmasterLaunchContextProperties;
import org.springframework.yarn.boot.properties.SpringYarnAppmasterLocalizerProperties;
import org.springframework.yarn.boot.properties.SpringYarnAppmasterProperties;
import org.springframework.yarn.boot.properties.SpringYarnAppmasterResourceProperties;
import org.springframework.yarn.boot.properties.SpringYarnBatchProperties;
import org.springframework.yarn.boot.properties.SpringYarnEnvProperties;
import org.springframework.yarn.boot.properties.SpringYarnProperties;
import org.springframework.yarn.boot.support.AppmasterLauncherRunner;
import org.springframework.yarn.boot.support.BootApplicationEventTransformer;
import org.springframework.yarn.boot.support.BootLocalResourcesSelector;
import org.springframework.yarn.boot.support.BootMultiLocalResourcesSelector;
import org.springframework.yarn.boot.support.EmbeddedAppmasterTrackService;
import org.springframework.yarn.boot.support.EndpointContainerShutdown;
import org.springframework.yarn.boot.support.SpringYarnBootUtils;
import org.springframework.yarn.config.annotation.EnableYarn;
import org.springframework.yarn.config.annotation.SpringYarnConfigurerAdapter;
import org.springframework.yarn.config.annotation.builders.YarnAppmasterConfigurer;
import org.springframework.yarn.config.annotation.builders.YarnConfigConfigurer;
import org.springframework.yarn.config.annotation.builders.YarnEnvironmentConfigurer;
import org.springframework.yarn.config.annotation.builders.YarnResourceLocalizerConfigurer;
import org.springframework.yarn.config.annotation.configurers.LocalResourcesHdfsConfigurer;
import org.springframework.yarn.config.annotation.configurers.MasterContainerAllocatorConfigurer;
import org.springframework.yarn.fs.LocalResourcesSelector;
import org.springframework.yarn.fs.MultiLocalResourcesSelector;
import org.springframework.yarn.launch.LaunchCommandsFactoryBean;
import org.springframework.yarn.support.ParsingUtils;

@Configuration
@ConditionalOnYarnAppmaster
@ConditionalOnClass(value={EnableYarn.class})
@ConditionalOnMissingBean(value={YarnAppmaster.class})
public class YarnAppmasterAutoConfiguration {
    private static final Log log = LogFactory.getLog(YarnAppmasterAutoConfiguration.class);

    private static String explodedEntryIfZip(SpringYarnAppmasterLaunchContextProperties syalcp) {
        return StringUtils.endsWithIgnoreCase((String)syalcp.getArchiveFile(), (String)".zip") ? "./" + syalcp.getArchiveFile() : null;
    }

    private static String[] createContainerCommands(SpringYarnAppmasterLaunchContextProperties syalcp) throws Exception {
        LaunchCommandsFactoryBean factory = new LaunchCommandsFactoryBean();
        String containerJar = syalcp.getArchiveFile();
        if (StringUtils.hasText((String)containerJar) && containerJar.endsWith("jar")) {
            factory.setJarFile(containerJar);
        } else if (StringUtils.hasText((String)syalcp.getRunnerClass())) {
            factory.setRunnerClass(syalcp.getRunnerClass());
        } else if (StringUtils.hasText((String)containerJar) && containerJar.endsWith("zip")) {
            factory.setRunnerClass("org.springframework.boot.loader.PropertiesLauncher");
        }
        factory.setArgumentsList(syalcp.getArgumentsList());
        if (syalcp.getArguments() != null) {
            Properties arguments = new Properties();
            arguments.putAll(syalcp.getArguments());
            factory.setArguments(arguments);
        }
        factory.setOptions(syalcp.getOptions());
        factory.setStdout("<LOG_DIR>/Container.stdout");
        factory.setStderr("<LOG_DIR>/Container.stderr");
        factory.afterPropertiesSet();
        return factory.getObject();
    }

    @Configuration
    @EnableConfigurationProperties(value={SpringHadoopProperties.class, SpringYarnProperties.class, SpringYarnEnvProperties.class, SpringYarnAppmasterProperties.class, SpringYarnAppmasterLaunchContextProperties.class, SpringYarnAppmasterResourceProperties.class})
    @EnableYarn(enable=EnableYarn.Enable.APPMASTER)
    static class Config
    extends SpringYarnConfigurerAdapter {
        @Autowired
        private SpringYarnProperties syp;
        @Autowired
        private SpringHadoopProperties shp;
        @Autowired
        private SpringYarnAppmasterProperties syap;
        @Autowired
        private SpringYarnAppmasterLaunchContextProperties syalcp;
        @Autowired
        private SpringYarnAppmasterResourceProperties syarp;
        @Autowired(required=false)
        @Qualifier(value="customAppmasterClass")
        private String appmasterClass;
        @Autowired
        private LocalResourcesSelector localResourcesSelector;

        Config() {
        }

        public void configure(YarnConfigConfigurer config) throws Exception {
            log.info((Object)("Configuring fsUri=[" + this.shp.getFsUri() + "]"));
            log.info((Object)("Configuring rmAddress=[" + this.shp.getResourceManagerAddress() + "]"));
            ((YarnConfigConfigurer)((YarnConfigConfigurer)config.fileSystemUri(this.shp.getFsUri()).resourceManagerAddress(this.shp.getResourceManagerAddress()).schedulerAddress(this.shp.getResourceManagerSchedulerAddress()).withProperties().properties(this.shp.getConfig()).and()).withResources().resources(this.shp.getResources()).and()).withSecurity().namenodePrincipal(this.shp.getSecurity() != null ? this.shp.getSecurity().getNamenodePrincipal() : null).rmManagerPrincipal(this.shp.getSecurity() != null ? this.shp.getSecurity().getRmManagerPrincipal() : null).authMethod(this.shp.getSecurity() != null ? this.shp.getSecurity().getAuthMethod() : null);
        }

        public void configure(YarnResourceLocalizerConfigurer localizer) throws Exception {
            String applicationDir = SpringYarnBootUtils.resolveApplicationdir(this.syp);
            localizer.stagingDirectory(this.syp.getStagingDir());
            LocalResourcesHdfsConfigurer withHdfs = localizer.withHdfs();
            for (LocalResourcesSelector.Entry e : this.localResourcesSelector.select(applicationDir != null ? applicationDir : "/")) {
                withHdfs.hdfs(e.getPath(), e.getType(), applicationDir == null);
            }
            if (this.syap.getContainercluster() != null && this.localResourcesSelector instanceof MultiLocalResourcesSelector && this.syap.getContainercluster().getClusters() != null) {
                MultiLocalResourcesSelector selector = (MultiLocalResourcesSelector)this.localResourcesSelector;
                for (Map.Entry<String, SpringYarnAppmasterProperties.ContainerClustersProperties> entry : this.syap.getContainercluster().getClusters().entrySet()) {
                    withHdfs = localizer.withHdfs(entry.getKey());
                    for (LocalResourcesSelector.Entry e : selector.select(entry.getKey(), applicationDir != null ? applicationDir : "/")) {
                        withHdfs.hdfs(e.getPath(), e.getType(), applicationDir == null);
                    }
                }
            }
        }

        public void configure(YarnEnvironmentConfigurer environment) throws Exception {
            environment.includeLocalSystemEnv(this.syalcp.isIncludeLocalSystemEnv()).withClasspath().includeBaseDirectory(this.syalcp.isIncludeBaseDirectory()).useYarnAppClasspath(this.syalcp.isUseYarnAppClasspath()).useMapreduceAppClasspath(this.syalcp.isUseMapreduceAppClasspath()).siteYarnAppClasspath(this.syp.getSiteYarnAppClasspath()).siteMapreduceAppClasspath(this.syp.getSiteMapreduceAppClasspath()).delimiter(this.syalcp.getPathSeparator()).entries(this.syalcp.getContainerAppClasspath()).entry(YarnAppmasterAutoConfiguration.explodedEntryIfZip(this.syalcp));
            if (this.syap.getContainercluster() != null && this.syap.getContainercluster().getClusters() != null) {
                for (Map.Entry<String, SpringYarnAppmasterProperties.ContainerClustersProperties> entry : this.syap.getContainercluster().getClusters().entrySet()) {
                    SpringYarnAppmasterLaunchContextProperties props = entry.getValue().getLaunchcontext();
                    environment.withClasspath(entry.getKey()).includeBaseDirectory(props.isIncludeBaseDirectory()).useYarnAppClasspath(props.isUseYarnAppClasspath()).useMapreduceAppClasspath(props.isUseMapreduceAppClasspath()).siteYarnAppClasspath(this.syp.getSiteYarnAppClasspath()).siteMapreduceAppClasspath(this.syp.getSiteMapreduceAppClasspath()).delimiter(props.getPathSeparator()).entries(props.getContainerAppClasspath()).entry(YarnAppmasterAutoConfiguration.explodedEntryIfZip(props));
                }
            }
        }

        public void configure(YarnAppmasterConfigurer master) throws Exception {
            master.appmasterClass(this.syap.getAppmasterClass() != null ? this.syap.getAppmasterClass() : this.appmasterClass).containerCommands(YarnAppmasterAutoConfiguration.createContainerCommands(this.syalcp));
            MasterContainerAllocatorConfigurer containerAllocatorConfigurer = master.withContainerAllocator();
            containerAllocatorConfigurer.locality(this.syalcp.isLocality()).memory(this.syarp.getMemory()).priority(this.syarp.getPriority()).virtualCores(this.syarp.getVirtualCores());
            if (this.syap.getContainercluster() != null && this.syap.getContainercluster().getClusters() != null) {
                for (Map.Entry<String, SpringYarnAppmasterProperties.ContainerClustersProperties> entry : this.syap.getContainercluster().getClusters().entrySet()) {
                    SpringYarnAppmasterResourceProperties resource = entry.getValue().getResource();
                    SpringYarnAppmasterLaunchContextProperties launchcontext = entry.getValue().getLaunchcontext();
                    master.containerCommands(entry.getKey(), YarnAppmasterAutoConfiguration.createContainerCommands(launchcontext));
                    containerAllocatorConfigurer.withCollection(entry.getKey()).priority(resource != null ? resource.getPriority() : null).memory(resource != null ? resource.getMemory() : null).virtualCores(resource != null ? resource.getVirtualCores() : null).locality(launchcontext != null ? launchcontext.isLocality() : false);
                }
            }
        }
    }

    @Configuration
    @ConditionalOnExpression(value="${spring.yarn.endpoints.containerregister.enabled:false}")
    public static class ContainerRegisterEndPointConfig {
        @Bean
        @ConditionalOnMissingBean
        public YarnContainerRegisterEndpoint yarnContainerRegisterEndpoint() {
            return new YarnContainerRegisterEndpoint();
        }

        @Bean
        @ConditionalOnBean(value={YarnContainerRegisterEndpoint.class})
        public YarnContainerRegisterMvcEndpoint yarnContainerRegisterMvcEndpoint(YarnContainerRegisterEndpoint delegate) {
            return new YarnContainerRegisterMvcEndpoint(delegate);
        }

        @ConditionalOnExpression(value="${endpoints.shutdown.enabled:false}")
        @Bean(name={"yarnContainerShutdown"})
        public ContainerShutdown containerShutdown() {
            return new EndpointContainerShutdown();
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={SpringYarnAppmasterProperties.class})
    @ConditionalOnExpression(value="${spring.yarn.appmaster.containercluster.enabled:false}")
    public static class ContainerClusterConfig {
        @Autowired
        private SpringYarnAppmasterProperties syap;
        @Autowired(required=false)
        private List<GridProjectionFactory> gridProjectionFactories;

        @Bean
        public GridProjectionFactoryLocator gridProjectionFactoryLocator() {
            GridProjectionFactoryRegistry registry = new GridProjectionFactoryRegistry();
            if (this.gridProjectionFactories != null) {
                for (GridProjectionFactory factory : this.gridProjectionFactories) {
                    registry.addGridProjectionFactory(factory);
                }
            }
            return registry;
        }

        @Bean
        public ProjectionDataRegistry projectionDataRegistry() {
            HashMap<String, ProjectionData> projections = new HashMap<String, ProjectionData>();
            Map<String, SpringYarnAppmasterProperties.ContainerClustersProperties> clusterProps = this.syap.getContainercluster().getClusters();
            if (clusterProps != null) {
                for (Map.Entry<String, SpringYarnAppmasterProperties.ContainerClustersProperties> entry : clusterProps.entrySet()) {
                    SpringYarnAppmasterLaunchContextProperties launchcontext;
                    SpringYarnAppmasterResourceProperties resource;
                    ProjectionData data = new ProjectionData();
                    SpringYarnAppmasterProperties.ContainerClustersProjectionProperties ccpProperties = entry.getValue().getProjection();
                    if (ccpProperties != null) {
                        SpringYarnAppmasterProperties.ContainerClustersProjectionDataProperties ccpdProperties = ccpProperties.getData();
                        if (ccpdProperties != null) {
                            data.setAny(ccpdProperties.getAny().intValue());
                            data.setHosts(ccpdProperties.getHosts());
                            data.setRacks(ccpdProperties.getRacks());
                            data.setProperties(ccpdProperties.getProperties());
                        }
                        data.setType(ccpProperties.getType());
                    }
                    if ((resource = entry.getValue().getResource()) != null) {
                        data.setPriority(resource.getPriority());
                        data.setVirtualCores(resource.getVirtualCores());
                        try {
                            data.setMemory(Integer.valueOf(ParsingUtils.parseBytesAsMegs((String)resource.getMemory())));
                        }
                        catch (ParseException e) {
                            // empty catch block
                        }
                    }
                    if ((launchcontext = entry.getValue().getLaunchcontext()) != null) {
                        data.setLocality(Boolean.valueOf(launchcontext.isLocality()));
                    }
                    projections.put(entry.getKey(), data);
                }
            }
            return new ProjectionDataRegistry(projections);
        }
    }

    @Configuration
    @ConditionalOnExpression(value="${spring.yarn.appmaster.containercluster.enabled:false}")
    public static class ContainerClusterFactoryConfig {
        @Bean
        @ConditionalOnMissingBean(name={"defaultGridProjectionFactory"})
        public GridProjectionFactory defaultGridProjectionFactory() {
            return new DefaultGridProjectionFactory();
        }
    }

    @Configuration
    @ConditionalOnClass(value={JobLauncher.class})
    @ConditionalOnExpression(value="${spring.yarn.batch.enabled:false}")
    @EnableConfigurationProperties(value={SpringYarnBatchProperties.class})
    public static class RuntimeConfig {
        @Value(value="${spring.yarn.batch.name:}")
        private String jobName;

        @Bean(name={"taskExecutor"})
        public TaskExecutor threadPoolTaskExecutor() {
            ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
            executor.setCorePoolSize(2);
            return executor;
        }

        @Bean
        public String customAppmasterClass() {
            return "org.springframework.yarn.batch.am.BatchAppmaster";
        }

        @Bean
        public BootApplicationEventTransformer bootApplicationEventTransformer() {
            return new BootApplicationEventTransformer();
        }

        @Bean
        @ConditionalOnMissingBean(value={YarnJobLauncher.class})
        @ConditionalOnBean(value={JobLauncher.class})
        public YarnJobLauncher yarnJobLauncher() {
            YarnJobLauncher launcher = new YarnJobLauncher();
            if (StringUtils.hasText((String)this.jobName)) {
                launcher.setJobName(this.jobName);
            }
            return launcher;
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={SpringYarnAppmasterProperties.class})
    public static class RunnerConfig {
        @Autowired
        private SpringYarnAppmasterProperties syap;

        @Bean
        @ConditionalOnMissingBean(value={AppmasterLauncherRunner.class})
        @ConditionalOnBean(value={YarnAppmaster.class})
        public AppmasterLauncherRunner appmasterLauncherRunner() {
            AppmasterLauncherRunner runner = new AppmasterLauncherRunner();
            runner.setWaitLatch(this.syap.isKeepContextAlive());
            runner.setContainerCount(this.syap.getContainerCount());
            return runner;
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={SpringYarnAppmasterProperties.class, SpringYarnAppmasterLocalizerProperties.class})
    public static class LocalResourcesSelectorConfig {
        @Autowired
        private SpringYarnAppmasterProperties syap;
        @Autowired
        private SpringYarnAppmasterLocalizerProperties syalp;

        @Bean
        @ConditionalOnMissingBean(value={LocalResourcesSelector.class})
        public LocalResourcesSelector localResourcesSelector() {
            HashMap<String, LocalResourcesSelector> selectors = new HashMap<String, LocalResourcesSelector>();
            if (this.syap.getContainercluster() != null && this.syap.getContainercluster().getClusters() != null) {
                for (Map.Entry<String, SpringYarnAppmasterProperties.ContainerClustersProperties> entry : this.syap.getContainercluster().getClusters().entrySet()) {
                    SpringYarnAppmasterLocalizerProperties props = entry.getValue().getLocalizer();
                    if (props == null) continue;
                    BootLocalResourcesSelector selector = new BootLocalResourcesSelector(BootLocalResourcesSelector.Mode.CONTAINER);
                    if (StringUtils.hasText((String)props.getZipPattern())) {
                        selector.setZipArchivePattern(props.getZipPattern());
                    }
                    if (props.getPropertiesNames() != null) {
                        selector.setPropertiesNames(props.getPropertiesNames());
                    }
                    if (props.getPropertiesSuffixes() != null) {
                        selector.setPropertiesSuffixes(props.getPropertiesSuffixes());
                    }
                    selector.addPatterns(props.getPatterns());
                    selectors.put(entry.getKey(), (LocalResourcesSelector)selector);
                }
            }
            BootLocalResourcesSelector selector = new BootLocalResourcesSelector(BootLocalResourcesSelector.Mode.CONTAINER);
            if (StringUtils.hasText((String)this.syalp.getZipPattern())) {
                selector.setZipArchivePattern(this.syalp.getZipPattern());
            }
            if (this.syalp.getPropertiesNames() != null) {
                selector.setPropertiesNames(this.syalp.getPropertiesNames());
            }
            if (this.syalp.getPropertiesSuffixes() != null) {
                selector.setPropertiesSuffixes(this.syalp.getPropertiesSuffixes());
            }
            selector.addPatterns(this.syalp.getPatterns());
            return new BootMultiLocalResourcesSelector((LocalResourcesSelector)selector, selectors);
        }
    }

    @Configuration
    @ConditionalOnWebApplication
    public static class TrackServiceConfig {
        @Bean(name={"yarnAmTrackservice"})
        @ConditionalOnMissingBean(value={AppmasterTrackService.class})
        public AppmasterTrackService appmasterTrackService() {
            return new EmbeddedAppmasterTrackService();
        }
    }
}

