/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.cli;

import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.yarn.boot.app.ClientApplicationRunner;
import org.springframework.yarn.boot.app.YarnSubmitApplication;
import org.springframework.yarn.boot.cli.AbstractApplicationCommand;
import org.springframework.yarn.boot.cli.CliSystemConstants;

public class YarnSubmitCommand
extends AbstractApplicationCommand {
    public static final String DEFAULT_COMMAND = "submit";
    public static final String DEFAULT_DESC = "Submit application";

    public YarnSubmitCommand() {
        super(DEFAULT_COMMAND, DEFAULT_DESC, new SubmitOptionHandler());
    }

    public YarnSubmitCommand(SubmitOptionHandler handler) {
        super(DEFAULT_COMMAND, DEFAULT_DESC, handler);
    }

    public YarnSubmitCommand(String name, String description, SubmitOptionHandler handler) {
        super(name, description, handler);
    }

    public static class SubmitOptionHandler
    extends AbstractApplicationCommand.ApplicationOptionHandler<ApplicationId> {
        private OptionSpec<String> applicationVersionOption;
        private OptionSpec<String> applicationNameOption;

        protected final void options() {
            this.applicationVersionOption = this.option(CliSystemConstants.OPTIONS_APPLICATION_VERSION, "Application version").withOptionalArg().defaultsTo((Object)"app", (Object[])new String[0]);
            this.applicationNameOption = this.option(CliSystemConstants.OPTIONS_APPLICATION_NAME, "Application name").withOptionalArg();
        }

        @Override
        protected void runApplication(OptionSet options) throws Exception {
            String appVersion = (String)options.valueOf(this.applicationVersionOption);
            String appName = (String)options.valueOf(this.applicationNameOption);
            Assert.hasText((String)appVersion, (String)"Application version must be defined");
            YarnSubmitApplication app = new YarnSubmitApplication();
            if (StringUtils.hasText((String)appName)) {
                app.applicationName(appName);
            }
            app.applicationVersion(appVersion);
            this.handleApplicationRun((ClientApplicationRunner<ApplicationId>)app);
        }

        @Override
        protected void handleApplicationRun(ClientApplicationRunner<ApplicationId> app) {
            ApplicationId applicationId = (ApplicationId)app.run();
            this.handleOutput("New instance submitted with id " + applicationId);
        }

        public OptionSpec<String> getApplicationVersionOption() {
            return this.applicationVersionOption;
        }

        public OptionSpec<String> getApplicationNameOption() {
            return this.applicationNameOption;
        }
    }
}

