/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.cli;

import java.util.Map;
import java.util.Properties;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.yarn.boot.app.YarnContainerClusterApplication;
import org.springframework.yarn.boot.cli.AbstractApplicationCommand;
import org.springframework.yarn.boot.cli.CliSystemConstants;

public class YarnClusterCreateCommand
extends AbstractApplicationCommand {
    public static final String DEFAULT_COMMAND = "clustercreate";
    public static final String DEFAULT_DESC = "Create cluster";

    public YarnClusterCreateCommand() {
        super(DEFAULT_COMMAND, DEFAULT_DESC, new ClusterCreateOptionHandler());
    }

    public YarnClusterCreateCommand(ClusterCreateOptionHandler handler) {
        super(DEFAULT_COMMAND, DEFAULT_DESC, handler);
    }

    public YarnClusterCreateCommand(String name, String description, ClusterCreateOptionHandler handler) {
        super(name, description, handler);
    }

    public static class ClusterCreateOptionHandler
    extends AbstractApplicationCommand.ApplicationOptionHandler<String> {
        private static final String PREFIX = "spring.yarn.internal.ContainerClusterApplication";
        private OptionSpec<String> applicationIdOption;
        private OptionSpec<String> clusterIdOption;
        private OptionSpec<String> clusterDefOption;
        private OptionSpec<String> projectionTypeOption;
        private OptionSpec<String> projectionDataAnyOption;
        private OptionSpec<String> projectionDataHostsOption;
        private OptionSpec<String> projectionDataRacksOption;
        private OptionSpec<String> projectionDataRawOption;

        protected void options() {
            this.applicationIdOption = this.option(CliSystemConstants.OPTIONS_APPLICATION_ID, "Specify YARN application id").withRequiredArg();
            this.clusterIdOption = this.option(CliSystemConstants.OPTIONS_CLUSTER_ID, "Specify cluster id").withRequiredArg();
            this.clusterDefOption = this.option(CliSystemConstants.OPTIONS_CLUSTER_DEF, "Specify cluster def id").withOptionalArg();
            this.projectionTypeOption = this.option(CliSystemConstants.OPTIONS_PROJECTION_TYPE, "Projection type").withRequiredArg();
            this.projectionDataAnyOption = this.option(CliSystemConstants.OPTIONS_PROJECTION_ANY, "Projection any count").withRequiredArg();
            this.projectionDataHostsOption = this.option(CliSystemConstants.OPTIONS_PROJECTION_HOSTS, "Projection hosts counts").withOptionalArg();
            this.projectionDataRacksOption = this.option(CliSystemConstants.OPTIONS_PROJECTION_RACKS, "Projection racks counts").withOptionalArg();
            this.projectionDataRawOption = this.option(CliSystemConstants.OPTIONS_PROJECTION_DATA, "Raw projection data").withOptionalArg();
        }

        @Override
        protected void verifyOptionSet(OptionSet options) throws Exception {
            String appId = (String)options.valueOf(this.applicationIdOption);
            String clusterId = (String)options.valueOf(this.clusterIdOption);
            Assert.state((StringUtils.hasText((String)appId) && StringUtils.hasText((String)clusterId) ? 1 : 0) != 0, (String)"Cluster Id and Application Id must be defined");
        }

        @Override
        protected void runApplication(OptionSet options) throws Exception {
            Properties extraProperties;
            String appId = (String)options.valueOf(this.applicationIdOption);
            String clusterId = (String)options.valueOf(this.clusterIdOption);
            String clusterDef = (String)options.valueOf(this.clusterDefOption);
            String projectionType = (String)options.valueOf(this.projectionTypeOption);
            String projectionAny = (String)options.valueOf(this.projectionDataAnyOption);
            String projectionHosts = (String)options.valueOf(this.projectionDataHostsOption);
            String projectionRacks = (String)options.valueOf(this.projectionDataRacksOption);
            String projectionRaw = (String)options.valueOf(this.projectionDataRawOption);
            YarnContainerClusterApplication app = new YarnContainerClusterApplication();
            Properties appProperties = new Properties();
            appProperties.setProperty("spring.yarn.internal.ContainerClusterApplication.operation", "CLUSTERCREATE");
            appProperties.setProperty("spring.yarn.internal.ContainerClusterApplication.applicationId", appId);
            appProperties.setProperty("spring.yarn.internal.ContainerClusterApplication.clusterId", clusterId);
            if (clusterDef != null) {
                appProperties.setProperty("spring.yarn.internal.ContainerClusterApplication.clusterDef", clusterDef);
            }
            if (projectionType != null) {
                appProperties.setProperty("spring.yarn.internal.ContainerClusterApplication.projectionType", projectionType);
            }
            if (StringUtils.hasText((String)projectionAny)) {
                appProperties.setProperty("spring.yarn.internal.ContainerClusterApplication.projectionData.any", projectionAny);
            }
            if (StringUtils.hasText((String)projectionHosts)) {
                for (Map.Entry<Object, Object> entry : ClusterCreateOptionHandler.getPropertiesFromRawYaml(projectionHosts).entrySet()) {
                    appProperties.setProperty("spring.yarn.internal.ContainerClusterApplication.projectionData.hosts." + entry.getKey(), entry.getValue().toString());
                }
            }
            if (StringUtils.hasText((String)projectionRacks)) {
                for (Map.Entry<Object, Object> entry : ClusterCreateOptionHandler.getPropertiesFromRawYaml(projectionRacks).entrySet()) {
                    appProperties.setProperty("spring.yarn.internal.ContainerClusterApplication.projectionData.racks." + entry.getKey(), entry.getValue().toString());
                }
            }
            if (StringUtils.hasText((String)projectionRaw)) {
                for (Map.Entry<Object, Object> entry : ClusterCreateOptionHandler.getPropertiesFromRawYaml(projectionRaw).entrySet()) {
                    appProperties.setProperty("spring.yarn.internal.ContainerClusterApplication.projectionData." + entry.getKey(), entry.getValue().toString());
                }
            }
            if ((extraProperties = this.getExtraProperties(options)) != null) {
                for (String key : extraProperties.stringPropertyNames()) {
                    appProperties.setProperty("spring.yarn.internal.ContainerClusterApplication.extraProperties." + key, extraProperties.getProperty(key));
                }
            }
            app.appProperties(appProperties);
            this.handleApplicationRun(app);
        }

        public OptionSpec<String> getApplicationIdOption() {
            return this.applicationIdOption;
        }

        public OptionSpec<String> getClusterIdOption() {
            return this.clusterIdOption;
        }

        public OptionSpec<String> getClusterDefOption() {
            return this.clusterDefOption;
        }

        public OptionSpec<String> getProjectionTypeOption() {
            return this.projectionTypeOption;
        }

        public OptionSpec<String> getProjectionDataAnyOption() {
            return this.projectionDataAnyOption;
        }

        public OptionSpec<String> getProjectionDataHostsOption() {
            return this.projectionDataHostsOption;
        }

        public OptionSpec<String> getProjectionDataRacksOption() {
            return this.projectionDataRacksOption;
        }

        protected Properties getExtraProperties(OptionSet options) {
            return null;
        }

        private static Properties getPropertiesFromRawYaml(String raw) {
            if (StringUtils.isEmpty((Object)raw)) {
                return new Properties();
            }
            ByteArrayResource resource = new ByteArrayResource(raw.getBytes());
            YamlPropertiesFactoryBean ypfb = new YamlPropertiesFactoryBean();
            ypfb.setResources(new Resource[]{resource});
            ypfb.afterPropertiesSet();
            return ypfb.getObject();
        }
    }
}

