/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.batch.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobExecutionNotFailedException;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.JobParametersNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.stereotype.Component;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;
import org.springframework.yarn.batch.event.JobExecutionEvent;
import org.springframework.yarn.batch.support.YarnBatchProperties;

@Component
public class YarnJobLauncher
implements ApplicationEventPublisherAware {
    private static final Log log = LogFactory.getLog(YarnJobLauncher.class);
    private JobParametersConverter converter = new DefaultJobParametersConverter();
    private JobLauncher jobLauncher;
    private JobRegistry jobRegistry;
    private JobExplorer jobExplorer;
    private YarnBatchProperties yarnBatchProperties;
    private Collection<Job> jobs = Collections.emptySet();
    private String jobName;
    private ApplicationEventPublisher publisher;

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public void run(String ... args) throws JobExecutionException {
        log.info((Object)("Running default command line with: " + Arrays.asList(args)));
        this.launchJobFromProperties(StringUtils.splitArrayElementsIntoProperties((String[])args, (String)"="));
    }

    public void run(Properties properties) throws JobExecutionException {
        this.launchJobFromProperties(properties);
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobName() {
        return this.jobName;
    }

    @Autowired
    public void setJobLauncher(JobLauncher jobLauncher) {
        this.jobLauncher = jobLauncher;
    }

    public JobLauncher getJobLauncher() {
        return this.jobLauncher;
    }

    @Autowired(required=false)
    public void setJobRegistry(JobRegistry jobRegistry) {
        this.jobRegistry = jobRegistry;
    }

    public JobRegistry getJobRegistry() {
        return this.jobRegistry;
    }

    @Autowired(required=false)
    public void setJobParametersConverter(JobParametersConverter converter) {
        this.converter = converter;
    }

    @Autowired(required=false)
    public void setJobExplorer(JobExplorer jobExplorer) {
        this.jobExplorer = jobExplorer;
    }

    public JobExplorer getJobExplorer() {
        return this.jobExplorer;
    }

    @Autowired(required=false)
    public void setJobs(Collection<Job> jobs) {
        this.jobs = jobs;
    }

    public Collection<Job> getJobs() {
        return this.jobs;
    }

    @Autowired(required=false)
    public void setYarnBatchProperties(YarnBatchProperties yarnBatchProperties) {
        this.yarnBatchProperties = yarnBatchProperties;
    }

    protected void launchJobFromProperties(Properties properties) throws JobExecutionException {
        JobParameters jobParameters = this.converter.getJobParameters(properties);
        this.executeRegisteredJobs(jobParameters);
        this.executeLocalJobs(jobParameters);
    }

    private void executeRegisteredJobs(JobParameters jobParameters) throws JobExecutionException {
        if (this.jobRegistry == null) {
            log.info((Object)"No jobRegistry defined, skipping registered jobs");
        }
        if (this.jobRegistry != null && StringUtils.hasText((String)this.jobName)) {
            for (String name : this.jobRegistry.getJobNames()) {
                if (StringUtils.hasText((String)this.jobName) && YarnJobLauncher.jobMatches(this.jobName, name)) {
                    Job job = this.jobRegistry.getJob(name);
                    this.executeJob(job, jobParameters);
                    continue;
                }
                log.debug((Object)("Skipped registered job: " + name));
            }
        }
    }

    private void executeLocalJobs(JobParameters jobParameters) throws JobExecutionException {
        if (this.jobs.size() == 0) {
            log.info((Object)"No local jobs defined");
        }
        for (Job job : this.jobs) {
            if (StringUtils.hasText((String)this.jobName) && YarnJobLauncher.jobMatches(this.jobName, job.getName())) {
                log.debug((Object)("Executing local job: " + job.getName()));
                this.executeJob(job, jobParameters);
                continue;
            }
            log.debug((Object)("Skipped local job: " + job.getName()));
        }
    }

    private static boolean jobMatches(String patterns, String name) {
        for (String pattern : StringUtils.commaDelimitedListToStringArray((String)patterns)) {
            if (!PatternMatchUtils.simpleMatch((String)pattern, (String)name)) continue;
            return true;
        }
        return false;
    }

    protected void executeJob(Job job, JobParameters jobParameters) throws JobExecutionException {
        String jobIdentifier = job.getName();
        YarnBatchProperties.JobProperties jobProperties = this.yarnBatchProperties != null ? this.yarnBatchProperties.getJobProperties(jobIdentifier) : null;
        boolean restart = false;
        if (jobProperties != null && jobProperties.getParameters() != null) {
            log.info((Object)("Job parameters from boot properties, parameters" + jobProperties.getParameters()));
            Properties tmpProperties = new Properties();
            Map<String, Object> tmpParameters = jobProperties.getParameters();
            tmpProperties.putAll(tmpParameters);
            JobParameters tmpJobParameters = this.converter.getJobParameters(tmpProperties);
            HashMap map1 = new HashMap(tmpJobParameters.getParameters());
            map1.putAll(jobParameters.getParameters());
            jobParameters = new JobParameters(map1);
            log.info((Object)("Modified jobParameters=" + jobParameters));
        }
        if (jobProperties != null && jobProperties.isRestart()) {
            if (this.jobExplorer == null) {
                throw new JobExecutionException("A JobExplorer must be provided for a restart or start next operation.");
            }
            JobExecution jobExecution = this.getLastFailedJobExecution(jobIdentifier);
            if (log.isDebugEnabled()) {
                log.info((Object)("Last failed JobExecution: " + jobExecution));
            }
            if (jobExecution == null && jobProperties.isFailRestart()) {
                throw new JobExecutionNotFailedException("No failed or stopped execution found for job=" + jobIdentifier);
            }
            log.info((Object)("No failed or stopped execution found for job=" + jobIdentifier + ", batch properties flag for failRestart=" + jobProperties.isFailRestart() + " so we don't fail restart."));
            if (jobExecution != null) {
                restart = true;
                jobParameters = jobExecution.getJobParameters();
            }
        }
        if (jobProperties != null && jobProperties.isNext() && !restart) {
            if (this.jobExplorer == null) {
                throw new JobExecutionException("A JobExplorer must be provided for a restart or start next operation.");
            }
            JobParameters nextParameters = this.getNextJobParameters(job, false);
            HashMap map = new HashMap(nextParameters.getParameters());
            map.putAll(jobParameters.getParameters());
            jobParameters = new JobParameters(map);
            if (log.isDebugEnabled()) {
                log.info((Object)("JobParameter for job=[" + job + "] next=" + nextParameters + " used=" + jobParameters));
            }
        }
        JobExecution execution = this.jobLauncher.run(job, jobParameters);
        if (this.publisher != null) {
            this.publisher.publishEvent((ApplicationEvent)new JobExecutionEvent(this, execution));
        }
    }

    private JobParameters getNextJobParameters(Job job, boolean fail) throws JobParametersNotFoundException {
        JobParameters jobParameters;
        String jobIdentifier = job.getName();
        List lastInstances = this.jobExplorer.getJobInstances(jobIdentifier, 0, 1);
        JobParametersIncrementer incrementer = job.getJobParametersIncrementer();
        if (incrementer == null) {
            throw new JobParametersNotFoundException("No job parameters incrementer found for job=" + jobIdentifier);
        }
        if (lastInstances.isEmpty()) {
            jobParameters = incrementer.getNext(new JobParameters());
            if (jobParameters == null) {
                throw new JobParametersNotFoundException("No bootstrap parameters found from incrementer for job=" + jobIdentifier);
            }
        } else {
            List lastExecutions = this.jobExplorer.getJobExecutions((JobInstance)lastInstances.get(0));
            jobParameters = incrementer.getNext(((JobExecution)lastExecutions.get(0)).getJobParameters());
        }
        return jobParameters;
    }

    private JobExecution getLastFailedJobExecution(String jobIdentifier) {
        List<JobExecution> jobExecutions = this.getJobExecutionsWithStatusGreaterThan(jobIdentifier);
        if (jobExecutions.isEmpty()) {
            return null;
        }
        if (!jobExecutions.get(0).getStatus().isUnsuccessful()) {
            return null;
        }
        return jobExecutions.get(0);
    }

    private List<JobExecution> getJobExecutionsWithStatusGreaterThan(String jobIdentifier) {
        int start = 0;
        int count = 100;
        ArrayList<JobExecution> executions = new ArrayList<JobExecution>();
        List lastInstances = this.jobExplorer.getJobInstances(jobIdentifier, start, count);
        while (!lastInstances.isEmpty()) {
            for (JobInstance jobInstance : lastInstances) {
                List jobExecutions = this.jobExplorer.getJobExecutions(jobInstance);
                if (jobExecutions == null || jobExecutions.isEmpty()) continue;
                for (JobExecution jobExecution : jobExecutions) {
                    executions.add(jobExecution);
                }
            }
            lastInstances = this.jobExplorer.getJobInstances(jobIdentifier, start += count, count);
        }
        return executions;
    }
}

