/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.batch.repository;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.yarn.batch.repository.AbstractRemoteDao;
import org.springframework.yarn.batch.repository.JobRepositoryRpcFactory;
import org.springframework.yarn.batch.repository.bindings.JobExecutionType;
import org.springframework.yarn.batch.repository.bindings.JobInstanceType;
import org.springframework.yarn.batch.repository.bindings.exp.FindJobInstancesByJobNameReq;
import org.springframework.yarn.batch.repository.bindings.exp.FindJobInstancesByJobNameRes;
import org.springframework.yarn.batch.repository.bindings.exp.FindRunningJobExecutionsReq;
import org.springframework.yarn.batch.repository.bindings.exp.FindRunningJobExecutionsRes;
import org.springframework.yarn.batch.repository.bindings.exp.GetJobExecutionReq;
import org.springframework.yarn.batch.repository.bindings.exp.GetJobExecutionRes;
import org.springframework.yarn.batch.repository.bindings.exp.GetJobExecutionsReq;
import org.springframework.yarn.batch.repository.bindings.exp.GetJobExecutionsRes;
import org.springframework.yarn.batch.repository.bindings.exp.GetJobInstanceCountReq;
import org.springframework.yarn.batch.repository.bindings.exp.GetJobInstanceCountRes;
import org.springframework.yarn.batch.repository.bindings.exp.GetJobInstanceReq;
import org.springframework.yarn.batch.repository.bindings.exp.GetJobInstanceRes;
import org.springframework.yarn.batch.repository.bindings.exp.GetJobInstancesReq;
import org.springframework.yarn.batch.repository.bindings.exp.GetJobInstancesRes;
import org.springframework.yarn.batch.repository.bindings.exp.GetJobNamesReq;
import org.springframework.yarn.batch.repository.bindings.exp.GetJobNamesRes;
import org.springframework.yarn.batch.repository.bindings.exp.GetStepExecutionReq;
import org.springframework.yarn.batch.repository.bindings.exp.GetStepExecutionRes;
import org.springframework.yarn.integration.ip.mind.AppmasterMindScOperations;
import org.springframework.yarn.integration.ip.mind.binding.BaseObject;

public class RemoteJobExplorer
extends AbstractRemoteDao
implements JobExplorer {
    public RemoteJobExplorer() {
    }

    public RemoteJobExplorer(AppmasterMindScOperations appmasterScOperations) {
        super(appmasterScOperations);
    }

    public List<JobInstance> getJobInstances(String jobName, int start, int count) {
        ArrayList<JobInstance> jobInstances = new ArrayList<JobInstance>();
        try {
            GetJobInstancesReq request = JobRepositoryRpcFactory.buildGetJobInstancesReq(jobName, start, count);
            GetJobInstancesRes response = (GetJobInstancesRes)this.getAppmasterScOperations().doMindRequest((BaseObject)request);
            for (JobInstanceType j : response.jobInstances) {
                jobInstances.add(JobRepositoryRpcFactory.convertJobInstanceType(j));
            }
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
        return jobInstances;
    }

    public JobExecution getJobExecution(Long executionId) {
        GetJobExecutionReq request = JobRepositoryRpcFactory.buildGetJobExecutionReq(executionId);
        GetJobExecutionRes response = (GetJobExecutionRes)this.getAppmasterScOperations().doMindRequest((BaseObject)request);
        return JobRepositoryRpcFactory.convertJobExecutionType(response.jobExecution);
    }

    public StepExecution getStepExecution(Long jobExecutionId, Long stepExecutionId) {
        GetStepExecutionReq request = JobRepositoryRpcFactory.buildGetStepExecutionReq(jobExecutionId, stepExecutionId);
        GetStepExecutionRes response = (GetStepExecutionRes)this.getAppmasterScOperations().doMindRequest((BaseObject)request);
        return JobRepositoryRpcFactory.convertStepExecutionType(response.stepExecution);
    }

    public JobInstance getJobInstance(Long instanceId) {
        JobInstance jobInstance = null;
        try {
            GetJobInstanceReq request = JobRepositoryRpcFactory.buildGetJobInstanceReq(instanceId);
            GetJobInstanceRes response = (GetJobInstanceRes)this.getAppmasterScOperations().doMindRequest((BaseObject)request);
            jobInstance = JobRepositoryRpcFactory.convertJobInstanceType(response.jobInstance);
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
        return jobInstance;
    }

    public List<JobExecution> getJobExecutions(JobInstance jobInstance) {
        ArrayList<JobExecution> jobExecutions = new ArrayList<JobExecution>();
        GetJobExecutionsReq request = JobRepositoryRpcFactory.buildGetJobExecutionsReq(jobInstance);
        GetJobExecutionsRes response = (GetJobExecutionsRes)this.getAppmasterScOperations().doMindRequest((BaseObject)request);
        for (JobExecutionType j : response.jobExecutions) {
            jobExecutions.add(JobRepositoryRpcFactory.convertJobExecutionType(j));
        }
        return jobExecutions;
    }

    public Set<JobExecution> findRunningJobExecutions(String jobName) {
        FindRunningJobExecutionsReq request = JobRepositoryRpcFactory.buildFindRunningJobExecutionsReq(jobName);
        HashSet<JobExecution> jobExecutions = new HashSet<JobExecution>();
        FindRunningJobExecutionsRes response = (FindRunningJobExecutionsRes)this.getAppmasterScOperations().doMindRequest((BaseObject)request);
        for (JobExecutionType j : response.jobExecutions) {
            jobExecutions.add(JobRepositoryRpcFactory.convertJobExecutionType(j));
        }
        return jobExecutions;
    }

    public List<String> getJobNames() {
        GetJobNamesReq request = JobRepositoryRpcFactory.buildGetJobNamesReq();
        GetJobNamesRes response = (GetJobNamesRes)this.getAppmasterScOperations().doMindRequest((BaseObject)request);
        return response.jobNames;
    }

    public int getJobInstanceCount(String jobName) throws NoSuchJobException {
        GetJobInstanceCountReq request = JobRepositoryRpcFactory.buildGetJobInstanceCountReq(jobName);
        GetJobInstanceCountRes response = (GetJobInstanceCountRes)this.getAppmasterScOperations().doMindRequest((BaseObject)request);
        if (response.count != null) {
            return response.count;
        }
        return 0;
    }

    public List<JobInstance> findJobInstancesByJobName(String jobName, int start, int count) {
        ArrayList<JobInstance> jobInstances = new ArrayList<JobInstance>();
        try {
            FindJobInstancesByJobNameReq request = JobRepositoryRpcFactory.buildFindJobInstancesByJobNameReq(jobName, start, count);
            FindJobInstancesByJobNameRes response = (FindJobInstancesByJobNameRes)this.getAppmasterScOperations().doMindRequest((BaseObject)request);
            for (JobInstanceType j : response.jobInstances) {
                jobInstances.add(JobRepositoryRpcFactory.convertJobInstanceType(j));
            }
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
        return jobInstances;
    }
}

