/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.batch.item;

import java.io.IOException;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamReader;
import org.springframework.batch.item.NonTransientResourceException;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.ReaderNotOpenException;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.data.hadoop.store.DataStoreReader;
import org.springframework.util.Assert;
import org.springframework.yarn.batch.item.LineDataMapper;

public class DataStoreItemReader<T>
implements ItemStreamReader<T> {
    public static final String READ_POSITION = "read.position";
    private long position = 0L;
    private DataStoreReader<T> dataStoreReader;
    private LineDataMapper<T> lineDataMapper;
    private boolean saveState = true;

    public DataStoreItemReader() {
    }

    public DataStoreItemReader(DataStoreReader<T> dataStoreReader) {
        this.dataStoreReader = dataStoreReader;
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        Assert.notNull(this.dataStoreReader, (String)"DataStoreReader must be set");
        Assert.notNull(this.lineDataMapper, (String)"LineDataMapper must be set");
        if (this.saveState) {
            this.restorePosition(executionContext.getLong(READ_POSITION, -1L));
        }
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        if (this.saveState) {
            Assert.notNull((Object)executionContext, (String)"ExecutionContext must not be null");
            executionContext.putLong(READ_POSITION, this.position);
        }
    }

    public void close() throws ItemStreamException {
        if (this.dataStoreReader != null) {
            try {
                this.dataStoreReader.close();
            }
            catch (IOException e) {
                throw new ItemStreamException("Error while closing item reader", (Throwable)e);
            }
            finally {
                this.dataStoreReader = null;
            }
        }
    }

    public T read() throws Exception, UnexpectedInputException, ParseException, NonTransientResourceException {
        T line = this.readStore();
        if (line == null) {
            return null;
        }
        ++this.position;
        return this.lineDataMapper.mapLine((String)line);
    }

    public void setLineDataMapper(LineDataMapper<T> lineDataMapper) {
        this.lineDataMapper = lineDataMapper;
    }

    public void setDataStoreReader(DataStoreReader<T> dataStoreReader) {
        this.dataStoreReader = dataStoreReader;
    }

    public void setSaveState(boolean saveState) {
        this.saveState = saveState;
    }

    public boolean isSaveState() {
        return this.saveState;
    }

    private T readStore() {
        if (this.dataStoreReader == null) {
            throw new ReaderNotOpenException("Reader must be open before it can be read.");
        }
        try {
            return (T)this.dataStoreReader.read();
        }
        catch (IOException e) {
            throw new NonTransientResourceException("Unable to read from resource: [" + this.dataStoreReader + "]", (Throwable)e);
        }
    }

    private void restorePosition(long toPosition) throws ItemStreamException {
        if (toPosition < 0L) {
            return;
        }
        while (this.readStore() != null && ++this.position < toPosition) {
        }
        if (this.position < toPosition) {
            throw new ItemStreamException("Expected to restore to position " + toPosition + " but was only able to read to position " + this.position);
        }
    }
}

