/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.batch.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.StepLocator;
import org.springframework.batch.support.transaction.ResourcelessTransactionManager;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.channel.QueueChannel;
import org.springframework.integration.config.ConsumerEndpointFactoryBean;
import org.springframework.integration.config.IntegrationConverter;
import org.springframework.integration.ip.tcp.TcpOutboundGateway;
import org.springframework.integration.ip.tcp.connection.AbstractClientConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpNetClientConnectionFactory;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.PollableChannel;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.yarn.batch.repository.RemoteJobExplorer;
import org.springframework.yarn.batch.repository.RemoteJobRepository;
import org.springframework.yarn.batch.support.BeanFactoryStepLocator;
import org.springframework.yarn.integration.convert.MindHolderToObjectConverter;
import org.springframework.yarn.integration.convert.MindObjectToHolderConverter;
import org.springframework.yarn.integration.ip.mind.AppmasterMindScOperations;
import org.springframework.yarn.integration.ip.mind.DefaultMindAppmasterServiceClient;
import org.springframework.yarn.integration.ip.mind.MindRpcSerializer;
import org.springframework.yarn.integration.support.Jackson2ObjectMapperFactoryBean;

@Configuration
public class SimpleYarnRemoteBatchConfiguration {
    @Value(value="${SHDP_AMSERVICE_HOST}")
    private String host;
    @Value(value="${SHDP_AMSERVICE_PORT}")
    private int port;

    @Bean
    public JobBuilderFactory jobBuilders() throws Exception {
        return new JobBuilderFactory(this.jobRepository());
    }

    @Bean
    public StepBuilderFactory stepBuilders() throws Exception {
        return new StepBuilderFactory(this.jobRepository(), this.transactionManager());
    }

    @Bean
    public PlatformTransactionManager transactionManager() throws Exception {
        return new ResourcelessTransactionManager();
    }

    @Bean
    public StepLocator stepLocator() {
        return new BeanFactoryStepLocator();
    }

    @Bean
    public JobRepository jobRepository() {
        return new RemoteJobRepository(this.appmasterServiceClient());
    }

    @Bean
    public JobExplorer jobExplorer() {
        return new RemoteJobExplorer(this.appmasterServiceClient());
    }

    @Bean
    public DirectChannel directChannel() {
        return new DirectChannel();
    }

    @Bean
    public QueueChannel queueChannel() {
        return new QueueChannel();
    }

    @Bean
    public MindRpcSerializer mindRpcSerializer() {
        return new MindRpcSerializer();
    }

    @Bean
    public TcpNetClientConnectionFactory tcpNetClientConnectionFactory() {
        TcpNetClientConnectionFactory factory = new TcpNetClientConnectionFactory(this.host, this.port);
        factory.setSerializer((Serializer)this.mindRpcSerializer());
        factory.setDeserializer((Deserializer)this.mindRpcSerializer());
        return factory;
    }

    @Bean
    public TcpOutboundGateway tcpOutboundGateway() {
        TcpOutboundGateway gateway = new TcpOutboundGateway();
        gateway.setConnectionFactory((AbstractClientConnectionFactory)this.tcpNetClientConnectionFactory());
        gateway.setOutputChannel((MessageChannel)this.directChannel());
        gateway.setReplyChannel((MessageChannel)this.queueChannel());
        gateway.setRequestTimeout(60000L);
        gateway.setRemoteTimeout(60000L);
        return gateway;
    }

    @Bean
    public ConsumerEndpointFactoryBean consumerEndpointFactoryBean() {
        ConsumerEndpointFactoryBean endpointFactoryBean = new ConsumerEndpointFactoryBean();
        endpointFactoryBean.setHandler((MessageHandler)this.tcpOutboundGateway());
        endpointFactoryBean.setInputChannel((MessageChannel)this.directChannel());
        return endpointFactoryBean;
    }

    @Bean(name={"yarnAmserviceClient"})
    public AppmasterMindScOperations appmasterServiceClient() {
        DefaultMindAppmasterServiceClient client = new DefaultMindAppmasterServiceClient();
        client.setRequestChannel((MessageChannel)this.directChannel());
        client.setResponseChannel((PollableChannel)this.queueChannel());
        return client;
    }

    @Bean
    public ObjectMapper objectMapper() {
        Jackson2ObjectMapperFactoryBean factory = new Jackson2ObjectMapperFactoryBean();
        factory.afterPropertiesSet();
        return factory.getObject();
    }

    @Bean
    @IntegrationConverter
    public MindObjectToHolderConverter mindObjectToHolderConverter() {
        return new MindObjectToHolderConverter(this.objectMapper());
    }

    @Bean
    @IntegrationConverter
    public MindHolderToObjectConverter mindHolderToObjectConverter() {
        String[] packages = new String[]{"org.springframework.yarn.batch.repository.bindings", "org.springframework.yarn.batch.repository.bindings.exp", "org.springframework.yarn.batch.repository.bindings.repo"};
        return new MindHolderToObjectConverter(this.objectMapper(), packages);
    }
}

