/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.Collections;
import org.springframework.data.solr.core.query.AbstractFunction;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.Function;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.util.Assert;

public class ProductFunction
extends AbstractFunction {
    private static final String OPERATION = "product";

    private ProductFunction(Object value) {
        super(Collections.singletonList(value));
    }

    public static Builder product(Number value) {
        return new Builder(value);
    }

    public static Builder product(Field field) {
        Assert.notNull((Object)field, (String)"Field must not be 'null'");
        return new Builder(field);
    }

    public static Builder product(String fieldName) {
        Assert.hasText((String)fieldName, (String)"FieldName must not be empty");
        return ProductFunction.product(new SimpleField(fieldName));
    }

    public static Builder product(Function function) {
        return new Builder(function);
    }

    @Override
    public String getOperation() {
        return OPERATION;
    }

    public static class Builder {
        private ProductFunction function;

        public Builder(Field field) {
            Assert.notNull((Object)field, (String)"field must not be 'null'.");
            this.function = new ProductFunction(field);
        }

        public Builder(Number value) {
            Assert.notNull((Object)value, (String)"Argument 'value' must not be 'null'.");
            this.function = new ProductFunction(value);
        }

        public Builder(Function function) {
            Assert.notNull((Object)function, (String)"Argument 'function' must not be 'null'.");
            this.function = new ProductFunction(function);
        }

        public Builder times(Field field) {
            Assert.notNull((Object)field, (String)"Argument 'field' must not be 'null'.");
            this.function.addArgument(field);
            return this;
        }

        public Builder times(String fieldName) {
            Assert.hasText((String)fieldName, (String)"fieldName must not be 'empty'.");
            return this.times(new SimpleField(fieldName));
        }

        public Builder times(Number value) {
            Assert.notNull((Object)value, (String)"Argument 'value' must not be 'null'.");
            this.function.addArgument(value);
            return this;
        }

        public Builder times(Function function) {
            Assert.notNull((Object)function, (String)"Argument 'function' must not be 'null'.");
            this.function.addArgument(function);
            return this;
        }

        public ProductFunction build() {
            return this.function;
        }
    }
}

