/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core;

import java.io.Serializable;
import java.util.Collection;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.springframework.data.domain.Page;
import org.springframework.data.solr.core.CollectionCallback;
import org.springframework.data.solr.core.RequestMethod;
import org.springframework.data.solr.core.SolrCallback;
import org.springframework.data.solr.core.convert.SolrConverter;
import org.springframework.data.solr.core.query.FacetAndHighlightQuery;
import org.springframework.data.solr.core.query.FacetQuery;
import org.springframework.data.solr.core.query.HighlightQuery;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.SolrDataQuery;
import org.springframework.data.solr.core.query.TermsQuery;
import org.springframework.data.solr.core.query.result.Cursor;
import org.springframework.data.solr.core.query.result.FacetAndHighlightPage;
import org.springframework.data.solr.core.query.result.FacetPage;
import org.springframework.data.solr.core.query.result.GroupPage;
import org.springframework.data.solr.core.query.result.HighlightPage;
import org.springframework.data.solr.core.query.result.ScoredPage;
import org.springframework.data.solr.core.query.result.StatsPage;
import org.springframework.data.solr.core.query.result.TermsPage;
import org.springframework.data.solr.core.schema.SchemaOperations;

public interface SolrOperations {
    public SolrClient getSolrClient();

    public SolrPingResponse ping();

    public long count(SolrDataQuery var1);

    public long count(String var1, SolrDataQuery var2);

    public long count(SolrDataQuery var1, RequestMethod var2);

    public long count(String var1, SolrDataQuery var2, RequestMethod var3);

    public UpdateResponse saveBean(Object var1);

    public UpdateResponse saveBean(String var1, Object var2);

    public UpdateResponse saveBean(Object var1, int var2);

    public UpdateResponse saveBean(String var1, Object var2, int var3);

    public UpdateResponse saveBeans(Collection<?> var1);

    public UpdateResponse saveBeans(String var1, Collection<?> var2);

    public UpdateResponse saveBeans(Collection<?> var1, int var2);

    public UpdateResponse saveBeans(String var1, Collection<?> var2, int var3);

    public UpdateResponse saveDocument(SolrInputDocument var1);

    public UpdateResponse saveDocument(String var1, SolrInputDocument var2);

    public UpdateResponse saveDocument(SolrInputDocument var1, int var2);

    public UpdateResponse saveDocument(String var1, SolrInputDocument var2, int var3);

    public UpdateResponse saveDocuments(Collection<SolrInputDocument> var1);

    public UpdateResponse saveDocuments(String var1, Collection<SolrInputDocument> var2);

    public UpdateResponse saveDocuments(Collection<SolrInputDocument> var1, int var2);

    public UpdateResponse saveDocuments(String var1, Collection<SolrInputDocument> var2, int var3);

    public UpdateResponse delete(SolrDataQuery var1);

    public UpdateResponse delete(String var1, SolrDataQuery var2);

    public UpdateResponse deleteById(String var1);

    public UpdateResponse deleteById(String var1, String var2);

    public UpdateResponse deleteById(Collection<String> var1);

    public UpdateResponse deleteById(String var1, Collection<String> var2);

    public <T> T queryForObject(Query var1, Class<T> var2);

    public <T> T queryForObject(String var1, Query var2, Class<T> var3);

    public <T> T queryForObject(Query var1, Class<T> var2, RequestMethod var3);

    public <T> T queryForObject(String var1, Query var2, Class<T> var3, RequestMethod var4);

    public <T> ScoredPage<T> queryForPage(Query var1, Class<T> var2);

    public <T> ScoredPage<T> queryForPage(String var1, Query var2, Class<T> var3);

    public <T> ScoredPage<T> queryForPage(Query var1, Class<T> var2, RequestMethod var3);

    public <T> ScoredPage<T> queryForPage(String var1, Query var2, Class<T> var3, RequestMethod var4);

    public <T> FacetPage<T> queryForFacetPage(FacetQuery var1, Class<T> var2);

    public <T> FacetPage<T> queryForFacetPage(String var1, FacetQuery var2, Class<T> var3);

    public <T> FacetPage<T> queryForFacetPage(FacetQuery var1, Class<T> var2, RequestMethod var3);

    public <T> FacetPage<T> queryForFacetPage(String var1, FacetQuery var2, Class<T> var3, RequestMethod var4);

    public <T> HighlightPage<T> queryForHighlightPage(HighlightQuery var1, Class<T> var2);

    public <T> HighlightPage<T> queryForHighlightPage(String var1, HighlightQuery var2, Class<T> var3);

    public <T> HighlightPage<T> queryForHighlightPage(HighlightQuery var1, Class<T> var2, RequestMethod var3);

    public <T> HighlightPage<T> queryForHighlightPage(String var1, HighlightQuery var2, Class<T> var3, RequestMethod var4);

    public <T> FacetAndHighlightPage<T> queryForFacetAndHighlightPage(FacetAndHighlightQuery var1, Class<T> var2);

    public <T> FacetAndHighlightPage<T> queryForFacetAndHighlightPage(String var1, FacetAndHighlightQuery var2, Class<T> var3);

    public <T> FacetAndHighlightPage<T> queryForFacetAndHighlightPage(FacetAndHighlightQuery var1, Class<T> var2, RequestMethod var3);

    public <T> FacetAndHighlightPage<T> queryForFacetAndHighlightPage(String var1, FacetAndHighlightQuery var2, Class<T> var3, RequestMethod var4);

    public TermsPage queryForTermsPage(TermsQuery var1);

    public TermsPage queryForTermsPage(String var1, TermsQuery var2);

    public TermsPage queryForTermsPage(TermsQuery var1, RequestMethod var2);

    public TermsPage queryForTermsPage(String var1, TermsQuery var2, RequestMethod var3);

    public <T> Cursor<T> queryForCursor(Query var1, Class<T> var2);

    public <T> GroupPage<T> queryForGroupPage(Query var1, Class<T> var2);

    public <T> GroupPage<T> queryForGroupPage(String var1, Query var2, Class<T> var3);

    public <T> GroupPage<T> queryForGroupPage(Query var1, Class<T> var2, RequestMethod var3);

    public <T> GroupPage<T> queryForGroupPage(String var1, Query var2, Class<T> var3, RequestMethod var4);

    public <T> StatsPage<T> queryForStatsPage(Query var1, Class<T> var2);

    public <T> StatsPage<T> queryForStatsPage(String var1, Query var2, Class<T> var3);

    public <T> StatsPage<T> queryForStatsPage(Query var1, Class<T> var2, RequestMethod var3);

    public <T> StatsPage<T> queryForStatsPage(String var1, Query var2, Class<T> var3, RequestMethod var4);

    public <T, S extends Page<T>> S query(Query var1, Class<T> var2);

    public <T, S extends Page<T>> S query(String var1, Query var2, Class<T> var3);

    public <T, S extends Page<T>> S query(Query var1, Class<T> var2, RequestMethod var3);

    public <T, S extends Page<T>> S query(String var1, Query var2, Class<T> var3, RequestMethod var4);

    public <T> T getById(Serializable var1, Class<T> var2);

    public <T> T getById(String var1, Serializable var2, Class<T> var3);

    public <T> Collection<T> getById(Collection<? extends Serializable> var1, Class<T> var2);

    public <T> Collection<T> getById(String var1, Collection<? extends Serializable> var2, Class<T> var3);

    public void commit();

    public void commit(String var1);

    public void softCommit();

    public void softCommit(String var1);

    public void rollback();

    public void rollback(String var1);

    public SolrInputDocument convertBeanToSolrInputDocument(Object var1);

    public SolrConverter getConverter();

    public <T> T execute(SolrCallback<T> var1);

    public <T> T execute(String var1, CollectionCallback<T> var2);

    public SchemaOperations getSchemaOperations(String var1);
}

