/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.solr.client.solrj.SolrServer;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;
import org.springframework.data.querydsl.QueryDslUtils;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.solr.core.SolrOperations;
import org.springframework.data.solr.core.SolrTemplate;
import org.springframework.data.solr.core.schema.SolrPersistentEntitySchemaCreator;
import org.springframework.data.solr.repository.query.PartTreeSolrQuery;
import org.springframework.data.solr.repository.query.SolrEntityInformation;
import org.springframework.data.solr.repository.query.SolrEntityInformationCreator;
import org.springframework.data.solr.repository.query.SolrQueryMethod;
import org.springframework.data.solr.repository.query.StringBasedSolrQuery;
import org.springframework.data.solr.repository.support.SimpleSolrRepository;
import org.springframework.data.solr.repository.support.SolrEntityInformationCreatorImpl;
import org.springframework.data.solr.server.SolrServerFactory;
import org.springframework.data.solr.server.support.MulticoreSolrServerFactory;
import org.springframework.data.solr.server.support.SolrServerUtils;
import org.springframework.util.Assert;

public class SolrRepositoryFactory
extends RepositoryFactorySupport {
    private SolrOperations solrOperations;
    private final SolrEntityInformationCreator entityInformationCreator;
    private SolrServerFactory factory;
    private SolrTemplateHolder templateHolder = new SolrTemplateHolder();
    private boolean schemaCreationSupport;

    public SolrRepositoryFactory(SolrOperations solrOperations) {
        Assert.notNull((Object)solrOperations);
        if (solrOperations instanceof SolrTemplate) {
            this.addSchemaCreationFeaturesIfEnabled((SolrTemplate)solrOperations);
        }
        this.solrOperations = solrOperations;
        this.entityInformationCreator = new SolrEntityInformationCreatorImpl(solrOperations.getConverter().getMappingContext());
    }

    public SolrRepositoryFactory(SolrServer solrServer) {
        Assert.notNull((Object)solrServer);
        this.solrOperations = this.createTemplate(solrServer);
        this.factory = new MulticoreSolrServerFactory(solrServer);
        this.entityInformationCreator = new SolrEntityInformationCreatorImpl(this.solrOperations.getConverter().getMappingContext());
    }

    private SolrTemplate createTemplate(SolrServer solrServer) {
        SolrTemplate template = new SolrTemplate(solrServer);
        this.addSchemaCreationFeaturesIfEnabled(template);
        template.afterPropertiesSet();
        return template;
    }

    public <T, ID extends Serializable> SolrEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return this.entityInformationCreator.getEntityInformation(domainClass);
    }

    protected Object getTargetRepository(RepositoryMetadata metadata) {
        SolrOperations operations = this.solrOperations;
        if (this.factory != null) {
            SolrTemplate template = new SolrTemplate(this.factory);
            template.setSolrCore(SolrServerUtils.resolveSolrCoreName(metadata.getDomainType()));
            this.addSchemaCreationFeaturesIfEnabled(template);
            template.afterPropertiesSet();
            operations = template;
        }
        SimpleSolrRepository repository = new SimpleSolrRepository(this.getEntityInformation(metadata.getDomainType()), operations);
        repository.setEntityClass(metadata.getDomainType());
        this.templateHolder.add(metadata.getDomainType(), operations);
        return repository;
    }

    private void addSchemaCreationFeaturesIfEnabled(SolrTemplate template) {
        if (this.isSchemaCreationSupport()) {
            template.setSchemaCreationFeatures(Collections.singletonList(SolrPersistentEntitySchemaCreator.Feature.CREATE_MISSING_FIELDS));
        }
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        if (SolrRepositoryFactory.isQueryDslRepository(metadata.getRepositoryInterface())) {
            throw new IllegalArgumentException("QueryDsl Support has not been implemented yet.");
        }
        return SimpleSolrRepository.class;
    }

    private static boolean isQueryDslRepository(Class<?> repositoryInterface) {
        return QueryDslUtils.QUERY_DSL_PRESENT && QueryDslPredicateExecutor.class.isAssignableFrom(repositoryInterface);
    }

    protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key) {
        return new SolrQueryLookupStrategy();
    }

    public boolean isSchemaCreationSupport() {
        return this.schemaCreationSupport;
    }

    public void setSchemaCreationSupport(boolean schemaCreationSupport) {
        this.schemaCreationSupport = schemaCreationSupport;
    }

    private static class SolrTemplateHolder {
        private Map<Class<?>, SolrOperations> operationsMap = new WeakHashMap();

        private SolrTemplateHolder() {
        }

        void add(Class<?> domainType, SolrOperations repository) {
            this.operationsMap.put(domainType, repository);
        }

        SolrOperations getSolrOperations(Class<?> type) {
            return this.operationsMap.get(type);
        }
    }

    private class SolrQueryLookupStrategy
    implements QueryLookupStrategy {
        private SolrQueryLookupStrategy() {
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, NamedQueries namedQueries) {
            SolrQueryMethod queryMethod = new SolrQueryMethod(method, metadata, SolrRepositoryFactory.this.entityInformationCreator);
            String namedQueryName = queryMethod.getNamedQueryName();
            SolrOperations solrOperations = this.selectSolrOperations(metadata);
            if (namedQueries.hasQuery(namedQueryName)) {
                String namedQuery = namedQueries.getQuery(namedQueryName);
                return new StringBasedSolrQuery(namedQuery, queryMethod, solrOperations);
            }
            if (queryMethod.hasAnnotatedQuery()) {
                return new StringBasedSolrQuery(queryMethod, solrOperations);
            }
            return new PartTreeSolrQuery(queryMethod, solrOperations);
        }

        private SolrOperations selectSolrOperations(RepositoryMetadata metadata) {
            SolrOperations ops = SolrRepositoryFactory.this.templateHolder.getSolrOperations(metadata.getDomainType());
            if (ops == null) {
                ops = SolrRepositoryFactory.this.solrOperations;
            }
            return ops;
        }
    }
}

