/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.mapping;

import java.util.Locale;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.solr.core.mapping.SolrDocument;
import org.springframework.data.solr.core.mapping.SolrPersistentEntity;
import org.springframework.data.solr.core.mapping.SolrPersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.StringUtils;

public class SimpleSolrPersistentEntity<T>
extends BasicPersistentEntity<T, SolrPersistentProperty>
implements SolrPersistentEntity<T>,
ApplicationContextAware {
    private final TypeInformation<T> typeInformation;
    private final StandardEvaluationContext context = new StandardEvaluationContext();
    private String solrCoreName;
    private Float boost;

    public SimpleSolrPersistentEntity(TypeInformation<T> typeInformation) {
        super(typeInformation);
        this.typeInformation = typeInformation;
        this.solrCoreName = this.derivateSolrCoreName();
        this.boost = this.derivateDocumentBoost();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
        this.context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)applicationContext));
        this.context.setRootObject((Object)applicationContext);
    }

    private String derivateSolrCoreName() {
        String derivativeSolrCoreName = this.typeInformation.getType().getSimpleName().toLowerCase(Locale.ENGLISH);
        SolrDocument solrDocument = (SolrDocument)this.findAnnotation(SolrDocument.class);
        if (solrDocument != null && StringUtils.hasText((String)solrDocument.solrCoreName())) {
            derivativeSolrCoreName = solrDocument.solrCoreName();
        }
        return derivativeSolrCoreName;
    }

    private Float derivateDocumentBoost() {
        SolrDocument solrDocument = (SolrDocument)this.findAnnotation(SolrDocument.class);
        if (solrDocument != null && !Float.isNaN(solrDocument.boost())) {
            return Float.valueOf(solrDocument.boost());
        }
        return null;
    }

    @Override
    public String getSolrCoreName() {
        return this.solrCoreName;
    }

    @Override
    public boolean isBoosted() {
        return this.boost != null;
    }

    @Override
    public Float getBoost() {
        return this.boost;
    }
}

