/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json.patch;

import org.springframework.data.rest.webmvc.json.patch.LateObjectEvaluator;
import org.springframework.data.rest.webmvc.json.patch.PatchException;
import org.springframework.util.Assert;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;

class JsonLateObjectEvaluator
implements LateObjectEvaluator {
    private final ObjectMapper mapper;
    private final JsonNode node;

    public JsonLateObjectEvaluator(ObjectMapper mapper, JsonNode node) {
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null");
        Assert.notNull((Object)node, (String)"JsonNode must not be null");
        this.mapper = mapper;
        this.node = node;
    }

    @Override
    public Object evaluate(Class<?> type) {
        try {
            return this.mapper.readValue(this.node.traverse((ObjectReadContext)this.mapper._deserializationContext()), type);
        }
        catch (Exception o_O) {
            throw new PatchException(String.format("Could not read %s into %s", this.node, type), o_O);
        }
    }
}

