/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.data.rest.webmvc.PersistentEntityResourceAssembler;
import org.springframework.data.rest.webmvc.RepresentationModelAssemblers;
import org.springframework.data.rest.webmvc.config.PersistentEntityResourceAssemblerArgumentResolver;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.data.web.SlicedResourcesAssembler;
import org.springframework.util.Assert;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class RepresentationModelAssemblersArgumentResolver
implements HandlerMethodArgumentResolver {
    private final PagedResourcesAssembler<Object> pagedResourcesAssembler;
    private final SlicedResourcesAssembler<Object> slicedResourcesAssembler;
    private final PersistentEntityResourceAssemblerArgumentResolver delegate;

    RepresentationModelAssemblersArgumentResolver(PagedResourcesAssembler<Object> pagedResourcesAssembler, SlicedResourcesAssembler<Object> slicedResourcesAssembler, PersistentEntityResourceAssemblerArgumentResolver delegate) {
        Assert.notNull(pagedResourcesAssembler, (String)"PagedResourcesAssembler must not be null!");
        Assert.notNull(slicedResourcesAssembler, (String)"SlicedResourcesAssembler must not be null!");
        Assert.notNull((Object)delegate, (String)"PersistentEntityResourceAssemblerArgumentResolver must not be null");
        this.pagedResourcesAssembler = pagedResourcesAssembler;
        this.slicedResourcesAssembler = slicedResourcesAssembler;
        this.delegate = delegate;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return RepresentationModelAssemblers.class.isAssignableFrom(parameter.getParameterType());
    }

    public @Nullable Object resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws Exception {
        PersistentEntityResourceAssembler persistentEntityResourceAssembler = this.delegate.resolveArgument(parameter, mavContainer, webRequest, binderFactory);
        return new RepresentationModelAssemblers(this.pagedResourcesAssembler, this.slicedResourcesAssembler, persistentEntityResourceAssembler);
    }
}

