/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import java.util.ArrayList;
import org.springframework.data.rest.webmvc.json.EnumTranslator;
import org.springframework.data.rest.webmvc.json.JsonSchema;
import org.springframework.data.rest.webmvc.json.JsonSchemaPropertyCustomizer;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.deser.std.StdDeserializer;
import tools.jackson.databind.module.SimpleDeserializers;
import tools.jackson.databind.module.SimpleModule;
import tools.jackson.databind.module.SimpleSerializers;
import tools.jackson.databind.ser.std.StdSerializer;

public class Jackson3Serializers
extends SimpleModule {
    private static final long serialVersionUID = 4396776390917947147L;

    public Jackson3Serializers(EnumTranslator translator) {
        Assert.notNull((Object)translator, (String)"EnumTranslator must not be null");
        SimpleSerializers serializers = new SimpleSerializers();
        serializers.addSerializer(Enum.class, (ValueSerializer)new EnumTranslatingSerializer(translator));
        this.setSerializers(serializers);
        SimpleDeserializers deserializers = new SimpleDeserializers();
        deserializers.addDeserializer(Enum.class, (ValueDeserializer)new EnumTranslatingDeserializer(translator));
        this.setDeserializers(deserializers);
    }

    public static class EnumTranslatingSerializer
    extends StdSerializer<Enum>
    implements JsonSchemaPropertyCustomizer {
        private final EnumTranslator translator;

        public EnumTranslatingSerializer(EnumTranslator translator) {
            super(Enum.class);
            Assert.notNull((Object)translator, (String)"EnumTranslator must not be null");
            this.translator = translator;
        }

        public void serialize(Enum value, JsonGenerator gen, SerializationContext provider) {
            gen.writeString(this.translator.asText(value));
        }

        @Override
        public JsonSchema.JsonSchemaProperty customize(JsonSchema.JsonSchemaProperty property, TypeInformation<?> type) {
            ArrayList<String> values = new ArrayList<String>();
            for (Object value : type.getType().getEnumConstants()) {
                values.add(this.translator.asText((Enum)value));
            }
            return ((JsonSchema.EnumProperty)property).withValues(values);
        }
    }

    public static class EnumTranslatingDeserializer
    extends StdDeserializer<Enum> {
        private final EnumTranslator translator;
        private final BeanProperty property;

        public EnumTranslatingDeserializer(EnumTranslator translator) {
            this(translator, null);
        }

        public EnumTranslatingDeserializer(EnumTranslator translator, BeanProperty property) {
            super(Enum.class);
            Assert.notNull((Object)translator, (String)"EnumTranslator must not be null");
            this.translator = translator;
            this.property = property;
        }

        public ValueDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
            return new EnumTranslatingDeserializer(this.translator, property);
        }

        public Enum deserialize(JsonParser p, DeserializationContext ctxt) {
            if (this.property == null) {
                throw new IllegalStateException("Can only translate enum with property information");
            }
            return this.translator.fromText(EnumTranslatingDeserializer.getActualType(this.property.getType()).getRawClass(), p.getText());
        }

        private static JavaType getActualType(JavaType type) {
            return type.isContainerType() ? type.getContentType() : type;
        }
    }
}

