/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import java.util.Iterator;
import org.springframework.data.rest.core.UriToEntityConverter;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.webmvc.json.PersistentEntityJackson3Module;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.BeanDeserializerBuilder;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.databind.deser.ValueDeserializerModifier;
import tools.jackson.databind.deser.ValueInstantiator;
import tools.jackson.databind.deser.jdk.CollectionDeserializer;
import tools.jackson.databind.introspect.BeanPropertyDefinition;
import tools.jackson.databind.module.SimpleModule;
import tools.jackson.databind.type.CollectionLikeType;

public class AggregateReferenceResolvingModule
extends SimpleModule {
    public AggregateReferenceResolvingModule(UriToEntityConverter converter, ResourceMappings mappings) {
        this.setDeserializerModifier(new AggregateReferenceDeserializerModifier(converter, mappings));
    }

    static class AggregateReferenceDeserializerModifier
    extends ValueDeserializerModifier {
        private final UriToEntityConverter converter;
        private final ResourceMappings mappings;

        public AggregateReferenceDeserializerModifier(UriToEntityConverter converter, ResourceMappings mappings) {
            Assert.notNull((Object)converter, (String)"UriToEntityConverter must not be null");
            Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null");
            this.converter = converter;
            this.mappings = mappings;
        }

        public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, BeanDescription.Supplier supplier, BeanDeserializerBuilder builder) {
            if (this.mappings.hasMappingFor(supplier.getBeanClass())) {
                return builder;
            }
            BeanDescription beanDescription = supplier.get();
            TypeInformation type = TypeInformation.of((Class)supplier.getBeanClass());
            PersistentEntityJackson3Module.AssociationUriResolvingDeserializerModifier.ValueInstantiatorCustomizer customizer = new PersistentEntityJackson3Module.AssociationUriResolvingDeserializerModifier.ValueInstantiatorCustomizer(builder.getValueInstantiator(), config);
            Iterator properties = builder.getProperties();
            while (properties.hasNext()) {
                TypeInformation actualType;
                SettableBeanProperty property = (SettableBeanProperty)properties.next();
                String originalPropertyName = AggregateReferenceDeserializerModifier.coerceOriginalPropertyName(property, beanDescription);
                TypeInformation propertyType = type.getProperty(originalPropertyName);
                if (propertyType == null || (actualType = propertyType.getActualType()) == null || !this.mappings.exportsMappingFor(actualType.getType())) continue;
                PersistentEntityJackson3Module.UriStringDeserializer uriStringDeserializer = new PersistentEntityJackson3Module.UriStringDeserializer(actualType.getType(), this.converter);
                ValueDeserializer<?> deserializer = AggregateReferenceDeserializerModifier.wrapIfCollection(propertyType, (ValueDeserializer<Object>)uriStringDeserializer, config);
                customizer.replacePropertyIfNeeded(builder, property.withValueDeserializer(deserializer));
            }
            return builder;
        }

        private static ValueDeserializer<?> wrapIfCollection(TypeInformation<?> type, ValueDeserializer<Object> elementDeserializer, DeserializationConfig config) {
            if (!type.isCollectionLike()) {
                return elementDeserializer;
            }
            CollectionLikeType collectionType = config.getTypeFactory().constructCollectionLikeType(type.getType(), type.getRequiredActualType().getType());
            PersistentEntityJackson3Module.CollectionValueInstantiator instantiator = new PersistentEntityJackson3Module.CollectionValueInstantiator(type);
            return new CollectionDeserializer((JavaType)collectionType, elementDeserializer, null, (ValueInstantiator)instantiator);
        }

        private static String coerceOriginalPropertyName(SettableBeanProperty property, BeanDescription description) {
            for (BeanPropertyDefinition properties : description.findProperties()) {
                if (!properties.hasName(property.getFullName())) continue;
                return properties.getInternalName();
            }
            return property.getName();
        }
    }
}

