/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.server.mvc.TypeConstrainedMappingJackson2HttpMessageConverter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

class HalFormsAdaptingResponseBodyAdvice<T extends RepresentationModel<T>>
implements ResponseBodyAdvice<RepresentationModel<T>> {
    private static final Logger logger = LoggerFactory.getLogger(HalFormsAdaptingResponseBodyAdvice.class);
    private static final String MESSAGE = "HalFormsRejectingResponseBodyAdvice - Changing content type to '%s' as no affordances were registered on the representation model to be rendered";
    private static final List<MediaType> SUPPORTED_MEDIA_TYPES = Arrays.asList(MediaTypes.HAL_JSON, MediaType.APPLICATION_JSON);

    HalFormsAdaptingResponseBodyAdvice() {
    }

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return TypeConstrainedMappingJackson2HttpMessageConverter.class.isAssignableFrom(converterType);
    }

    public @Nullable RepresentationModel<T> beforeBodyWrite(@Nullable RepresentationModel<T> body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        boolean hasAffordances;
        if (!MediaTypes.HAL_FORMS_JSON.equals((Object)selectedContentType)) {
            return body;
        }
        List accept = request.getHeaders().getAccept();
        boolean bl = hasAffordances = body != null && body.getLinks().stream().anyMatch(it -> !it.getAffordances().isEmpty());
        if (hasAffordances) {
            return body;
        }
        for (MediaType candidate : accept) {
            for (MediaType supported : SUPPORTED_MEDIA_TYPES) {
                if (!candidate.isCompatibleWith(supported)) continue;
                logger.debug(String.format(MESSAGE, supported));
                response.getHeaders().setContentType(supported);
                return body;
            }
        }
        HalFormsAdaptingResponseBodyAdvice.throwException(new HttpMediaTypeNotAcceptableException(SUPPORTED_MEDIA_TYPES));
        throw new UnsupportedOperationException();
    }

    private static <T extends Throwable> void throwException(Throwable exception) throws T {
        throw exception;
    }
}

