/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.CollectionDeserializer;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import java.util.Iterator;
import org.springframework.data.rest.core.UriToEntityConverter;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.webmvc.json.PersistentEntityJackson2Module;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class AggregateReferenceResolvingModule
extends SimpleModule {
    private static final long serialVersionUID = 6002883434719869173L;

    public AggregateReferenceResolvingModule(UriToEntityConverter converter, ResourceMappings mappings) {
        this.setDeserializerModifier(new AggregateReferenceDeserializerModifier(converter, mappings));
    }

    static class AggregateReferenceDeserializerModifier
    extends BeanDeserializerModifier {
        private final UriToEntityConverter converter;
        private final ResourceMappings mappings;

        public AggregateReferenceDeserializerModifier(UriToEntityConverter converter, ResourceMappings mappings) {
            Assert.notNull((Object)converter, (String)"UriToEntityConverter must not be null");
            Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null");
            this.converter = converter;
            this.mappings = mappings;
        }

        public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, BeanDescription description, BeanDeserializerBuilder builder) {
            if (this.mappings.hasMappingFor(description.getBeanClass())) {
                return builder;
            }
            TypeInformation type = TypeInformation.of((Class)description.getBeanClass());
            PersistentEntityJackson2Module.AssociationUriResolvingDeserializerModifier.ValueInstantiatorCustomizer customizer = new PersistentEntityJackson2Module.AssociationUriResolvingDeserializerModifier.ValueInstantiatorCustomizer(builder.getValueInstantiator(), config);
            Iterator properties = builder.getProperties();
            while (properties.hasNext()) {
                TypeInformation actualType;
                SettableBeanProperty property = (SettableBeanProperty)properties.next();
                String originalPropertyName = AggregateReferenceDeserializerModifier.coerceOriginalPropertyName(property, description);
                TypeInformation propertyType = type.getProperty(originalPropertyName);
                if (propertyType == null || !this.mappings.exportsMappingFor((actualType = propertyType.getActualType()).getType())) continue;
                PersistentEntityJackson2Module.UriStringDeserializer uriStringDeserializer = new PersistentEntityJackson2Module.UriStringDeserializer(actualType.getType(), this.converter);
                JsonDeserializer<?> deserializer = AggregateReferenceDeserializerModifier.wrapIfCollection(propertyType, (JsonDeserializer<Object>)uriStringDeserializer, config);
                customizer.replacePropertyIfNeeded(builder, property.withValueDeserializer(deserializer));
            }
            return builder;
        }

        private static JsonDeserializer<?> wrapIfCollection(TypeInformation<?> type, JsonDeserializer<Object> elementDeserializer, DeserializationConfig config) {
            if (!type.isCollectionLike()) {
                return elementDeserializer;
            }
            CollectionLikeType collectionType = config.getTypeFactory().constructCollectionLikeType(type.getType(), type.getActualType().getType());
            PersistentEntityJackson2Module.CollectionValueInstantiator instantiator = new PersistentEntityJackson2Module.CollectionValueInstantiator(type);
            return new CollectionDeserializer((JavaType)collectionType, elementDeserializer, null, (ValueInstantiator)instantiator);
        }

        private static String coerceOriginalPropertyName(SettableBeanProperty property, BeanDescription description) {
            for (BeanPropertyDefinition properties : description.findProperties()) {
                if (!properties.hasName(property.getFullName())) continue;
                return properties.getInternalName();
            }
            return property.getName();
        }
    }
}

