/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.server.core.EmbeddedWrapper;
import org.springframework.util.Assert;

public class PersistentEntityResource
extends EntityModel<Object> {
    private static final Iterable<EmbeddedWrapper> NO_EMBEDDEDS = new NoLinksResources(Collections.emptyList());
    private final PersistentEntity<?, ?> entity;
    private final Iterable<EmbeddedWrapper> embeddeds;
    private final boolean isNew;
    private final boolean nested;

    private PersistentEntityResource(PersistentEntity<?, ?> entity, Object content, Iterable<Link> links, Iterable<EmbeddedWrapper> embeddeds, boolean isNew, boolean nested) {
        super(content, links);
        Assert.notNull(entity, (String)"PersistentEntity must not be null!");
        this.entity = entity;
        this.embeddeds = embeddeds == null ? NO_EMBEDDEDS : embeddeds;
        this.isNew = isNew;
        this.nested = nested;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isNested() {
        return this.nested;
    }

    public PersistentEntity<?, ? extends PersistentProperty<?>> getPersistentEntity() {
        return this.entity;
    }

    public PersistentPropertyAccessor<?> getPropertyAccessor() {
        return this.entity.getPropertyAccessor(this.getContent());
    }

    public Iterable<EmbeddedWrapper> getEmbeddeds() {
        return this.embeddeds;
    }

    public static Builder build(Object content, PersistentEntity<?, ?> entity) {
        return new Builder(content, entity);
    }

    private static class NoLinksResources<T>
    extends CollectionModel<T> {
        public NoLinksResources(Iterable<T> content) {
            super(content, new Link[0]);
        }

        @JsonIgnore
        public Links getLinks() {
            return super.getLinks();
        }
    }

    public static class Builder {
        private final Object content;
        private final PersistentEntity<?, ?> entity;
        private final List<Link> links = new ArrayList<Link>();
        private Iterable<EmbeddedWrapper> embeddeds;

        private Builder(Object content, PersistentEntity<?, ?> entity) {
            Assert.notNull((Object)content, (String)"Content must not be null!");
            Assert.notNull(entity, (String)"PersistentEntity must not be null!");
            this.content = content;
            this.entity = entity;
        }

        public Builder withEmbedded(Iterable<EmbeddedWrapper> resources) {
            this.embeddeds = resources == null ? null : new NoLinksResources<EmbeddedWrapper>(resources);
            return this;
        }

        public Builder withLink(Link link) {
            Assert.notNull((Object)link, (String)"Link must not be null!");
            this.links.add(link);
            return this;
        }

        public Builder withLinks(List<Link> links) {
            Assert.notNull(links, (String)"Links must not be null!");
            this.links.addAll(links);
            return this;
        }

        public PersistentEntityResource build() {
            return new PersistentEntityResource(this.entity, this.content, this.links, this.embeddeds, false, false);
        }

        public PersistentEntityResource forCreation() {
            return new PersistentEntityResource(this.entity, this.content, this.links, this.embeddeds, true, false);
        }

        public PersistentEntityResource buildNested() {
            return new PersistentEntityResource(this.entity, this.content, this.links, this.embeddeds, false, true);
        }
    }
}

