/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import com.querydsl.core.types.Predicate;
import java.util.Arrays;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;
import org.springframework.data.querydsl.QuerydslRepositoryInvokerAdapter;
import org.springframework.data.querydsl.binding.QuerydslBindings;
import org.springframework.data.querydsl.binding.QuerydslBindingsFactory;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.data.querydsl.binding.QuerydslPredicateBuilder;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.data.rest.webmvc.config.ResourceMetadataHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.config.RootResourceInformationHandlerMethodArgumentResolver;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

class QuerydslAwareRootResourceInformationHandlerMethodArgumentResolver
extends RootResourceInformationHandlerMethodArgumentResolver {
    private final Repositories repositories;
    private final QuerydslPredicateBuilder predicateBuilder;
    private final QuerydslBindingsFactory factory;

    public QuerydslAwareRootResourceInformationHandlerMethodArgumentResolver(Repositories repositories, RepositoryInvokerFactory invokerFactory, ResourceMetadataHandlerMethodArgumentResolver resourceMetadataResolver, QuerydslPredicateBuilder predicateBuilder, QuerydslBindingsFactory factory) {
        super(repositories, invokerFactory, resourceMetadataResolver);
        this.repositories = repositories;
        this.predicateBuilder = predicateBuilder;
        this.factory = factory;
    }

    @Override
    protected RepositoryInvoker postProcess(MethodParameter parameter, RepositoryInvoker invoker, Class<?> domainType, Map<String, String[]> parameters) {
        Object repository = this.repositories.getRepositoryFor(domainType);
        if (!QueryDslPredicateExecutor.class.isInstance(repository) || !parameter.hasParameterAnnotation(QuerydslPredicate.class)) {
            return invoker;
        }
        ClassTypeInformation type = ClassTypeInformation.from(domainType);
        QuerydslBindings bindings = this.factory.createBindingsFor(null, (TypeInformation)type);
        Predicate predicate = this.predicateBuilder.getPredicate((TypeInformation)type, QuerydslAwareRootResourceInformationHandlerMethodArgumentResolver.toMultiValueMap(parameters), bindings);
        return new QuerydslRepositoryInvokerAdapter(invoker, (QueryDslPredicateExecutor)repository, predicate);
    }

    private static MultiValueMap<String, String> toMultiValueMap(Map<String, String[]> source) {
        LinkedMultiValueMap result = new LinkedMultiValueMap();
        for (Map.Entry<String, String[]> entry : source.entrySet()) {
            result.put((Object)entry.getKey(), Arrays.asList((Object[])entry.getValue()));
        }
        return result;
    }
}

