/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json.patch;

import java.util.ArrayList;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.rest.webmvc.json.patch.LateObjectEvaluator;
import org.springframework.data.rest.webmvc.json.patch.PatchOperation;
import org.springframework.util.StringUtils;

class AddOperation
extends PatchOperation {
    public AddOperation(String path, Object value) {
        super("add", path, value);
    }

    @Override
    <T> void perform(Object targetObject, Class<T> type) {
        this.addValue(targetObject, this.evaluateValueFromTarget(targetObject, type));
    }

    @Override
    protected <T> Object evaluateValueFromTarget(Object targetObject, Class<T> entityType) {
        if (!this.path.endsWith("-")) {
            return super.evaluateValueFromTarget(targetObject, entityType);
        }
        ArrayList<String> segments = new ArrayList<String>();
        for (String segment : this.path.split("/")) {
            if (segment.matches("\\d+") || segment.equals("-") || segment.isEmpty()) continue;
            segments.add(segment);
        }
        PropertyPath propertyPath = PropertyPath.from((String)StringUtils.collectionToDelimitedString(segments, (String)"."), entityType);
        return this.value instanceof LateObjectEvaluator ? ((LateObjectEvaluator)this.value).evaluate(propertyPath.getType()) : this.value;
    }
}

