/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStream;
import org.springframework.data.rest.webmvc.IncomingRequest;
import org.springframework.data.rest.webmvc.RestMediaTypes;
import org.springframework.data.rest.webmvc.json.DomainObjectReader;
import org.springframework.data.rest.webmvc.json.patch.JsonPatchPatchConverter;
import org.springframework.data.rest.webmvc.json.patch.Patch;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.util.Assert;

class JsonPatchHandler {
    private final ObjectMapper mapper;
    private final ObjectMapper sourceMapper;
    private final DomainObjectReader reader;

    public JsonPatchHandler(ObjectMapper mapper, DomainObjectReader reader) {
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null!");
        Assert.notNull((Object)reader, (String)"DomainObjectReader must not be null!");
        this.mapper = mapper;
        this.reader = reader;
        this.sourceMapper = mapper.copy();
        this.sourceMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public <T> T apply(IncomingRequest request, T target) throws Exception {
        Assert.notNull((Object)request, (String)"Request must not be null!");
        Assert.isTrue((boolean)request.isPatchRequest(), (String)"Cannot handle non-PATCH request!");
        Assert.notNull(target, (String)"Target must not be null!");
        if (request.isJsonPatchRequest()) {
            return this.applyPatch(request.getBody(), target);
        }
        return this.applyMergePatch(request.getBody(), target);
    }

    <T> T applyPatch(InputStream source, T target) throws Exception {
        return this.getPatchOperations(source).apply(target, target.getClass());
    }

    <T> T applyMergePatch(InputStream source, T existingObject) throws Exception {
        return this.reader.read(source, existingObject, this.mapper);
    }

    <T> T applyPut(ObjectNode source, T existingObject) {
        return this.reader.readPut(source, existingObject, this.mapper);
    }

    private Patch getPatchOperations(InputStream source) {
        try {
            return new JsonPatchPatchConverter().convert(this.mapper.readTree(source));
        }
        catch (Exception o_O) {
            throw new HttpMessageNotReadableException(String.format("Could not read PATCH operations! Expected %s!", RestMediaTypes.JSON_PATCH_JSON), (Throwable)o_O);
        }
    }
}

