/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.UnsatisfiedServletRequestParameterException;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerMapping;

public class DelegatingHandlerMapping
implements HandlerMapping,
Ordered {
    private final List<HandlerMapping> delegates;

    public DelegatingHandlerMapping(List<HandlerMapping> delegates) {
        Assert.notNull(delegates, (String)"Delegates must not be null!");
        this.delegates = delegates;
    }

    public int getOrder() {
        return 2147483547;
    }

    public HandlerExecutionChain getHandler(HttpServletRequest request) throws Exception {
        Throwable exception = null;
        for (HandlerMapping delegate : this.delegates) {
            try {
                HandlerExecutionChain result = delegate.getHandler(request);
                if (result == null) continue;
                return result;
            }
            catch (HttpMediaTypeNotAcceptableException o_O) {
                exception = o_O;
            }
            catch (HttpRequestMethodNotSupportedException o_O) {
                exception = o_O;
            }
            catch (UnsatisfiedServletRequestParameterException o_O) {
                exception = o_O;
            }
        }
        if (exception != null) {
            throw exception;
        }
        return null;
    }
}

