/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.convert;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.util.StringUtils;

public enum StringToDistanceConverter implements Converter<String, Distance>
{
    INSTANCE;

    private static final Map<String, Metric> SUPPORTED_METRICS;
    private static final String INVALID_DISTANCE = "Expected double amount optionally followed by a metrics abbreviation (%s) but got '%s'!";

    public Distance convert(String source) {
        source = source.trim();
        for (Map.Entry<String, Metric> metric : SUPPORTED_METRICS.entrySet()) {
            if (!source.endsWith(metric.getKey())) continue;
            return this.fromString(source, metric);
        }
        try {
            return new Distance(Double.parseDouble(source));
        }
        catch (NumberFormatException o_O) {
            throw new IllegalArgumentException(String.format(INVALID_DISTANCE, StringUtils.collectionToCommaDelimitedString(SUPPORTED_METRICS.keySet()), source));
        }
    }

    private Distance fromString(String source, Map.Entry<String, Metric> metric) {
        String amountString = source.substring(0, source.indexOf(metric.getKey()));
        try {
            return new Distance(Double.parseDouble(amountString), metric.getValue());
        }
        catch (NumberFormatException o_O) {
            throw new IllegalArgumentException(String.format(INVALID_DISTANCE, StringUtils.collectionToCommaDelimitedString(SUPPORTED_METRICS.keySet()), source));
        }
    }

    static {
        LinkedHashMap<String, Metrics> metrics = new LinkedHashMap<String, Metrics>();
        metrics.put("km", Metrics.KILOMETERS);
        metrics.put("miles", Metrics.MILES);
        metrics.put("mile", Metrics.MILES);
        SUPPORTED_METRICS = Collections.unmodifiableMap(metrics);
    }
}

