/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.SimpleAssociationHandler;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.mapping.AssociationLinks;
import org.springframework.data.rest.webmvc.support.Projector;
import org.springframework.hateoas.EntityLinks;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.core.EmbeddedWrapper;
import org.springframework.hateoas.core.EmbeddedWrappers;
import org.springframework.util.Assert;

public class PersistentEntityResourceAssembler
implements ResourceAssembler<Object, PersistentEntityResource> {
    private final Repositories repositories;
    private final EntityLinks entityLinks;
    private final Projector projector;
    private final ResourceMappings mappings;
    private final EmbeddedWrappers wrappers = new EmbeddedWrappers(false);

    public PersistentEntityResourceAssembler(Repositories repositories, EntityLinks entityLinks, Projector projector, ResourceMappings mappings) {
        Assert.notNull((Object)repositories, (String)"Repositories must not be null!");
        Assert.notNull((Object)entityLinks, (String)"EntityLinks must not be null!");
        Assert.notNull((Object)projector, (String)"PersistentEntityProjector must not be be null!");
        Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null!");
        this.repositories = repositories;
        this.entityLinks = entityLinks;
        this.projector = projector;
        this.mappings = mappings;
    }

    public PersistentEntityResource toResource(Object instance) {
        Assert.notNull((Object)instance, (String)"Entity instance must not be null!");
        return this.wrap(this.projector.projectExcerpt(instance), instance).build();
    }

    public PersistentEntityResource toFullResource(Object instance) {
        Assert.notNull((Object)instance, (String)"Entity instance must not be null!");
        return this.wrap(this.projector.project(instance), instance).renderAllAssociationLinks().build();
    }

    private PersistentEntityResource.Builder wrap(Object instance, Object source) {
        PersistentEntity entity = this.repositories.getPersistentEntity(source.getClass());
        return PersistentEntityResource.build(instance, entity).withEmbedded(this.getEmbeddedResources(source)).withLink(this.getSelfLinkFor(source));
    }

    private Iterable<EmbeddedWrapper> getEmbeddedResources(Object instance) {
        Assert.notNull((Object)instance, (String)"Entity instance must not be null!");
        PersistentEntity entity = this.repositories.getPersistentEntity(instance.getClass());
        final ArrayList<EmbeddedWrapper> associationProjections = new ArrayList<EmbeddedWrapper>();
        final BeanWrapper wrapper = BeanWrapper.create((Object)instance, null);
        final AssociationLinks associationLinks = new AssociationLinks(this.mappings);
        final ResourceMetadata metadata = this.mappings.getMappingFor(instance.getClass());
        entity.doWithAssociations(new SimpleAssociationHandler(){

            public void doWithAssociation(Association<? extends PersistentProperty<?>> association) {
                PersistentProperty property = association.getInverse();
                if (!associationLinks.isLinkableAssociation(property)) {
                    return;
                }
                if (!PersistentEntityResourceAssembler.this.projector.hasExcerptProjection(property.getActualType())) {
                    return;
                }
                Object value = wrapper.getProperty(association.getInverse());
                if (value == null) {
                    return;
                }
                String rel = metadata.getMappingFor(property).getRel();
                if (value instanceof Collection) {
                    Collection collection = (Collection)value;
                    if (collection.isEmpty()) {
                        return;
                    }
                    ArrayList<Object> nestedCollection = new ArrayList<Object>();
                    for (Object element : collection) {
                        if (element == null) continue;
                        nestedCollection.add(PersistentEntityResourceAssembler.this.projector.projectExcerpt(element));
                    }
                    associationProjections.add(PersistentEntityResourceAssembler.this.wrappers.wrap(nestedCollection, rel));
                } else {
                    associationProjections.add(PersistentEntityResourceAssembler.this.wrappers.wrap(PersistentEntityResourceAssembler.this.projector.projectExcerpt(value), rel));
                }
            }
        });
        return associationProjections;
    }

    public Link getSelfLinkFor(Object instance) {
        Assert.notNull((Object)instance, (String)"Domain object must not be null!");
        Class<?> instanceType = instance.getClass();
        PersistentEntity entity = this.repositories.getPersistentEntity(instanceType);
        if (entity == null) {
            throw new IllegalArgumentException(String.format("Cannot create self link for %s! No persistent entity found!", instanceType));
        }
        BeanWrapper wrapper = BeanWrapper.create((Object)instance, null);
        Object id = wrapper.getProperty(entity.getIdProperty());
        Link resourceLink = this.entityLinks.linkToSingleResource(entity.getType(), id);
        return new Link(resourceLink.getHref(), "self");
    }
}

