/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.springframework.data.rest.webmvc.RepositoryRestDispatcherServlet;

public abstract class HttpRequestUtils {
    public static String stripRegistrationMapping(String requestUri, ServletContext ctx) {
        for (ServletRegistration reg : ctx.getServletRegistrations().values()) {
            if (!reg.getClassName().equals(RepositoryRestDispatcherServlet.class.getName()) && !reg.getName().equals("rest-exporter")) continue;
            for (String mapping : reg.getMappings()) {
                if (mapping.contains("*")) {
                    mapping = mapping.substring(0, mapping.indexOf(42));
                }
                if (!requestUri.startsWith(mapping)) continue;
                return requestUri.replaceAll(mapping, "");
            }
        }
        return requestUri;
    }
}

