/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.CollectionDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerBuilder;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.SimpleAssociationHandler;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.UriToEntityConverter;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.support.RepositoryLinkBuilder;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.util.Assert;

public class PersistentEntityJackson2Module
extends SimpleModule {
    private static final long serialVersionUID = -7289265674870906323L;
    private static final Logger LOG = LoggerFactory.getLogger(PersistentEntityJackson2Module.class);
    private static final TypeDescriptor URI_DESCRIPTOR = TypeDescriptor.valueOf(URI.class);

    public PersistentEntityJackson2Module(ResourceMappings mappings, Repositories repositories, RepositoryRestConfiguration config, UriToEntityConverter converter) {
        super(new Version(2, 0, 0, null, "org.springframework.data.rest", "jackson-module"));
        Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null!");
        Assert.notNull((Object)repositories, (String)"Repositories must not be null!");
        Assert.notNull((Object)config, (String)"RepositoryRestConfiguration must not be null!");
        Assert.notNull((Object)converter, (String)"UriToEntityConverter must not be null!");
        this.addSerializer((JsonSerializer)new PersistentEntityResourceSerializer(mappings, config));
        this.setSerializerModifier(new AssociationOmittingSerializerModifier(repositories, mappings, config));
        this.setDeserializerModifier(new AssociationUriResolvingDeserializerModifier(repositories, converter, mappings));
    }

    public static boolean maybeAddAssociationLink(RepositoryLinkBuilder builder, ResourceMappings mappings, PersistentProperty<?> persistentProperty, List<Link> links) {
        Assert.isTrue((boolean)persistentProperty.isAssociation(), (String)"PersistentProperty must be an association!");
        ResourceMetadata ownerMetadata = mappings.getMappingFor(persistentProperty.getOwner().getType());
        if (!ownerMetadata.isManagedResource(persistentProperty)) {
            return false;
        }
        ResourceMapping propertyMapping = ownerMetadata.getMappingFor(persistentProperty);
        if (propertyMapping.isExported()) {
            links.add(builder.slash(propertyMapping.getPath()).withRel(propertyMapping.getRel()));
            return true;
        }
        return false;
    }

    private static class CollectionValueInstantiator
    extends ValueInstantiator {
        private final PersistentProperty<?> property;

        public CollectionValueInstantiator(PersistentProperty<?> property) {
            Assert.notNull(property, (String)"Property must not be null!");
            Assert.isTrue((property.isCollectionLike() || property.isMap() ? 1 : 0) != 0, (String)"Property must be a collection or map property!");
            this.property = property;
        }

        public String getValueTypeDesc() {
            return this.property.getType().getName();
        }

        public Object createUsingDefault(DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Class collectionOrMapType = this.property.getType();
            return this.property.isMap() ? CollectionFactory.createMap((Class)collectionOrMapType, (int)0) : CollectionFactory.createCollection((Class)collectionOrMapType, (int)0);
        }
    }

    private static class UriStringDeserializer
    extends StdDeserializer<Object> {
        private static final long serialVersionUID = -2175900204153350125L;
        private final PersistentProperty<?> property;
        private final UriToEntityConverter converter;

        public UriStringDeserializer(PersistentProperty<?> property, UriToEntityConverter converter) {
            super(property.getActualType());
            this.property = property;
            this.converter = converter;
        }

        public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String uriString = jp.getValueAsString();
            TypeDescriptor typeDescriptor = TypeDescriptor.valueOf((Class)this.property.getActualType());
            return this.converter.convert((Object)URI.create(uriString), URI_DESCRIPTOR, typeDescriptor);
        }
    }

    private static class AssociationUriResolvingDeserializerModifier
    extends BeanDeserializerModifier {
        private final UriToEntityConverter converter;
        private final Repositories repositories;
        private final ResourceMappings mappings;

        public AssociationUriResolvingDeserializerModifier(Repositories repositories, UriToEntityConverter converter, ResourceMappings mappings) {
            Assert.notNull((Object)repositories, (String)"Repositories must not be null!");
            Assert.notNull((Object)converter, (String)"UriToEntityConverter must not be null!");
            Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null!");
            this.repositories = repositories;
            this.converter = converter;
            this.mappings = mappings;
        }

        public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, BeanDescription beanDesc, BeanDeserializerBuilder builder) {
            Iterator properties = builder.getProperties();
            PersistentEntity entity = this.repositories.getPersistentEntity(beanDesc.getBeanClass());
            ResourceMetadata metadata = this.mappings.getMappingFor(beanDesc.getBeanClass());
            if (entity == null) {
                return builder;
            }
            while (properties.hasNext()) {
                SettableBeanProperty property = (SettableBeanProperty)properties.next();
                PersistentProperty persistentProperty = entity.getPersistentProperty(property.getName());
                ResourceMapping propertyMapping = metadata.getMappingFor(persistentProperty);
                if (!persistentProperty.isAssociation() || !propertyMapping.isExported()) continue;
                UriStringDeserializer uriStringDeserializer = new UriStringDeserializer(persistentProperty, this.converter);
                if (persistentProperty.isCollectionLike()) {
                    CollectionLikeType collectionType = config.getTypeFactory().constructCollectionLikeType(persistentProperty.getType(), persistentProperty.getActualType());
                    CollectionValueInstantiator instantiator = new CollectionValueInstantiator(persistentProperty);
                    CollectionDeserializer collectionDeserializer = new CollectionDeserializer((JavaType)collectionType, (JsonDeserializer)uriStringDeserializer, null, (ValueInstantiator)instantiator);
                    builder.addOrReplaceProperty(property.withValueDeserializer((JsonDeserializer)collectionDeserializer), false);
                    continue;
                }
                builder.addOrReplaceProperty(property.withValueDeserializer((JsonDeserializer)uriStringDeserializer), false);
            }
            return builder;
        }
    }

    private static class AssociationOmittingSerializerModifier
    extends BeanSerializerModifier {
        private final Repositories repositories;
        private final ResourceMappings mappings;
        private final RepositoryRestConfiguration configuration;

        private AssociationOmittingSerializerModifier(Repositories repositories, ResourceMappings mappings, RepositoryRestConfiguration configuration) {
            this.repositories = repositories;
            this.mappings = mappings;
            this.configuration = configuration;
        }

        public BeanSerializerBuilder updateBuilder(SerializationConfig config, BeanDescription beanDesc, BeanSerializerBuilder builder) {
            PersistentEntity entity = this.repositories.getPersistentEntity(beanDesc.getBeanClass());
            if (entity == null) {
                return builder;
            }
            ArrayList<BeanPropertyWriter> result = new ArrayList<BeanPropertyWriter>();
            ResourceMetadata resourceMetadata = this.mappings.getMappingFor(entity.getType());
            for (BeanPropertyWriter writer : builder.getProperties()) {
                PersistentProperty persistentProperty = entity.getPersistentProperty(writer.getName());
                if (persistentProperty != null && (persistentProperty.isAssociation() && resourceMetadata.isExported(persistentProperty) || persistentProperty.isIdProperty() && !this.configuration.isIdExposedFor(entity.getType()))) continue;
                result.add(writer);
            }
            builder.setProperties(result);
            return builder;
        }
    }

    private static class PersistentEntityResourceSerializer
    extends StdSerializer<PersistentEntityResource<?>> {
        private final ResourceMappings mappings;
        private final RepositoryRestConfiguration configuration;

        private PersistentEntityResourceSerializer(ResourceMappings mappings, RepositoryRestConfiguration configuration) {
            super(PersistentEntityResource.class);
            Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null!");
            Assert.notNull((Object)configuration, (String)"RepositoryRestConfiguration must not be null!");
            this.mappings = mappings;
            this.configuration = configuration;
        }

        public void serialize(PersistentEntityResource<?> resource, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Serializing PersistentEntity " + resource.getPersistentEntity());
            }
            Object obj = resource.getContent();
            PersistentEntity<?, PersistentProperty<?>> entity = resource.getPersistentEntity();
            BeanWrapper wrapper = BeanWrapper.create((Object)obj, null);
            Object entityId = wrapper.getProperty(entity.getIdProperty());
            ResourceMetadata metadata = this.mappings.getMappingFor(entity.getType());
            URI baseUri = this.configuration.getBaseUri();
            final RepositoryLinkBuilder builder = new RepositoryLinkBuilder(metadata, baseUri).slash(entityId);
            final ArrayList links = new ArrayList();
            links.addAll(resource.getLinks());
            entity.doWithAssociations(new SimpleAssociationHandler(){

                public void doWithAssociation(Association<? extends PersistentProperty<?>> association) {
                    PersistentProperty property = association.getInverse();
                    PersistentEntityJackson2Module.maybeAddAssociationLink(builder, PersistentEntityResourceSerializer.this.mappings, property, links);
                }
            });
            Resource resourceToRender = new Resource(obj, links);
            provider.defaultSerializeValue((Object)resourceToRender, jgen);
        }
    }
}

