/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.Assert;

public class RepositoryRestConfiguration {
    public static final RepositoryRestConfiguration DEFAULT = new RepositoryRestConfiguration();
    private URI baseUri = null;
    private int defaultPageSize = 20;
    private String pageParamName = "page";
    private String limitParamName = "limit";
    private String sortParamName = "sort";
    private String jsonpParamName = "callback";
    private String jsonpOnErrParamName = null;
    private List<HttpMessageConverter<?>> customConverters = Collections.emptyList();
    private Map<Class<?>, Class<?>> typeMappings = Collections.emptyMap();
    private MediaType defaultMediaType = MediaType.APPLICATION_JSON;
    private boolean dumpErrors = true;

    public URI getBaseUri() {
        return this.baseUri;
    }

    public RepositoryRestConfiguration setBaseUri(URI baseUri) {
        Assert.notNull((Object)baseUri, (String)"The baseUri cannot be null.");
        this.baseUri = baseUri;
        return this;
    }

    public int getDefaultPageSize() {
        return this.defaultPageSize;
    }

    public RepositoryRestConfiguration setDefaultPageSize(int defaultPageSize) {
        Assert.isTrue((defaultPageSize > 0 ? 1 : 0) != 0, (String)"Page size must be greater than 0.");
        this.defaultPageSize = defaultPageSize;
        return this;
    }

    public String getPageParamName() {
        return this.pageParamName;
    }

    public RepositoryRestConfiguration setPageParamName(String pageParamName) {
        Assert.notNull((Object)pageParamName, (String)"Page param name cannot be null.");
        this.pageParamName = pageParamName;
        return this;
    }

    public String getLimitParamName() {
        return this.limitParamName;
    }

    public RepositoryRestConfiguration setLimitParamName(String limitParamName) {
        Assert.notNull((Object)limitParamName, (String)"Limit param name cannot be null.");
        this.limitParamName = limitParamName;
        return this;
    }

    public String getSortParamName() {
        return this.sortParamName;
    }

    public RepositoryRestConfiguration setSortParamName(String sortParamName) {
        Assert.notNull((Object)sortParamName, (String)"Sort param name cannot be null.");
        this.sortParamName = sortParamName;
        return this;
    }

    public List<HttpMessageConverter<?>> getCustomConverters() {
        return this.customConverters;
    }

    public RepositoryRestConfiguration setCustomConverters(List<HttpMessageConverter<?>> customConverters) {
        Assert.notNull(customConverters, (String)"Custom converters list cannot be null.");
        this.customConverters = customConverters;
        return this;
    }

    public Map<Class<?>, Class<?>> getDomainTypeToRepositoryMappings() {
        return this.typeMappings;
    }

    public RepositoryRestConfiguration setDomainTypeToRepositoryMappings(Map<Class<?>, Class<?>> typeMappings) {
        this.typeMappings = typeMappings;
        return this;
    }

    public String getJsonpParamName() {
        return this.jsonpParamName;
    }

    public RepositoryRestConfiguration setJsonpParamName(String jsonpParamName) {
        this.jsonpParamName = jsonpParamName;
        return this;
    }

    public String getJsonpOnErrParamName() {
        return this.jsonpOnErrParamName;
    }

    public RepositoryRestConfiguration setJsonpOnErrParamName(String jsonpOnErrParamName) {
        this.jsonpOnErrParamName = jsonpOnErrParamName;
        return this;
    }

    public MediaType getDefaultMediaType() {
        return this.defaultMediaType;
    }

    public RepositoryRestConfiguration setDefaultMediaType(MediaType defaultMediaType) {
        this.defaultMediaType = defaultMediaType;
        return this;
    }

    public boolean isDumpErrors() {
        return this.dumpErrors;
    }

    public RepositoryRestConfiguration setDumpErrors(boolean dumpErrors) {
        this.dumpErrors = dumpErrors;
        return this;
    }
}

