/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.rest.repository.RepositoryExporter;
import org.springframework.data.rest.repository.RepositoryMetadata;
import org.springframework.data.rest.repository.UriToDomainObjectUriResolver;
import org.springframework.data.rest.webmvc.MediaTypes;
import org.springframework.data.rest.webmvc.json.RepositoryAwareJacksonModule;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.json.MappingJacksonHttpMessageConverter;

public class RepositoryAwareMappingHttpMessageConverter
extends MappingJacksonHttpMessageConverter
implements ApplicationEventPublisherAware,
InitializingBean {
    private final ObjectMapper mapper = new ObjectMapper();
    @Autowired(required=false)
    protected List<ConversionService> conversionServices = Arrays.asList(new DefaultFormattingConversionService());
    @Autowired(required=false)
    protected List<RepositoryExporter> repositoryExporters = Collections.emptyList();
    @Autowired(required=false)
    protected List<Module> modules = Collections.emptyList();
    @Autowired
    protected UriToDomainObjectUriResolver domainObjectResolver = null;
    @Autowired
    protected RepositoryAwareJacksonModule jacksonModule = null;
    protected ApplicationEventPublisher eventPublisher = null;

    public RepositoryAwareMappingHttpMessageConverter() {
        this.setSupportedMediaTypes(Arrays.asList(MediaType.APPLICATION_JSON, MediaTypes.COMPACT_JSON, MediaTypes.VERBOSE_JSON));
        this.setObjectMapper(this.mapper);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    public void afterPropertiesSet() throws Exception {
        boolean builtInModuleRegistered = false;
        for (Module m : this.modules) {
            this.mapper.registerModule(m);
            if (m.getClass() != RepositoryAwareJacksonModule.class) continue;
            builtInModuleRegistered = true;
        }
        if (!builtInModuleRegistered) {
            this.mapper.registerModule((Module)this.jacksonModule);
        }
    }

    public List<ConversionService> getConversionServices() {
        return this.conversionServices;
    }

    public RepositoryAwareMappingHttpMessageConverter setConversionServices(List<ConversionService> conversionServices) {
        this.conversionServices = conversionServices;
        return this;
    }

    public List<RepositoryExporter> getRepositoryExporters() {
        return this.repositoryExporters;
    }

    public RepositoryAwareMappingHttpMessageConverter setRepositoryExporters(List<RepositoryExporter> repositoryExporters) {
        this.repositoryExporters = repositoryExporters;
        return this;
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public RepositoryAwareMappingHttpMessageConverter setModules(List<Module> modules) {
        this.modules = modules;
        return this;
    }

    public UriToDomainObjectUriResolver getDomainObjectResolver() {
        return this.domainObjectResolver;
    }

    public RepositoryAwareMappingHttpMessageConverter setDomainObjectResolver(UriToDomainObjectUriResolver domainObjectResolver) {
        this.domainObjectResolver = domainObjectResolver;
        return this;
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        if (!this.canWrite(mediaType)) {
            return false;
        }
        return this.supports(clazz);
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        if (!this.canRead(mediaType)) {
            return false;
        }
        return this.supports(clazz);
    }

    protected boolean supports(Class<?> clazz) {
        for (RepositoryExporter repoExp : this.repositoryExporters) {
            for (String repoName : new ArrayList(repoExp.repositoryNames())) {
                RepositoryMetadata repoMeta = repoExp.repositoryMetadataFor(repoName);
                Class domainType = repoMeta.entityMetadata().type();
                if (!domainType.isAssignableFrom(clazz)) continue;
                return true;
            }
        }
        return false;
    }

    protected void writeInternal(Object object, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        JsonEncoding encoding = this.getJsonEncoding(outputMessage.getHeaders().getContentType());
        JsonGenerator jsonGenerator = this.mapper.getJsonFactory().createJsonGenerator(outputMessage.getBody(), encoding).useDefaultPrettyPrinter();
        try {
            this.mapper.writeValue(jsonGenerator, object);
        }
        catch (IOException ex) {
            throw new HttpMessageNotWritableException("Could not write JSON: " + ex.getMessage(), (Throwable)ex);
        }
    }

    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        try {
            return this.mapper.readValue(inputMessage.getBody(), clazz);
        }
        catch (IOException ex) {
            throw new HttpMessageNotReadableException("Could not read JSON: " + ex.getMessage(), (Throwable)ex);
        }
    }
}

