/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.rest.core.util.UriUtils;
import org.springframework.data.rest.repository.AttributeMetadata;
import org.springframework.data.rest.repository.EntityMetadata;
import org.springframework.data.rest.repository.RepositoryMetadata;
import org.springframework.data.rest.webmvc.EntityResource;
import org.springframework.data.rest.webmvc.RepositoryRestConfiguration;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.util.Assert;

public class EntityToResourceConverter
implements Converter<Object, Resource> {
    private final RepositoryRestConfiguration config;
    private final RepositoryMetadata repositoryMetadata;
    private final EntityMetadata entityMetadata;

    public EntityToResourceConverter(RepositoryRestConfiguration config, RepositoryMetadata repositoryMetadata) {
        this.config = config;
        Assert.notNull((Object)repositoryMetadata, (String)"RepositoryMetadata cannot be null!");
        this.repositoryMetadata = repositoryMetadata;
        this.entityMetadata = repositoryMetadata.entityMetadata();
    }

    public Resource convert(Object source) {
        if (null == this.repositoryMetadata || null == source) {
            return new Resource(source, new Link[0]);
        }
        Serializable id = (Serializable)this.repositoryMetadata.entityMetadata().idAttribute().get(source);
        URI selfUri = UriUtils.buildUri((URI)this.config.getBaseUri(), (String[])new String[]{this.repositoryMetadata.name(), id.toString()});
        HashSet<Link> links = new HashSet<Link>();
        for (Object attrName : this.entityMetadata.linkedAttributes().keySet()) {
            URI uri = UriUtils.buildUri((URI)selfUri, (String[])new String[]{attrName.toString()});
            String rel = this.repositoryMetadata.rel() + "." + source.getClass().getSimpleName() + "." + attrName;
            links.add(new Link(uri.toString(), rel));
        }
        links.add(new Link(selfUri.toString(), "self"));
        HashMap<String, Object> entityDto = new HashMap<String, Object>();
        for (Map.Entry attrMeta : this.entityMetadata.embeddedAttributes().entrySet()) {
            String name = (String)attrMeta.getKey();
            Object val = ((AttributeMetadata)attrMeta.getValue()).get(source);
            if (null == val) continue;
            entityDto.put(name, val);
        }
        return new EntityResource(entityDto, links);
    }
}

